/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.SimpleVerifier;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.TraceMethodVisitor;

public class VerifyClass
extends MatchingTask {
    private String topDir = null;
    private boolean verbose = false;

    public void execute() throws BuildException {
        if (this.topDir == null) {
            throw new BuildException("no dir attribute is set");
        }
        File top = new File(this.topDir);
        if (!top.exists()) {
            throw new BuildException("the directory " + top + " does not exist");
        }
        this.log("top dir is " + top);
        int fails = this.execute(top);
        if (fails == 0) {
            this.log("no bytecode problems found");
        } else {
            this.log("found " + fails + " failing classes");
        }
    }

    public void setDir(String dir) throws BuildException {
        this.topDir = dir;
    }

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    private int execute(File dir) {
        int fails = 0;
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            if (f.isDirectory()) {
                fails += this.execute(f);
                continue;
            }
            if (!f.getName().endsWith(".class")) continue;
            try {
                boolean ok = this.readClass(f.getCanonicalPath());
                if (ok) continue;
                ++fails;
                continue;
            }
            catch (IOException ioe) {
                this.log(ioe.getMessage());
                throw new BuildException((Throwable)ioe);
            }
        }
        return fails;
    }

    private boolean readClass(String clazz) throws IOException {
        ClassReader cr = new ClassReader((InputStream)new FileInputStream(clazz));
        ClassNode ca = new ClassNode(){

            public void visitEnd() {
            }
        };
        cr.accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)ca), 1);
        boolean failed = false;
        List methods = ca.methods;
        for (int i = 0; i < methods.size(); ++i) {
            MethodNode method = (MethodNode)methods.get(i);
            if (method.instructions.size() <= 0) continue;
            Analyzer a = new Analyzer((Interpreter)new SimpleVerifier());
            try {
                a.analyze(ca.name, method);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                final Frame[] frames = a.getFrames();
                if (!failed) {
                    failed = true;
                    this.log("verifying of class " + clazz + " failed");
                }
                if (this.verbose) {
                    this.log(method.name + method.desc);
                }
                TraceMethodVisitor mv = new TraceMethodVisitor(null){

                    public void visitMaxs(int maxStack, int maxLocals) {
                        StringBuffer buffer = new StringBuffer();
                        for (int i = 0; i < this.text.size(); ++i) {
                            String s;
                            String string = s = frames[i] == null ? "null" : frames[i].toString();
                            while (s.length() < maxStack + maxLocals + 1) {
                                s = s + " ";
                            }
                            buffer.append(Integer.toString(i + 100000).substring(1));
                            buffer.append(" ");
                            buffer.append(s);
                            buffer.append(" : ");
                            buffer.append(this.text.get(i));
                        }
                        if (VerifyClass.this.verbose) {
                            VerifyClass.this.log(buffer.toString());
                        }
                    }
                };
                for (int j = 0; j < method.instructions.size(); ++j) {
                    AbstractInsnNode insn = method.instructions.get(j);
                    if (insn instanceof AbstractInsnNode) {
                        insn.accept((MethodVisitor)mv);
                        continue;
                    }
                    mv.visitLabel((Label)insn);
                }
                mv.visitMaxs(method.maxStack, method.maxLocals);
            }
        }
        return !failed;
    }
}

