/*
 * Decompiled with CFR 0.152.
 */
package jodd.vtor.constraint;

import jodd.bean.BeanException;
import jodd.bean.BeanUtil;
import jodd.vtor.ValidationConstraint;
import jodd.vtor.ValidationConstraintContext;
import jodd.vtor.VtorException;
import jodd.vtor.constraint.EqualToDeclaredField;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqualToDeclaredFieldConstraint
implements ValidationConstraint<EqualToDeclaredField> {
    protected String fieldName;

    public EqualToDeclaredFieldConstraint() {
    }

    public EqualToDeclaredFieldConstraint(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    @Override
    public void configure(EqualToDeclaredField annotation) {
        this.fieldName = annotation.value();
    }

    @Override
    public boolean isValid(ValidationConstraintContext vcc, Object value) {
        return EqualToDeclaredFieldConstraint.validate(vcc.getTarget(), value, this.fieldName);
    }

    public static boolean validate(Object target, Object value, String fieldName) {
        Object valueToCompare;
        if (value == null) {
            return true;
        }
        try {
            valueToCompare = BeanUtil.getDeclaredProperty(target, fieldName);
        }
        catch (BeanException bex) {
            throw new VtorException("Unable to read value to compare: " + fieldName, bex);
        }
        if (valueToCompare == null) {
            return false;
        }
        return value.equals(valueToCompare);
    }
}

