/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons.query.qom;

import javax.jcr.RepositoryException;
import javax.jcr.query.qom.Join;
import javax.jcr.query.qom.JoinCondition;
import javax.jcr.query.qom.QueryObjectModelFactory;
import javax.jcr.query.qom.Source;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JoinType {
    INNER("jcr.join.type.inner"),
    LEFT("jcr.join.type.left.outer"),
    RIGHT("jcr.join.type.right.outer");

    private final String name;

    private JoinType(String name) {
        this.name = name;
    }

    public Join join(QueryObjectModelFactory factory, Source left, Source right, JoinCondition condition) throws RepositoryException {
        return factory.join(left, right, this.name, condition);
    }

    public String toString() {
        return this.name;
    }

    public static JoinType getJoinTypeByName(String name) throws RepositoryException {
        for (JoinType type : JoinType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        throw new RepositoryException("Unknown join type name: " + name);
    }
}

