/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.WSDDMerger;
import com.liferay.portal.tools.servicebuilder.ServiceBuilder;
import com.liferay.portal.util.InitUtil;
import com.liferay.util.ant.Java2WsddTask;
import java.io.File;
import java.util.List;
import java.util.Map;

public class WSDDBuilder {
    private String _fileName;
    private String _outputPath;
    private String _packagePath;
    private String _portletShortName;
    private String _serverConfigFileName;
    private String _serviceNamespace;

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        InitUtil.initWithSpring();
        WSDDBuilder wsddBuilder = new WSDDBuilder();
        wsddBuilder._fileName = arguments.get("wsdd.input.file");
        wsddBuilder._outputPath = arguments.get("wsdd.output.path");
        wsddBuilder._serverConfigFileName = arguments.get("wsdd.server.config.file");
        wsddBuilder._serviceNamespace = arguments.get("wsdd.service.namespace");
        wsddBuilder.build();
    }

    public void build() throws Exception {
        if (!FileUtil.exists((String)this._serverConfigFileName)) {
            ClassLoader classLoader = this.getClass().getClassLoader();
            String serverConfigContent = StringUtil.read((ClassLoader)classLoader, (String)"com/liferay/portal/tools/dependencies/server-config.wsdd");
            FileUtil.write((String)this._serverConfigFileName, (String)serverConfigContent);
        }
        String content = ServiceBuilder.getContent(this._fileName);
        Document document = UnsecureSAXReaderUtil.read((String)content, (boolean)true);
        Element rootElement = document.getRootElement();
        String packagePath = rootElement.attributeValue("package-path");
        Element portletElement = rootElement.element("portlet");
        Element namespaceElement = rootElement.element("namespace");
        this._portletShortName = portletElement != null ? portletElement.attributeValue("short-name") : namespaceElement.getText();
        this._outputPath = String.valueOf(this._outputPath) + StringUtil.replace((String)packagePath, (String)".", (String)"/") + "/service/http";
        this._packagePath = packagePath;
        List entityElements = rootElement.elements("entity");
        for (Element entityElement : entityElements) {
            String entityName = entityElement.attributeValue("name");
            boolean remoteService = GetterUtil.getBoolean((String)entityElement.attributeValue("remote-service"), (boolean)true);
            if (!remoteService) continue;
            this._createServiceWSDD(entityName);
            WSDDMerger.merge(String.valueOf(this._outputPath) + "/" + entityName + "Service_deploy.wsdd", this._serverConfigFileName);
        }
    }

    public void setFileName(String fileName) {
        this._fileName = fileName;
    }

    public void setOutputPath(String outputPath) {
        this._outputPath = outputPath;
    }

    public void setServerConfigFileName(String serverConfigFileName) {
        this._serverConfigFileName = serverConfigFileName;
    }

    public void setServiceNamespace(String serviceNamespace) {
        this._serviceNamespace = serviceNamespace;
    }

    private void _createServiceWSDD(String entityName) throws Exception {
        String className = String.valueOf(this._packagePath) + ".service.http." + entityName + "ServiceSoap";
        String serviceName = StringUtil.replace((String)this._portletShortName, (String)" ", (String)"_");
        if (!this._portletShortName.equals("Portal")) {
            serviceName = String.valueOf(this._serviceNamespace) + "_" + serviceName;
        }
        serviceName = String.valueOf(serviceName) + "_" + entityName + "Service";
        String[] wsdds = Java2WsddTask.generateWsdd((String)className, (String)serviceName);
        FileUtil.write((File)new File(String.valueOf(this._outputPath) + "/" + entityName + "Service_deploy.wsdd"), (String)wsdds[0], (boolean)true);
        FileUtil.write((File)new File(String.valueOf(this._outputPath) + "/" + entityName + "Service_undeploy.wsdd"), (String)wsdds[1], (boolean)true);
    }
}

