/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.DocumentException;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.UnsecureSAXReaderUtil;
import com.liferay.portal.util.InitUtil;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class WSDDMerger {
    public static void main(String[] args) {
        InitUtil.initWithSpring();
        new WSDDMerger(args[0], args[1]);
    }

    public static void merge(String source, String destination) throws DocumentException, IOException {
        String name;
        File sourceFile = new File(source);
        Document document = UnsecureSAXReaderUtil.read((File)sourceFile);
        Element rootElement = document.getRootElement();
        List sourceServiceElements = rootElement.elements("service");
        if (sourceServiceElements.isEmpty()) {
            return;
        }
        File destinationFile = new File(destination);
        document = UnsecureSAXReaderUtil.read((File)destinationFile);
        rootElement = document.getRootElement();
        TreeMap<String, Element> servicesMap = new TreeMap<String, Element>();
        List serviceElements = rootElement.elements("service");
        for (Element element : serviceElements) {
            name = element.attributeValue("name");
            servicesMap.put(name, element);
            element.detach();
        }
        for (Element element : sourceServiceElements) {
            name = element.attributeValue("name");
            servicesMap.put(name, element);
            element.detach();
        }
        for (Map.Entry entry : servicesMap.entrySet()) {
            Element serviceElement = (Element)entry.getValue();
            rootElement.add(serviceElement);
        }
        String string2 = document.formattedString();
        string2 = StringUtil.replace((String)string2, (String)"\"/>", (String)"\" />");
        FileUtil.write((String)destination, (String)string2, (boolean)true);
    }

    public WSDDMerger(String source, String destination) {
        try {
            WSDDMerger.merge(source, destination);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

