/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.verify;

import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Attribute;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.kernel.xml.XPath;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.verify.VerifyException;
import com.liferay.portal.verify.VerifyProcess;
import com.liferay.portlet.documentlibrary.NoSuchFolderException;
import com.liferay.portlet.documentlibrary.model.DLFileEntryMetadata;
import com.liferay.portlet.documentlibrary.model.DLFileVersion;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryLocalServiceUtil;
import com.liferay.portlet.documentlibrary.service.DLFileEntryMetadataLocalServiceUtil;
import com.liferay.portlet.documentlibrary.store.DLStoreUtil;
import com.liferay.portlet.dynamicdatalists.model.DDLRecord;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordModel;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordSet;
import com.liferay.portlet.dynamicdatalists.model.DDLRecordVersion;
import com.liferay.portlet.dynamicdatalists.service.DDLRecordLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructureLink;
import com.liferay.portlet.dynamicdatamapping.model.DDMTemplate;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLinkLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.service.DDMTemplateLocalServiceUtil;
import com.liferay.portlet.dynamicdatamapping.storage.Field;
import com.liferay.portlet.dynamicdatamapping.storage.Fields;
import com.liferay.portlet.dynamicdatamapping.storage.StorageEngineUtil;
import com.liferay.portlet.dynamicdatamapping.util.DDMXMLUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VerifyDynamicDataMapping
extends VerifyProcess {
    private static Log _log = LogFactoryUtil.getLog(VerifyDynamicDataMapping.class);
    private long _ddlRecordSetClassNameId;
    private long _ddmStructureClassNameId;
    private long _dlFileEntryMetadataClassNameId;

    protected FileEntry addFileEntry(long companyId, long userId, long groupId, long folderId, String fileName, String filePath, int status) throws Exception {
        String contentType = MimeTypesUtil.getContentType((String)fileName);
        String title = fileName;
        try {
            File file = DLStoreUtil.getFile((long)companyId, (long)0L, (String)filePath);
            ServiceContext serviceContext = this.createServiceContext();
            FileEntry fileEntry = DLAppLocalServiceUtil.addFileEntry((long)userId, (long)groupId, (long)folderId, (String)fileName, (String)contentType, (String)title, (String)"", (String)"", (File)file, (ServiceContext)serviceContext);
            this.updateFileEntryStatus(fileEntry, status, serviceContext);
            return fileEntry;
        }
        catch (Exception e2) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to add file entry " + fileName), (Throwable)e2);
            }
            return null;
        }
    }

    protected Folder addFolder(long userId, long groupId, long primaryKey, String fieldName) throws Exception {
        Folder ddmFolder = this.addFolder(userId, groupId, 0L, "DDM", "");
        Folder primaryKeyFolder = this.addFolder(userId, groupId, ddmFolder.getFolderId(), String.valueOf(primaryKey), "");
        return this.addFolder(userId, groupId, primaryKeyFolder.getFolderId(), fieldName, "");
    }

    protected Folder addFolder(long userId, long groupId, long parentFolderId, String name, String description) throws Exception {
        try {
            return DLAppLocalServiceUtil.getFolder((long)groupId, (long)parentFolderId, (String)name);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            return DLAppLocalServiceUtil.addFolder((long)userId, (long)groupId, (long)parentFolderId, (String)name, (String)description, (ServiceContext)this.createServiceContext());
        }
    }

    protected boolean checkDuplicateNames(DDMStructure structure) throws Exception {
        String xml = "<root>" + this.getFullStructureXML(structure, "") + "</root>";
        Document document = SAXReaderUtil.read((String)xml);
        Set<String> duplicateElementNames = this.getDuplicateElementNames(document.getRootElement(), new HashSet<String>(), new HashSet<String>());
        if (duplicateElementNames.isEmpty()) {
            return false;
        }
        if (!_log.isWarnEnabled()) {
            return true;
        }
        StringBundler sb = new StringBundler(duplicateElementNames.size() * 2 + 7);
        sb.append("Structure with class name ID ");
        sb.append(structure.getClassNameId());
        sb.append(" and structure key = ");
        sb.append(structure.getStructureKey());
        sb.append(" contains more than one element that is identified by the ");
        sb.append("same name either within itself or within any of its ");
        sb.append("parent structures. The duplicate element names are: ");
        for (String duplicateElementName : duplicateElementNames) {
            sb.append(duplicateElementName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        _log.warn((Object)sb.toString());
        return true;
    }

    protected boolean createDefaultMetadataElement(Element dynamicElementElement, String defaultLanguageId) {
        boolean hasDefaultMetadataElement = this.hasDefaultMetadataElement(dynamicElementElement, defaultLanguageId);
        if (hasDefaultMetadataElement) {
            return false;
        }
        Element metadataElement = dynamicElementElement.addElement("meta-data");
        metadataElement.addAttribute("locale", defaultLanguageId);
        Element entryElement = metadataElement.addElement("entry");
        entryElement.addAttribute("name", "label");
        entryElement.addCDATA("");
        return true;
    }

    protected ServiceContext createServiceContext() {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return serviceContext;
    }

    @Override
    protected void doVerify() throws Exception {
        this.setUpClassNameIds();
        List structures = DDMStructureLocalServiceUtil.getStructures();
        boolean duplicateExists = false;
        for (DDMStructure structure : structures) {
            if (!this.checkDuplicateNames(structure)) continue;
            duplicateExists = true;
        }
        if (duplicateExists) {
            throw new VerifyException("Duplicate element name found in structures");
        }
        for (DDMStructure structure : structures) {
            this.verifyStructure(structure);
        }
    }

    protected Set<String> getDuplicateElementNames(Element element, Set<String> elementNames, Set<String> duplicateElementNames) {
        String elementName = element.attributeValue("name");
        if (!elementNames.add(elementName)) {
            duplicateElementNames.add(elementName);
        }
        List dynamicElements = element.elements("dynamic-element");
        for (Element dynamicElement : dynamicElements) {
            duplicateElementNames = this.getDuplicateElementNames(dynamicElement, elementNames, duplicateElementNames);
        }
        return duplicateElementNames;
    }

    protected String getFileUploadPath(BaseModel<?> baseModel) throws Exception {
        StringBundler sb = new StringBundler(7);
        long primaryKey = 0L;
        String version = "";
        if (baseModel instanceof DDLRecordModel) {
            DDLRecord ddlRecord = (DDLRecord)baseModel;
            primaryKey = ddlRecord.getPrimaryKey();
            DDLRecordVersion ddlRecordVersion = ddlRecord.getRecordVersion();
            version = ddlRecordVersion.getVersion();
        } else {
            DLFileEntryMetadata dlFileEntryMetadata = (DLFileEntryMetadata)baseModel;
            primaryKey = dlFileEntryMetadata.getPrimaryKey();
            DLFileVersion dlFileVersion = dlFileEntryMetadata.getFileVersion();
            version = dlFileVersion.getVersion();
        }
        sb.append("ddm");
        sb.append("/");
        sb.append(baseModel.getModelClassName());
        sb.append("/");
        sb.append(primaryKey);
        sb.append("/");
        sb.append(version);
        return sb.toString();
    }

    protected String getFullStructureXML(DDMStructure structure, String xml) throws Exception {
        if (structure.getParentStructureId() != 0L) {
            DDMStructure parentStructure = DDMStructureLocalServiceUtil.getStructure((long)structure.getParentStructureId());
            xml = this.getFullStructureXML(parentStructure, xml);
        }
        Document document = SAXReaderUtil.read((String)structure.getXsd());
        Element rootElement = document.getRootElement();
        List dynamicElements = rootElement.elements("dynamic-element");
        for (Element dynamicElement : dynamicElements) {
            xml = String.valueOf(xml) + dynamicElement.asXML();
        }
        return xml;
    }

    protected String getJSON(FileEntry fileEntry) {
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject();
        jsonObject.put("groupId", fileEntry.getGroupId());
        jsonObject.put("uuid", fileEntry.getUuid());
        return jsonObject.toString();
    }

    protected long getUserId(AuditedModel auditedModel) throws Exception {
        User user = UserLocalServiceUtil.fetchUser((long)auditedModel.getUserId());
        if (user != null) {
            return user.getUserId();
        }
        User defaultUser = UserLocalServiceUtil.getDefaultUser((long)auditedModel.getCompanyId());
        if (_log.isWarnEnabled()) {
            _log.warn((Object)("Using default user " + defaultUser.getUserId() + " for audited model " + auditedModel.getModelClassName() + " with primary key " + auditedModel.getPrimaryKeyObj()));
        }
        return defaultUser.getUserId();
    }

    protected boolean hasDefaultMetadataElement(Element dynamicElementElement, String defaultLanguageId) {
        List metadataElements = dynamicElementElement.elements("meta-data");
        for (Element metadataElement : metadataElements) {
            String languageId = metadataElement.attributeValue("locale");
            if (!languageId.equals(defaultLanguageId)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasFileUploadFields(DDMStructure structure) throws Exception {
        Map fieldsMap = structure.getFieldsMap();
        for (Map field : fieldsMap.values()) {
            String dataType = (String)field.get("dataType");
            if (!dataType.equals("file-upload")) continue;
            return true;
        }
        return false;
    }

    protected void setUpClassNameIds() {
        this._ddlRecordSetClassNameId = PortalUtil.getClassNameId(DDLRecordSet.class);
        this._ddmStructureClassNameId = PortalUtil.getClassNameId(DDMStructure.class);
        this._dlFileEntryMetadataClassNameId = PortalUtil.getClassNameId(DLFileEntryMetadata.class);
    }

    protected void updateDDLFileUploadReferences(long ddlRecordSetId) throws Exception {
        List ddlRecords = DDLRecordLocalServiceUtil.getRecords((long)ddlRecordSetId);
        for (DDLRecord ddlRecord : ddlRecords) {
            this.updateFileUploadReferences(ddlRecord.getCompanyId(), ddlRecord.getDDMStorageId(), this.getUserId((AuditedModel)ddlRecord), ddlRecord.getGroupId(), (BaseModel<?>)ddlRecord, ddlRecord.getStatus());
        }
    }

    protected void updateDLFileUploadReferences(long dlFileEntryMetadataId) throws Exception {
        DLFileEntryMetadata dlFileEntryMetadata = DLFileEntryMetadataLocalServiceUtil.getFileEntryMetadata((long)dlFileEntryMetadataId);
        FileEntry fileEntry = DLAppLocalServiceUtil.getFileEntry((long)dlFileEntryMetadata.getFileEntryId());
        FileVersion fileVersion = fileEntry.getFileVersion();
        this.updateFileUploadReferences(fileEntry.getCompanyId(), dlFileEntryMetadata.getDDMStorageId(), this.getUserId((AuditedModel)fileEntry), fileEntry.getGroupId(), (BaseModel<?>)dlFileEntryMetadata, fileVersion.getStatus());
    }

    protected void updateFieldValues(long storageId, Map<String, String> fieldValues) throws Exception {
        Fields fields = new Fields();
        for (Map.Entry<String, String> entry : fieldValues.entrySet()) {
            Field field = new Field(storageId, entry.getKey(), (Serializable)((Object)entry.getValue()));
            fields.put(field);
        }
        ServiceContext serviceContext = new ServiceContext();
        StorageEngineUtil.update((long)storageId, (Fields)fields, (boolean)true, (ServiceContext)serviceContext);
    }

    protected void updateFileEntryStatus(FileEntry fileEntry, int status, ServiceContext serviceContext) throws Exception {
        FileVersion fileVersion = fileEntry.getFileVersion();
        HashMap<String, String> workflowContext = new HashMap<String, String>();
        workflowContext.put("event", "add");
        DLFileEntryLocalServiceUtil.updateStatus((long)fileVersion.getUserId(), (long)fileVersion.getFileVersionId(), (int)status, workflowContext, (ServiceContext)serviceContext);
    }

    protected void updateFileUploadReferences(DDMStructure structure) throws Exception {
        if (!this.hasFileUploadFields(structure)) {
            return;
        }
        List structureLinks = DDMStructureLinkLocalServiceUtil.getStructureLinks((long)structure.getStructureId(), (int)-1, (int)-1);
        for (DDMStructureLink structureLink : structureLinks) {
            this.updateFileUploadReferences(structureLink);
        }
        List templates = DDMTemplateLocalServiceUtil.getTemplates((long)structure.getGroupId(), (long)this._ddmStructureClassNameId, (long)structure.getStructureId(), (String)"form");
        for (DDMTemplate template : templates) {
            this.updateTemplate(template, this.updateXSD(template.getScript()));
        }
    }

    protected void updateFileUploadReferences(DDMStructureLink structureLink) throws Exception {
        long classNameId = structureLink.getClassNameId();
        if (classNameId == this._ddlRecordSetClassNameId) {
            this.updateDDLFileUploadReferences(structureLink.getClassPK());
        } else if (classNameId == this._dlFileEntryMetadataClassNameId) {
            this.updateDLFileUploadReferences(structureLink.getClassPK());
        }
    }

    protected void updateFileUploadReferences(long companyId, long storageId, long userId, long groupId, BaseModel<?> baseModel, int status) throws Exception {
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        Fields fields = StorageEngineUtil.getFields((long)storageId);
        for (Field field : fields) {
            String dataType = field.getDataType();
            if (!dataType.equals("file-upload") || Validator.isNull((Object)field.getValue())) continue;
            long primaryKey = GetterUtil.getLong((Object)baseModel.getPrimaryKeyObj());
            Folder folder = this.addFolder(userId, groupId, primaryKey, field.getName());
            String valueString = String.valueOf(field.getValue());
            JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)valueString);
            String filePath = String.valueOf(this.getFileUploadPath(baseModel)) + "/" + field.getName();
            FileEntry fileEntry = this.addFileEntry(companyId, userId, groupId, folder.getFolderId(), jsonObject.getString("name"), filePath, status);
            if (fileEntry == null) continue;
            fieldValues.put(field.getName(), this.getJSON(fileEntry));
        }
        this.updateFieldValues(storageId, fieldValues);
    }

    protected void updateStructure(DDMStructure structure, String xsd) throws Exception {
        xsd = DDMXMLUtil.formatXML((String)xsd);
        structure.setXsd(xsd);
        DDMStructureLocalServiceUtil.updateDDMStructure((DDMStructure)structure);
    }

    protected void updateTemplate(DDMTemplate template, String script) throws Exception {
        script = DDMXMLUtil.formatXML((String)script);
        template.setScript(script);
        DDMTemplateLocalServiceUtil.updateDDMTemplate((DDMTemplate)template);
    }

    protected String updateXSD(String xsd) throws Exception {
        Document document = SAXReaderUtil.read((String)xsd);
        Element rootElement = document.getRootElement();
        List dynamicElementElements = rootElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
        return document.asXML();
    }

    protected void updateXSDDynamicElement(Element element) {
        String dataType = element.attributeValue("dataType");
        if (Validator.equals((Object)dataType, (Object)"file-upload")) {
            element.addAttribute("dataType", "document-library");
            element.addAttribute("type", "ddm-documentlibrary");
        }
        List dynamicElementElements = element.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            this.updateXSDDynamicElement(dynamicElementElement);
        }
        Attribute attribute = element.attribute("autoGeneratedName");
        if (attribute != null) {
            element.remove(attribute);
        }
    }

    protected void verifyStructure(DDMStructure structure) throws Exception {
        this.updateFileUploadReferences(structure);
        this.updateStructure(structure, this.updateXSD(structure.getXsd()));
        boolean modified = false;
        String defaultLanguageId = structure.getDefaultLanguageId();
        XPath xPathSelector = SAXReaderUtil.createXPath((String)"//dynamic-element");
        Document document = structure.getDocument();
        List nodes = xPathSelector.selectNodes((Object)document);
        for (Node node : nodes) {
            Element dynamicElementElement = (Element)node;
            if (!this.createDefaultMetadataElement(dynamicElementElement, defaultLanguageId)) continue;
            modified = true;
        }
        if (modified) {
            this.updateStructure(structure, document.asXML());
        }
    }
}

