/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.blogs.atom;

import com.liferay.portal.atom.AtomPager;
import com.liferay.portal.atom.AtomUtil;
import com.liferay.portal.kernel.atom.AtomEntryContent;
import com.liferay.portal.kernel.atom.AtomRequestContext;
import com.liferay.portal.kernel.atom.BaseAtomCollectionAdapter;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.Image;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.service.ImageLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.blogs.model.BlogsEntry;
import com.liferay.portlet.blogs.service.BlogsEntryServiceUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class BlogsEntryAtomCollectionAdapter
extends BaseAtomCollectionAdapter<BlogsEntry> {
    private static final String _COLLECTION_NAME = "blogs";

    public String getCollectionName() {
        return _COLLECTION_NAME;
    }

    public List<String> getEntryAuthors(BlogsEntry blogsEntry) {
        ArrayList<String> authors = new ArrayList<String>();
        authors.add(blogsEntry.getUserName());
        return authors;
    }

    public AtomEntryContent getEntryContent(BlogsEntry blogsEntry, AtomRequestContext atomRequestContext) {
        return new AtomEntryContent(blogsEntry.getContent());
    }

    public String getEntryId(BlogsEntry blogsEntry) {
        return String.valueOf(blogsEntry.getEntryId());
    }

    public String getEntrySummary(BlogsEntry blogsEntry) {
        return blogsEntry.getDescription();
    }

    public String getEntryTitle(BlogsEntry blogsEntry) {
        return blogsEntry.getTitle();
    }

    public Date getEntryUpdated(BlogsEntry blogsEntry) {
        return blogsEntry.getModifiedDate();
    }

    public String getFeedTitle(AtomRequestContext atomRequestContext) {
        return AtomUtil.createFeedTitleFromPortletName(atomRequestContext, "33");
    }

    protected void doDeleteEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long blogsEntryId = GetterUtil.getLong((String)resourceName);
        BlogsEntryServiceUtil.deleteEntry((long)blogsEntryId);
    }

    protected BlogsEntry doGetEntry(String resourceName, AtomRequestContext atomRequestContext) throws Exception {
        long blogsEntryId = GetterUtil.getLong((String)resourceName);
        return BlogsEntryServiceUtil.getEntry((long)blogsEntryId);
    }

    protected Iterable<BlogsEntry> doGetFeedEntries(AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        int status = 0;
        int max = atomRequestContext.getIntParameter("max", SearchContainer.DEFAULT_DELTA);
        if (groupId > 0L) {
            int page = atomRequestContext.getIntParameter("page");
            if (page == 0) {
                return BlogsEntryServiceUtil.getGroupEntries((long)groupId, (int)status, (int)max);
            }
            int count = BlogsEntryServiceUtil.getGroupEntriesCount((long)groupId, (Date)new Date(), (int)status);
            AtomPager atomPager = new AtomPager(page, max, count);
            AtomUtil.saveAtomPagerInRequest(atomRequestContext, atomPager);
            return BlogsEntryServiceUtil.getGroupEntries((long)groupId, (Date)new Date(), (int)status, (int)atomPager.getStart(), (int)(atomPager.getEnd() + 1));
        }
        long organizationId = atomRequestContext.getLongParameter("organizationId");
        if (organizationId > 0L) {
            return BlogsEntryServiceUtil.getOrganizationEntries((long)organizationId, (Date)new Date(), (int)status, (int)max);
        }
        long companyId = CompanyThreadLocal.getCompanyId();
        if (companyId > 0L) {
            return BlogsEntryServiceUtil.getCompanyEntries((long)companyId, (Date)new Date(), (int)status, (int)max);
        }
        return Collections.emptyList();
    }

    protected BlogsEntry doPostEntry(String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        long groupId = atomRequestContext.getLongParameter("groupId");
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        boolean allowPingbacks = true;
        boolean allowTrackbacks = true;
        String[] trackbacks = new String[]{};
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setScopeGroupId(groupId);
        return BlogsEntryServiceUtil.addEntry((String)title, (String)summary, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)allowPingbacks, (boolean)allowTrackbacks, (String[])trackbacks, (boolean)false, null, null, null, (ServiceContext)serviceContext);
    }

    protected void doPutEntry(BlogsEntry blogsEntry, String title, String summary, String content, Date date, AtomRequestContext atomRequestContext) throws Exception {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int displayDateMonth = cal.get(2);
        int displayDateDay = cal.get(5);
        int displayDateYear = cal.get(1);
        int displayDateHour = cal.get(11);
        int displayDateMinute = cal.get(12);
        String[] trackbacks = StringUtil.split((String)blogsEntry.getTrackbacks());
        String smallImageFileName = null;
        ByteArrayInputStream smallImageInputStream = null;
        try {
            Image smallImage;
            long smallImageId = blogsEntry.getSmallImageId();
            if (smallImageId != 0L && (smallImage = ImageLocalServiceUtil.getImage((long)smallImageId)) != null) {
                smallImageFileName = String.valueOf(smallImageId) + "." + blogsEntry.getSmallImageType();
                byte[] smallImageBytes = smallImage.getTextObj();
                smallImageInputStream = new ByteArrayInputStream(smallImageBytes);
            }
            ServiceContext serviceContext = new ServiceContext();
            BlogsEntryServiceUtil.updateEntry((long)blogsEntry.getEntryId(), (String)title, (String)summary, (String)content, (int)displayDateMonth, (int)displayDateDay, (int)displayDateYear, (int)displayDateHour, (int)displayDateMinute, (boolean)blogsEntry.getAllowPingbacks(), (boolean)blogsEntry.isAllowTrackbacks(), (String[])trackbacks, (boolean)blogsEntry.isSmallImage(), (String)blogsEntry.getSmallImageURL(), (String)smallImageFileName, (InputStream)smallImageInputStream, (ServiceContext)serviceContext);
        }
        catch (Throwable throwable) {
            StreamUtil.cleanUp(smallImageInputStream);
            throw throwable;
        }
        StreamUtil.cleanUp((InputStream)smallImageInputStream);
    }
}

