/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.lar;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lar.BaseStagedModelDataHandler;
import com.liferay.portal.kernel.lar.ExportImportPathUtil;
import com.liferay.portal.kernel.lar.PortletDataContext;
import com.liferay.portal.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.model.ClassedModel;
import com.liferay.portal.model.Repository;
import com.liferay.portal.model.RepositoryEntry;
import com.liferay.portal.model.StagedModel;
import com.liferay.portal.repository.liferayrepository.LiferayRepository;
import com.liferay.portal.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.service.RepositoryLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.documentlibrary.model.DLFolder;
import com.liferay.portlet.documentlibrary.service.DLAppLocalServiceUtil;
import java.util.List;

public class RepositoryStagedModelDataHandler
extends BaseStagedModelDataHandler<Repository> {
    public static final String[] CLASS_NAMES = new String[]{Repository.class.getName()};
    private static Log _log = LogFactoryUtil.getLog(RepositoryStagedModelDataHandler.class);

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException, SystemException {
        Repository repository = RepositoryLocalServiceUtil.fetchRepositoryByUuidAndGroupId((String)uuid, (long)groupId);
        if (repository != null) {
            RepositoryLocalServiceUtil.deleteRepository((long)repository.getRepositoryId());
        }
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public String getDisplayName(Repository repository) {
        return repository.getName();
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, Repository repository) throws Exception {
        Element repositoryElement = portletDataContext.getExportDataElement((ClassedModel)repository);
        Folder folder = DLAppLocalServiceUtil.getFolder((long)repository.getDlFolderId());
        if (folder.getModel() instanceof DLFolder) {
            DLFolder dlFolder = (DLFolder)folder.getModel();
            repositoryElement.addAttribute("hidden", String.valueOf(dlFolder.isHidden()));
        }
        portletDataContext.addClassedModel(repositoryElement, ExportImportPathUtil.getModelPath((StagedModel)repository), (ClassedModel)repository);
        List repositoryEntries = RepositoryEntryLocalServiceUtil.getRepositoryEntries((long)repository.getRepositoryId());
        for (RepositoryEntry repositoryEntry : repositoryEntries) {
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)repository, (StagedModel)repositoryEntry, (String)"child");
        }
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, Repository repository) throws Exception {
        Repository importedRepository;
        block8: {
            long userId = portletDataContext.getUserId(repository.getUserUuid());
            ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)repository);
            importedRepository = null;
            Element repositoryElement = portletDataContext.getImportDataStagedModelElement((StagedModel)repository);
            try {
                boolean hidden = GetterUtil.getBoolean((String)repositoryElement.attributeValue("hidden"));
                if (portletDataContext.isDataStrategyMirror()) {
                    Repository existingRepository = RepositoryLocalServiceUtil.fetchRepositoryByUuidAndGroupId((String)repository.getUuid(), (long)portletDataContext.getScopeGroupId());
                    if (existingRepository == null) {
                        existingRepository = RepositoryLocalServiceUtil.fetchRepository((long)portletDataContext.getScopeGroupId(), (String)repository.getName());
                    }
                    long classNameId = 0L;
                    if (existingRepository != null) {
                        classNameId = existingRepository.getClassNameId();
                    }
                    if (existingRepository == null || classNameId != PortalUtil.getClassNameId(LiferayRepository.class)) {
                        serviceContext.setUuid(repository.getUuid());
                        importedRepository = RepositoryLocalServiceUtil.addRepository((long)userId, (long)portletDataContext.getScopeGroupId(), (long)repository.getClassNameId(), (long)0L, (String)repository.getName(), (String)repository.getDescription(), (String)repository.getPortletId(), (UnicodeProperties)repository.getTypeSettingsProperties(), (boolean)hidden, (ServiceContext)serviceContext);
                    } else {
                        RepositoryLocalServiceUtil.updateRepository((long)existingRepository.getRepositoryId(), (String)repository.getName(), (String)repository.getDescription());
                        importedRepository = existingRepository;
                    }
                } else {
                    importedRepository = RepositoryLocalServiceUtil.addRepository((long)userId, (long)portletDataContext.getScopeGroupId(), (long)repository.getClassNameId(), (long)0L, (String)repository.getName(), (String)repository.getDescription(), (String)repository.getPortletId(), (UnicodeProperties)repository.getTypeSettingsProperties(), (boolean)hidden, (ServiceContext)serviceContext);
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block8;
                _log.warn((Object)("Unable to connect to repository {name=" + repository.getName() + ", typeSettings=" + repository.getTypeSettingsProperties() + "}"), (Throwable)e2);
            }
        }
        portletDataContext.importClassedModel((ClassedModel)repository, importedRepository);
        StagedModelDataHandlerUtil.importReferenceStagedModels((PortletDataContext)portletDataContext, (StagedModel)repository, RepositoryEntry.class);
    }
}

