/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.social.service.persistence;

import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.model.User;
import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.social.model.SocialActivityCounter;
import com.liferay.portlet.social.model.impl.SocialActivityCounterImpl;
import com.liferay.portlet.social.service.persistence.SocialActivityCounterFinder;
import com.liferay.portlet.social.util.SocialCounterPeriodUtil;
import com.liferay.util.dao.orm.CustomSQLUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SocialActivityCounterFinderImpl
extends BasePersistenceImpl<SocialActivityCounter>
implements SocialActivityCounterFinder {
    public static final String COUNT_U_BY_G_C_N_S_E = String.valueOf(SocialActivityCounterFinder.class.getName()) + ".countU_ByG_C_N_S_E";
    public static final String FIND_AC_BY_G_N_S_E_1 = String.valueOf(SocialActivityCounterFinder.class.getName()) + ".findAC_ByG_N_S_E_1";
    public static final String FIND_AC_BY_G_N_S_E_2 = String.valueOf(SocialActivityCounterFinder.class.getName()) + ".findAC_ByG_N_S_E_2";
    public static final String FIND_AC_BY_G_C_C_N_S_E = String.valueOf(SocialActivityCounterFinder.class.getName()) + ".findAC_By_G_C_C_N_S_E";
    public static final String FIND_U_BY_G_C_N_S_E = String.valueOf(SocialActivityCounterFinder.class.getName()) + ".findU_ByG_C_N_S_E";
    private static PortalCache<String, Serializable> _activityCounters = MultiVMPoolUtil.getCache((String)SocialActivityCounterFinder.class.getName());

    public int countU_ByG_N(long groupId, String[] names) throws SystemException {
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)COUNT_U_BY_G_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String)"[$NAME$]", (String)this.getNames(names));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(qPos, names);
            qPos.add(SocialCounterPeriodUtil.getPeriodLength());
            qPos.add(SocialCounterPeriodUtil.getActivityDay());
            Iterator itr = q.iterate();
            if (itr.hasNext() && (count = (Long)itr.next()) != null) {
                int n = count.intValue();
                return n;
            }
            return 0;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SocialActivityCounter> findAC_ByG_N_S_E_1(long groupId, String name, int startPeriod, int endPeriod, int periodLength) throws SystemException {
        StringBundler sb = new StringBundler(9);
        sb.append(groupId);
        sb.append("#");
        sb.append(name);
        sb.append("#");
        sb.append(startPeriod);
        sb.append("#");
        sb.append(endPeriod);
        sb.append("#");
        sb.append(periodLength);
        String key = sb.toString();
        ArrayList<SocialActivityCounter> activityCounters = null;
        if (endPeriod < SocialCounterPeriodUtil.getActivityDay()) {
            activityCounters = (ArrayList<SocialActivityCounter>)_activityCounters.get((Serializable)((Object)key));
        }
        if (activityCounters != null) {
            return activityCounters;
        }
        Session session = null;
        try {
            try {
                session = this.openSession();
                String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_N_S_E_1);
                SQLQuery q = session.createSQLQuery(sql);
                QueryPos qPos = QueryPos.getInstance((Query)q);
                qPos.add(groupId);
                qPos.add(name);
                qPos.add(startPeriod);
                qPos.add(endPeriod);
                qPos.add(periodLength);
                qPos.add(endPeriod);
                activityCounters = new ArrayList<SocialActivityCounter>();
                Iterator itr = q.iterate();
                while (itr.hasNext()) {
                    Object[] array = (Object[])itr.next();
                    SocialActivityCounterImpl activityCounter = new SocialActivityCounterImpl();
                    activityCounter.setName(GetterUtil.getString((Object)array[0]));
                    activityCounter.setCurrentValue(GetterUtil.getInteger((Object)array[1]));
                    activityCounter.setStartPeriod(GetterUtil.getInteger((Object)array[2]));
                    activityCounter.setEndPeriod(GetterUtil.getInteger((Object)array[3]));
                    activityCounters.add(activityCounter);
                }
            }
            catch (Exception e2) {
                throw new SystemException((Throwable)e2);
            }
        }
        finally {
            if (activityCounters == null) {
                _activityCounters.remove((Serializable)((Object)key));
            } else if (endPeriod < SocialCounterPeriodUtil.getActivityDay()) {
                _activityCounters.put((Serializable)((Object)key), (Object)activityCounters);
            }
            this.closeSession(session);
        }
        return activityCounters;
    }

    public List<SocialActivityCounter> findAC_ByG_N_S_E_2(long groupId, String counterName, int startPeriod, int endPeriod, int periodLength) throws SystemException {
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_N_S_E_2);
            SQLQuery q = session.createSQLQuery(sql);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(counterName);
            qPos.add(startPeriod);
            qPos.add(endPeriod);
            qPos.add(periodLength);
            qPos.add(endPeriod);
            ArrayList<SocialActivityCounter> activityCounters = new ArrayList<SocialActivityCounter>();
            Iterator itr = q.iterate();
            while (itr.hasNext()) {
                Object[] array = (Object[])itr.next();
                SocialActivityCounterImpl activityCounter = new SocialActivityCounterImpl();
                activityCounter.setClassNameId(GetterUtil.getLong((Object)array[0]));
                activityCounter.setName(GetterUtil.getString((Object)array[1]));
                activityCounter.setCurrentValue(GetterUtil.getInteger((Object)array[2]));
                activityCounters.add(activityCounter);
            }
            ArrayList<SocialActivityCounter> arrayList = activityCounters;
            return arrayList;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<SocialActivityCounter> findAC_By_G_C_C_N_S_E(long groupId, List<Long> userIds, String[] names, int start, int end) throws SystemException {
        if (names.length == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_AC_BY_G_C_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String[])new String[]{"[$CLASS_PK$]", "[$NAME$]"}, (String[])new String[]{StringUtil.merge(userIds), this.getNames(names)});
            SQLQuery q = session.createSQLQuery(sql);
            q.addEntity("SocialActivityCounter", SocialActivityCounterImpl.class);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(qPos, names);
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Long> findU_ByG_N(long groupId, String[] names, int start, int end) throws SystemException {
        if (names.length == 0) {
            return null;
        }
        Session session = null;
        try {
            session = this.openSession();
            String sql = CustomSQLUtil.get((String)FIND_U_BY_G_C_N_S_E);
            sql = StringUtil.replace((String)sql, (String)"[$NAME$]", (String)this.getNames(names));
            SQLQuery q = session.createSQLQuery(sql);
            q.addScalar("classPK", Type.LONG);
            QueryPos qPos = QueryPos.getInstance((Query)q);
            qPos.add(groupId);
            qPos.add(PortalUtil.getClassNameId((String)User.class.getName()));
            this.setNames(qPos, names);
            qPos.add(SocialCounterPeriodUtil.getStartPeriod());
            List list = QueryUtil.list((Query)q, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception e2) {
            throw new SystemException((Throwable)e2);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected String getNames(String[] names) {
        if (names.length == 0) {
            return "";
        }
        StringBundler sb = new StringBundler(names.length * 2 - 1);
        int i2 = 0;
        while (i2 < names.length) {
            sb.append("?");
            if (i2 + 1 < names.length) {
                sb.append(",");
            }
            ++i2;
        }
        return sb.toString();
    }

    protected void setNames(QueryPos qPos, String[] names) {
        if (ArrayUtil.isNotEmpty((Object[])names)) {
            String[] stringArray = names;
            int n = names.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                qPos.add(name);
                ++n2;
            }
        }
    }
}

