/*
 * Decompiled with CFR 0.152.
 */
package net.spy.memcached.protocol;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.compat.SpyObject;
import net.spy.memcached.ops.CancelledOperationStatus;
import net.spy.memcached.ops.OperationCallback;
import net.spy.memcached.ops.OperationErrorType;
import net.spy.memcached.ops.OperationException;
import net.spy.memcached.ops.OperationState;
import net.spy.memcached.ops.OperationStatus;

public abstract class BaseOperationImpl
extends SpyObject {
    public static final OperationStatus CANCELLED = new CancelledOperationStatus();
    private OperationState state = OperationState.WRITING;
    private ByteBuffer cmd = null;
    private boolean cancelled = false;
    private OperationException exception = null;
    protected OperationCallback callback = null;
    private volatile MemcachedNode handlingNode = null;

    public final OperationCallback getCallback() {
        return this.callback;
    }

    protected void setCallback(OperationCallback to) {
        this.callback = to;
    }

    public final boolean isCancelled() {
        return this.cancelled;
    }

    public final boolean hasErrored() {
        return this.exception != null;
    }

    public final OperationException getException() {
        return this.exception;
    }

    public final void cancel() {
        this.cancelled = true;
        this.wasCancelled();
        this.callback.complete();
    }

    protected void wasCancelled() {
        this.getLogger().debug("was cancelled.");
    }

    public final OperationState getState() {
        return this.state;
    }

    public final ByteBuffer getBuffer() {
        return this.cmd;
    }

    protected final void setBuffer(ByteBuffer to) {
        assert (to != null) : "Trying to set buffer to null";
        this.cmd = to;
        this.cmd.mark();
    }

    protected final void transitionState(OperationState newState) {
        this.getLogger().debug("Transitioned state from %s to %s", new Object[]{this.state, newState});
        this.state = newState;
        if (this.state != OperationState.WRITING) {
            this.cmd = null;
        }
        if (this.state == OperationState.COMPLETE) {
            this.callback.complete();
        }
    }

    public final void writeComplete() {
        this.transitionState(OperationState.READING);
    }

    public abstract void initialize();

    public abstract void readFromBuffer(ByteBuffer var1) throws IOException;

    protected void handleError(OperationErrorType eType, String line) throws IOException {
        this.getLogger().error("Error:  %s", line);
        switch (eType) {
            case GENERAL: {
                this.exception = new OperationException();
                break;
            }
            case SERVER: {
                this.exception = new OperationException(eType, line);
                break;
            }
            case CLIENT: {
                this.exception = new OperationException(eType, line);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.transitionState(OperationState.COMPLETE);
        throw this.exception;
    }

    public void handleRead(ByteBuffer data) {
        assert (false);
    }

    public MemcachedNode getHandlingNode() {
        return this.handlingNode;
    }

    public void setHandlingNode(MemcachedNode to) {
        this.handlingNode = to;
    }
}

