/*
 * Decompiled with CFR 0.152.
 */
package flexjson.factories;

import flexjson.JSONException;
import flexjson.ObjectBinder;
import flexjson.ObjectFactory;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateObjectFactory
implements ObjectFactory {
    private static List<String> defaultFormats = new ArrayList<String>();
    protected List<String> dateFormats;
    protected boolean fromDefaults = false;
    protected ThreadLocal<List<DateFormat>> dateFormatters = new ThreadLocal();

    public static void addDefaultFormat(String ... formats) {
        defaultFormats.addAll(Arrays.asList(formats));
    }

    public DateObjectFactory() {
        this.fromDefaults = true;
        this.dateFormats = new ArrayList<String>(defaultFormats);
    }

    public DateObjectFactory(List<String> dateFormats) {
        this.dateFormats = dateFormats;
    }

    public DateObjectFactory add(String ... formats) {
        this.dateFormats.addAll(Arrays.asList(formats));
        return this;
    }

    @Override
    public Object instantiate(ObjectBinder context, Object value, Type targetType, Class targetClass) {
        try {
            if (value instanceof Number) {
                return this.instantiateDate((Class)targetType, ((Number)value).longValue(), context);
            }
            for (DateFormat format : this.getDateFormats()) {
                try {
                    return format.parse(value.toString());
                }
                catch (ParseException e) {
                }
            }
            throw new JSONException(String.format("%s:  Parsing date %s was not recognized as a date format", context.getCurrentPath(), value));
        }
        catch (IllegalAccessException e) {
            throw new JSONException(String.format("%s:  Error encountered trying to instantiate %s", context.getCurrentPath(), ((Class)targetType).getName()), e);
        }
        catch (InstantiationException e) {
            throw new JSONException(String.format("%s:  Error encountered trying to instantiate %s.  Make sure there is a public constructor that accepts a single Long.", context.getCurrentPath(), ((Class)targetType).getName()), e);
        }
        catch (InvocationTargetException e) {
            throw new JSONException(String.format("%s:  Error encountered trying to instantiate %s.  Make sure there is a public constructor that accepts a single Long.", context.getCurrentPath(), ((Class)targetType).getName()), e);
        }
    }

    private Date instantiateDate(Class targetType, Long value, ObjectBinder context) throws IllegalAccessException, InstantiationException, InvocationTargetException {
        try {
            Constructor constructor = targetType.getConstructor(Long.TYPE);
            return (Date)constructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            Date d = (Date)targetType.newInstance();
            d.setTime(value);
            return d;
        }
    }

    protected List<DateFormat> getDateFormats() {
        if (this.dateFormatters.get() == null) {
            ArrayList<DateFormat> dateFormatList = new ArrayList<DateFormat>();
            if (this.fromDefaults) {
                dateFormatList.add(DateFormat.getDateTimeInstance());
                dateFormatList.add(DateFormat.getDateTimeInstance(1, 1));
                dateFormatList.add(DateFormat.getDateTimeInstance(2, 2));
                dateFormatList.add(DateFormat.getDateTimeInstance(3, 3));
            }
            for (String format : this.dateFormats) {
                dateFormatList.add(new SimpleDateFormat(format));
            }
            this.dateFormatters.set(dateFormatList);
        }
        return this.dateFormatters.get();
    }

    static {
        defaultFormats.add("EEE MMM d hh:mm:ss a z yyyy");
        defaultFormats.add("EEE MMM d HH:mm:ss z yyyy");
        defaultFormats.add("MM/dd/yy hh:mm:ss a");
        defaultFormats.add("MM/dd/yy");
    }
}

