/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io.unsync;

import com.liferay.portal.kernel.io.unsync.UnsyncFilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class UnsyncBufferedOutputStream
extends UnsyncFilterOutputStream {
    protected byte[] buffer;
    protected int count;
    private static final int _DEFAULT_BUFFER_SIZE = 8192;

    public UnsyncBufferedOutputStream(OutputStream outputStream) {
        this(outputStream, 8192);
    }

    public UnsyncBufferedOutputStream(OutputStream outputStream, int size) {
        super(outputStream);
        if (size <= 0) {
            throw new IllegalArgumentException("Size is less than 0");
        }
        this.buffer = new byte[size];
    }

    @Override
    public void flush() throws IOException {
        if (this.count > 0) {
            this.outputStream.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        this.outputStream.flush();
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        if (length >= this.buffer.length) {
            if (this.count > 0) {
                this.outputStream.write(this.buffer, 0, this.count);
                this.count = 0;
            }
            this.outputStream.write(bytes, offset, length);
            return;
        }
        if (this.count > 0 && length > this.buffer.length - this.count) {
            this.outputStream.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        System.arraycopy(bytes, offset, this.buffer, this.count, length);
        this.count += length;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.count >= this.buffer.length) {
            this.outputStream.write(this.buffer, 0, this.count);
            this.count = 0;
        }
        this.buffer[this.count++] = (byte)b;
    }
}

