/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.FileWriter;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.transform.AbstractCoordTransBuilder;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LatLonProjection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetcdfCFWriter {
    private static long maxSize = 2000000000L;
    private static Logger log = LoggerFactory.getLogger(NetcdfCFWriter.class);

    public void makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, DateRange range, boolean addLatLon, int horizStride, int stride_z, int stride_time) throws IOException, InvalidRangeException {
        this.makeFile(location, gds, gridList, llbb, horizStride, null, range, stride_time, addLatLon);
    }

    public void makeFile(String location, ucar.nc2.dt.GridDataset gds, List<String> gridList, LatLonRect llbb, int horizStride, Range zRange, DateRange dateRange, int stride_time, boolean addLatLon) throws IOException, InvalidRangeException {
        Variable v;
        GridCoordSystem gcs;
        FileWriter writer = new FileWriter(location, false);
        NetcdfDataset ncd = (NetcdfDataset)gds.getNetcdfFile();
        for (Attribute att : gds.getGlobalAttributes()) {
            writer.writeGlobalAttribute(att);
        }
        writer.writeGlobalAttribute(new Attribute("Conventions", "CF-1.0"));
        writer.writeGlobalAttribute(new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (NetcdfCFWriter)\nOriginal Dataset = " + gds.getLocationURI() + "; Translation Date = " + new Date()));
        ArrayList<Variable> varList = new ArrayList<Variable>();
        ArrayList<String> varNameList = new ArrayList<String>();
        ArrayList<CoordinateAxis> axisList = new ArrayList<CoordinateAxis>();
        long total_size = 0L;
        for (String gridName : gridList) {
            ProjectionImpl proj;
            if (varNameList.contains(gridName)) continue;
            varNameList.add(gridName);
            GridDatatype grid = gds.findGridDatatype(gridName);
            GridCoordSystem gcsOrg = grid.getCoordinateSystem();
            CoordinateAxis1DTime timeAxis = gcsOrg.getTimeAxis1D();
            Range timeRange = null;
            if (dateRange != null && timeAxis != null) {
                int startIndex = timeAxis.findTimeIndexFromDate(dateRange.getStart().getDate());
                int endIndex = timeAxis.findTimeIndexFromDate(dateRange.getEnd().getDate());
                if (startIndex < 0) {
                    throw new InvalidRangeException("start time=" + dateRange.getStart().getDate() + " must be >= " + timeAxis.getTimeDate(0));
                }
                if (endIndex < 0) {
                    throw new InvalidRangeException("end time=" + dateRange.getEnd().getDate() + " must be >= " + timeAxis.getTimeDate(0));
                }
                timeRange = new Range(startIndex, endIndex);
            }
            if (null != timeRange || zRange != null || llbb != null || horizStride > 1) {
                grid = grid.makeSubset(timeRange, zRange, llbb, 1, horizStride, horizStride);
            }
            VariableDS gridV = grid.getVariable();
            varList.add(gridV);
            total_size += gridV.getSize() * (long)gridV.getElementSize();
            gcs = grid.getCoordinateSystem();
            for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                if (varNameList.contains(axis.getName())) continue;
                varNameList.add(axis.getName());
                varList.add(axis);
                axisList.add(axis);
            }
            for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
                v = ncd.findVariable(ct.getName());
                if (varNameList.contains(ct.getName()) || null == v) continue;
                varNameList.add(ct.getName());
                varList.add(v);
            }
            if (!addLatLon || null == (proj = gcs.getProjection()) || proj instanceof LatLonProjection) continue;
            this.addLatLon2D(ncd, varList, proj, gcs.getXHorizAxis(), gcs.getYHorizAxis());
            addLatLon = false;
        }
        if (total_size > maxSize) {
            log.info("Reject request size = {} Mbytes", (Object)total_size);
            throw new IllegalArgumentException("Request too big=" + total_size + " Mbytes, max=" + maxSize);
        }
        writer.writeVariables(varList);
        NetcdfFileWriteable ncfile = writer.getNetcdf();
        Group root = ncfile.getRootGroup();
        for (String gridName : gridList) {
            GridDatatype grid = gds.findGridDatatype(gridName);
            Variable newV = root.findVariable(gridName);
            if (newV == null) {
                log.warn("NetcdfCFWriter cant find " + gridName + " in gds " + gds.getLocationURI());
                continue;
            }
            StringBuilder sbuff = new StringBuilder();
            gcs = grid.getCoordinateSystem();
            for (CoordinateAxis axis : gcs.getCoordinateAxes()) {
                sbuff.append(axis.getName()).append(" ");
            }
            if (addLatLon) {
                sbuff.append("lat lon");
            }
            newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
            for (CoordinateTransform ct : gcs.getCoordinateTransforms()) {
                v = ncd.findVariable(ct.getName());
                if (ct.getTransformType() != TransformType.Projection) continue;
                newV.addAttribute(new Attribute("grid_mapping", v.getName()));
            }
        }
        for (CoordinateAxis axis : axisList) {
            Variable newV = root.findVariable(axis.getShortName());
            if ((axis.getAxisType() == AxisType.Height || axis.getAxisType() == AxisType.Pressure || axis.getAxisType() == AxisType.GeoZ) && null != axis.getPositive()) {
                newV.addAttribute(new Attribute("positive", axis.getPositive()));
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() != AxisType.GeoY) continue;
            newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
        }
        ArrayList<Variable> ctvList = new ArrayList<Variable>();
        for (GridDataset.Gridset gridSet : gds.getGridsets()) {
            Variable v2;
            GridCoordSystem gcs2 = gridSet.getGeoCoordSystem();
            ProjectionCT pct = gcs2.getProjectionCT();
            if (pct == null || (v2 = root.findVariable(pct.getName())) == null || ctvList.contains(v2)) continue;
            this.convertProjectionCTV((NetcdfDataset)gds.getNetcdfFile(), v2);
            ctvList.add(v2);
        }
        writer.finish();
    }

    private void convertProjectionCTV(NetcdfDataset ds, Variable ctv) {
        Attribute att = ctv.findAttribute("_CoordinateTransformType");
        if (null != att && att.getStringValue().equals("Projection")) {
            double scalef;
            Attribute east = ctv.findAttribute("false_easting");
            Attribute north = ctv.findAttribute("false_northing");
            if ((null != east || null != north) && (scalef = AbstractCoordTransBuilder.getFalseEastingScaleFactor(ds, ctv)) != 1.0) {
                this.convertAttribute(ctv, east, scalef);
                this.convertAttribute(ctv, north, scalef);
            }
        }
    }

    private void convertAttribute(Variable ctv, Attribute att, double scalef) {
        if (att == null) {
            return;
        }
        double val = scalef * att.getNumericValue().doubleValue();
        ctv.addAttribute(new Attribute(att.getName(), val));
    }

    private void addLatLon2D(NetcdfFile ncfile, List<Variable> varList, Projection proj, CoordinateAxis xaxis, CoordinateAxis yaxis) throws IOException {
        double[] xData = (double[])xaxis.read().get1DJavaArray(Double.TYPE);
        double[] yData = (double[])yaxis.read().get1DJavaArray(Double.TYPE);
        ArrayList<Dimension> dims = new ArrayList<Dimension>();
        dims.add(yaxis.getDimension(0));
        dims.add(xaxis.getDimension(0));
        Variable latVar = new Variable(ncfile, null, null, "lat");
        latVar.setDataType(DataType.DOUBLE);
        latVar.setDimensions(dims);
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        latVar.addAttribute(new Attribute("long_name", "latitude coordinate"));
        latVar.addAttribute(new Attribute("standard_name", "latitude"));
        latVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        Variable lonVar = new Variable(ncfile, null, null, "lon");
        lonVar.setDataType(DataType.DOUBLE);
        lonVar.setDimensions(dims);
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        lonVar.addAttribute(new Attribute("long_name", "longitude coordinate"));
        lonVar.addAttribute(new Attribute("standard_name", "longitude"));
        lonVar.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        int nx = xData.length;
        int ny = yData.length;
        ProjectionPointImpl projPoint = new ProjectionPointImpl();
        LatLonPointImpl latlonPoint = new LatLonPointImpl();
        double[] latData = new double[nx * ny];
        double[] lonData = new double[nx * ny];
        for (int i = 0; i < ny; ++i) {
            for (int j = 0; j < nx; ++j) {
                projPoint.setLocation(xData[j], yData[i]);
                proj.projToLatLon(projPoint, latlonPoint);
                latData[i * nx + j] = latlonPoint.getLatitude();
                lonData[i * nx + j] = latlonPoint.getLongitude();
            }
        }
        Array latDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)latData);
        latVar.setCachedData(latDataArray, false);
        Array lonDataArray = Array.factory(DataType.DOUBLE, new int[]{ny, nx}, (Object)lonData);
        lonVar.setCachedData(lonDataArray, false);
        varList.add(latVar);
        varList.add(lonVar);
    }

    public static void test1() throws IOException, InvalidRangeException, ParseException {
        String fileIn = "C:/data/ncmodels/NAM_CONUS_80km_20051206_0000.nc";
        String fileOut = "C:/temp/cf3.nc";
        GridDataset gds = GridDataset.open(fileIn);
        NetcdfCFWriter writer = new NetcdfCFWriter();
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add("RH");
        gridList.add("T");
        DateFormatter format = new DateFormatter();
        Date start = format.isoDateTimeFormat("2005-12-06T18:00:00Z");
        Date end = format.isoDateTimeFormat("2005-12-07T18:00:00Z");
        writer.makeFile(fileOut, (ucar.nc2.dt.GridDataset)gds, gridList, new LatLonRect(new LatLonPointImpl(37.0, -109.0), 400.0, 7.0), new DateRange(start, end), true, 1, 1, 1);
    }

    public static void main(String[] args) throws IOException, InvalidRangeException, ParseException {
        String fileIn = "dods://motherlode.ucar.edu/repository/entry/show/output:data.opendap/entryid:c41a3a26-57e5-4b15-b8b1-a8762b6f02c7/dodsC/entry";
        String fileOut = "C:/temp/testCF.nc";
        GridDataset gds = GridDataset.open(fileIn);
        NetcdfCFWriter writer = new NetcdfCFWriter();
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add("Z_sfc");
        DateFormatter format = new DateFormatter();
        Date start = format.isoDateTimeFormat("2003-06-01T03:00:00Z");
        Date end = format.isoDateTimeFormat("2004-01-01T00:00:00Z");
        writer.makeFile(fileOut, (ucar.nc2.dt.GridDataset)gds, gridList, null, new DateRange(start, end), true, 1, 1, 1);
    }
}

