/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.jmx.model;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HashCode;
import com.liferay.portal.kernel.util.HashCodeFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class MBean
implements Serializable {
    private static Log _log = LogFactoryUtil.getLog(MBean.class);
    private String _domainName;
    private boolean _loaded;
    private MBeanInfo _mBeanInfo;
    private String _mBeanName;
    private ObjectName _objectName;
    private List<String> _path;

    public MBean(ObjectName objectName) {
        this(objectName.getDomain(), objectName.getKeyPropertyListString());
        this._objectName = objectName;
    }

    public MBean(ObjectName objectName, MBeanInfo mBeanInfo) {
        this._domainName = objectName.getDomain();
        this._mBeanName = objectName.getKeyPropertyListString();
        this._mBeanInfo = mBeanInfo;
        this._loaded = true;
    }

    public MBean(String domainName, String mBeanName) {
        this._domainName = domainName;
        this._mBeanName = mBeanName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MBean)) {
            return false;
        }
        MBean mBean = (MBean)obj;
        return Validator.equals(this._domainName, mBean._domainName) && Validator.equals(this._mBeanName, mBean._mBeanName);
    }

    public String getDomainName() {
        return this._domainName;
    }

    public MBeanInfo getMBeanInfo() {
        return this._mBeanInfo;
    }

    public String getMBeanName() {
        return this._mBeanName;
    }

    public ObjectName getObjectName() throws MalformedObjectNameException {
        if (this._objectName == null) {
            this._objectName = new ObjectName(this._domainName.concat(":").concat(this._mBeanName));
        }
        return this._objectName;
    }

    public List<String> getPath() {
        if (this._path == null) {
            String[] parts = StringUtil.split(this._mBeanName);
            this._path = new ArrayList<String>(parts.length);
            String[] stringArray = parts;
            int n = parts.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                String[] kvp = StringUtil.split(part, '=');
                if (kvp.length != 2) {
                    _log.error("Invalid MBean name syntax " + this._mBeanName);
                } else {
                    this._path.add(kvp[1]);
                }
                ++n2;
            }
        }
        return this._path;
    }

    public int hashCode() {
        HashCode hashCode = HashCodeFactoryUtil.getHashCode();
        hashCode.append(this._domainName);
        hashCode.append(this._mBeanName);
        return hashCode.toHashCode();
    }

    public boolean isLoaded() {
        return this._loaded;
    }
}

