/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.fastutil.objects;

import it.unimi.dsi.fastutil.chars.AbstractCharCollection;
import it.unimi.dsi.fastutil.chars.AbstractCharIterator;
import it.unimi.dsi.fastutil.chars.CharCollection;
import it.unimi.dsi.fastutil.chars.CharIterator;
import it.unimi.dsi.fastutil.objects.AbstractObjectIterator;
import it.unimi.dsi.fastutil.objects.AbstractReferenceSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2CharMap;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReference2CharMap<K>
implements Reference2CharMap<K>,
Serializable {
    protected char defRetValue;

    protected AbstractReference2CharMap() {
    }

    @Override
    public void defaultReturnValue(char rv) {
        this.defRetValue = rv;
    }

    @Override
    public char defaultReturnValue() {
        return this.defRetValue;
    }

    @Override
    public char put(K key, char value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public char removeChar(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Character get(Object ok) {
        Object k = ok;
        return this.containsKey(k) ? Character.valueOf(this.getChar(k)) : null;
    }

    @Override
    public Character put(K ok, Character ov) {
        K k = ok;
        char v = this.put(k, ov.charValue());
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public Character remove(Object ok) {
        Object k = ok;
        char v = this.removeChar(k);
        return this.containsKey(k) ? Character.valueOf(v) : null;
    }

    @Override
    public boolean containsValue(Object ov) {
        return this.containsValue(((Character)ov).charValue());
    }

    @Override
    public boolean containsValue(char v) {
        return this.values().contains(v);
    }

    @Override
    public boolean containsKey(Object k) {
        return this.keySet().contains(k);
    }

    @Override
    public void putAll(Map<? extends K, ? extends Character> m) {
        int n = m.size();
        Iterator<Map.Entry<K, Character>> i = m.entrySet().iterator();
        if (m instanceof Reference2CharMap) {
            while (n-- != 0) {
                Reference2CharMap.Entry e = (Reference2CharMap.Entry)i.next();
                this.put((K)e.getKey(), e.getCharValue());
            }
        } else {
            while (n-- != 0) {
                Map.Entry<K, Character> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public ReferenceSet<K> keySet() {
        return new AbstractReferenceSet<K>(){

            @Override
            public boolean contains(Object k) {
                return AbstractReference2CharMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractReference2CharMap.this.size();
            }

            @Override
            public void clear() {
                AbstractReference2CharMap.this.clear();
            }

            @Override
            public ObjectIterator<K> iterator() {
                return new AbstractObjectIterator<K>(){
                    final ObjectIterator<Map.Entry<K, Character>> i;
                    {
                        this.i = AbstractReference2CharMap.this.entrySet().iterator();
                    }

                    @Override
                    public K next() {
                        return ((Reference2CharMap.Entry)this.i.next()).getKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public CharCollection values() {
        return new AbstractCharCollection(){

            public boolean contains(char k) {
                return AbstractReference2CharMap.this.containsValue(k);
            }

            public int size() {
                return AbstractReference2CharMap.this.size();
            }

            public void clear() {
                AbstractReference2CharMap.this.clear();
            }

            public CharIterator iterator() {
                return new AbstractCharIterator(){
                    final ObjectIterator<Map.Entry<K, Character>> i;
                    {
                        this.i = AbstractReference2CharMap.this.entrySet().iterator();
                    }

                    public char nextChar() {
                        return ((Reference2CharMap.Entry)this.i.next()).getCharValue();
                    }

                    public boolean hasNext() {
                        return this.i.hasNext();
                    }
                };
            }
        };
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator i = this.entrySet().iterator();
        while (n-- != 0) {
            h += ((Object)((Map.Entry)i.next())).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.entrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator i = this.entrySet().iterator();
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Reference2CharMap.Entry e = (Reference2CharMap.Entry)i.next();
            if (this == e.getKey()) {
                s.append("(this map)");
            } else {
                s.append(String.valueOf(e.getKey()));
            }
            s.append("=>");
            s.append(String.valueOf(e.getCharValue()));
        }
        s.append("}");
        return s.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicEntry<K>
    implements Reference2CharMap.Entry<K> {
        protected K key;
        protected char value;

        public BasicEntry(K key, Character value) {
            this.key = key;
            this.value = value.charValue();
        }

        public BasicEntry(K key, char value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public Character getValue() {
            return Character.valueOf(this.value);
        }

        @Override
        public char getCharValue() {
            return this.value;
        }

        @Override
        public char setValue(char value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Character setValue(Character value) {
            return Character.valueOf(this.setValue(value.charValue()));
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            return this.key == e.getKey() && this.value == ((Character)e.getValue()).charValue();
        }

        @Override
        public int hashCode() {
            return System.identityHashCode(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

