/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.polls.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.polls.QuestionChoiceException;
import com.liferay.portlet.polls.model.PollsChoice;
import com.liferay.portlet.polls.service.base.PollsChoiceLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;

public class PollsChoiceLocalServiceImpl
extends PollsChoiceLocalServiceBaseImpl {
    public PollsChoice addChoice(long userId, long questionId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(name, description);
        User user = this.userPersistence.findByPrimaryKey(userId);
        Date now = new Date();
        long choiceId = this.counterLocalService.increment();
        PollsChoice choice = this.pollsChoicePersistence.create(choiceId);
        choice.setUuid(serviceContext.getUuid());
        choice.setGroupId(serviceContext.getScopeGroupId());
        choice.setCompanyId(user.getCompanyId());
        choice.setUserId(user.getUserId());
        choice.setUserName(user.getFullName());
        choice.setCreateDate(serviceContext.getCreateDate(now));
        choice.setModifiedDate(serviceContext.getModifiedDate(now));
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        this.pollsChoicePersistence.update((BaseModel)choice);
        return choice;
    }

    public PollsChoice getChoice(long choiceId) throws PortalException, SystemException {
        return this.pollsChoicePersistence.findByPrimaryKey(choiceId);
    }

    public List<PollsChoice> getChoices(long questionId) throws SystemException {
        return this.pollsChoicePersistence.findByQuestionId(questionId);
    }

    public int getChoicesCount(long questionId) throws SystemException {
        return this.pollsChoicePersistence.countByQuestionId(questionId);
    }

    public PollsChoice updateChoice(long choiceId, long questionId, String name, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        this.validate(name, description);
        this.pollsQuestionPersistence.findByPrimaryKey(questionId);
        PollsChoice choice = this.pollsChoicePersistence.findByPrimaryKey(choiceId);
        choice.setModifiedDate(serviceContext.getModifiedDate(null));
        choice.setQuestionId(questionId);
        choice.setName(name);
        choice.setDescription(description);
        this.pollsChoicePersistence.update((BaseModel)choice);
        return choice;
    }

    protected void validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name) || Validator.isNull((String)description)) {
            throw new QuestionChoiceException();
        }
    }
}

