/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.ext.json;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.abdera.Abdera;
import org.apache.abdera.model.Document;
import org.apache.abdera.protocol.client.AbderaClient;
import org.apache.abdera.protocol.client.ClientResponse;
import org.apache.abdera.protocol.client.RequestOptions;

public class JSONServlet
extends HttpServlet {
    private static final long serialVersionUID = 1414392196430276024L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Abdera getAbdera() {
        ServletContext sc = this.getServletContext();
        Abdera abdera = null;
        ServletContext servletContext = sc;
        synchronized (servletContext) {
            abdera = (Abdera)sc.getAttribute(Abdera.class.getName());
            if (abdera == null) {
                abdera = new Abdera();
                sc.setAttribute(Abdera.class.getName(), (Object)abdera);
            }
        }
        return abdera;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String url = request.getPathInfo();
        if (url == null || url.length() <= 1) {
            response.sendError(400);
            return;
        }
        url = URLDecoder.decode(url, "UTF-8");
        url = url.substring(1);
        Abdera abdera = this.getAbdera();
        AbderaClient client = new AbderaClient(abdera);
        RequestOptions options = client.getDefaultRequestOptions();
        if (request.getHeader("If-Match") != null) {
            options.setIfMatch(request.getHeader("If-Match"));
        }
        if (request.getHeader("If-None-Match") != null) {
            options.setIfNoneMatch(request.getHeader("If-None-Match"));
        }
        if (request.getHeader("If-Modified-Since") != null) {
            options.setIfNoneMatch(request.getHeader("If-Modified-Since"));
        }
        if (request.getHeader("If-Unmodified-Since") != null) {
            options.setIfNoneMatch(request.getHeader("If-Unmodified-Since"));
        }
        ClientResponse resp = client.get(url);
        switch (resp.getType()) {
            case SUCCESS: {
                try {
                    Document doc = resp.getDocument();
                    response.setContentType("application/json");
                    response.setCharacterEncoding("UTF-8");
                    if (doc.getEntityTag() != null) {
                        response.setHeader("ETag", doc.getEntityTag().toString());
                    }
                    if (doc.getLanguage() != null) {
                        response.setHeader("Content-Language", doc.getLanguage());
                    }
                    if (doc.getLastModified() != null) {
                        response.setDateHeader("Last-Modified", doc.getLastModified().getTime());
                    }
                    ServletOutputStream out = response.getOutputStream();
                    doc.writeTo("json", (OutputStream)out);
                }
                catch (Exception e) {
                    response.sendError(500);
                    return;
                }
            }
            case CLIENT_ERROR: 
            case SERVER_ERROR: {
                response.sendError(resp.getStatus(), resp.getStatusText());
                return;
            }
        }
    }
}

