/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ccpp;

import com.sun.ccpp.AttributeDescriptionImpl;
import com.sun.ccpp.ComponentDescriptionImpl;
import com.sun.ccpp.Log;
import com.sun.ccpp.ProfileDescriptionImpl;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DescriptionManager {
    private static DescriptionManager _instance = null;
    private static Object schema = null;
    private static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private Logger logger = Log.getLogger();
    private Hashtable profDescs = new Hashtable();
    private Hashtable compDescs = new Hashtable();
    private Hashtable attrDescs = new Hashtable();
    private Hashtable baseClasses = null;
    private Hashtable compositions = null;
    private Hashtable resPolicies = null;
    private DocumentBuilder docBuilder = null;
    static /* synthetic */ Class class$com$sun$ccpp$DescriptionManager;

    private DescriptionManager() {
        this.loadBaseClasses();
        this.loadCompositions();
        this.loadResPolicies();
        this.loadDocBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DescriptionManager getInstance() {
        if (_instance == null) {
            Class clazz = class$com$sun$ccpp$DescriptionManager == null ? (class$com$sun$ccpp$DescriptionManager = DescriptionManager.class$("com.sun.ccpp.DescriptionManager")) : class$com$sun$ccpp$DescriptionManager;
            synchronized (clazz) {
                if (_instance == null) {
                    _instance = new DescriptionManager();
                }
            }
        }
        return _instance;
    }

    public static void setSchema(File schema) {
        DescriptionManager.schema = schema;
    }

    public static void setSchema(InputStream schema) {
        DescriptionManager.schema = schema;
    }

    public void addVocabulary(File vocab) {
        Document doc = null;
        try {
            doc = this.docBuilder.parse(vocab);
        }
        catch (SAXException e) {
            this.logger.warning("SAX exception parsing vocabulary file. " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.warning("IO exception parsing vocabulary file. " + e.getMessage());
        }
        if (doc != null) {
            this.loadVocabulary(doc);
        }
    }

    public void addVocabulary(InputStream vocab) {
        Document doc = null;
        try {
            doc = this.docBuilder.parse(vocab);
        }
        catch (SAXException e) {
            this.logger.warning("SAX exception parsing vocabulary input stream. " + e.getMessage());
        }
        catch (IOException e) {
            this.logger.warning("IO exception parsing vocabulary input stream. " + e.getMessage());
        }
        if (doc != null) {
            this.loadVocabulary(doc);
        }
    }

    public Set getVocabularies() {
        return new HashSet(this.profDescs.values());
    }

    public void removeVocabulary(URI uri) {
        ProfileDescriptionImpl pd = (ProfileDescriptionImpl)this.profDescs.get(uri);
        if (pd != null) {
            Iterator comps = pd.getComponentDescriptions().iterator();
            while (comps.hasNext()) {
                ComponentDescriptionImpl cd = (ComponentDescriptionImpl)comps.next();
                Iterator attrs = cd.getAttributeDescriptions().iterator();
                while (attrs.hasNext()) {
                    AttributeDescriptionImpl ad = (AttributeDescriptionImpl)attrs.next();
                    this.attrDescs.remove(ad.getURIObject());
                }
                this.compDescs.remove(cd.getURIObject());
            }
            this.profDescs.remove(uri);
        }
    }

    void addProfileDescription(ProfileDescriptionImpl profDesc) {
        this.profDescs.put(profDesc.getURIObject(), profDesc);
    }

    void addComponentDescription(ComponentDescriptionImpl compDesc) {
        this.compDescs.put(compDesc.getURIObject(), compDesc);
    }

    void addAttributeDescription(AttributeDescriptionImpl attrDesc) {
        this.attrDescs.put(attrDesc.getURIObject(), attrDesc);
    }

    ProfileDescriptionImpl getProfileDescription(URI uri) {
        return (ProfileDescriptionImpl)this.profDescs.get(uri);
    }

    ComponentDescriptionImpl getComponentDescription(URI uri) {
        return (ComponentDescriptionImpl)this.compDescs.get(uri);
    }

    AttributeDescriptionImpl getAttributeDescription(URI uri) {
        return (AttributeDescriptionImpl)this.attrDescs.get(uri);
    }

    Hashtable getBaseClasses() {
        return this.baseClasses;
    }

    Hashtable getCompositions() {
        return this.compositions;
    }

    Hashtable getResPolicies() {
        return this.resPolicies;
    }

    Set getVocabularyURIs() {
        return this.profDescs.keySet();
    }

    private void loadBaseClasses() {
        this.baseClasses = new Hashtable();
        try {
            this.baseClasses.put("integer", Class.forName("com.sun.ccpp.IntegerAttributeImpl"));
            this.baseClasses.put("literal", Class.forName("com.sun.ccpp.LiteralAttributeImpl"));
            this.baseClasses.put("rational", Class.forName("com.sun.ccpp.RationalAttributeImpl"));
            this.baseClasses.put("boolean", Class.forName("com.sun.ccpp.uaprof.BooleanAttributeImpl"));
            this.baseClasses.put("dimension", Class.forName("com.sun.ccpp.uaprof.DimensionAttributeImpl"));
        }
        catch (ClassNotFoundException e) {
            this.logger.info("Can't find base class. " + e.getMessage());
        }
    }

    private void loadCompositions() {
        this.compositions = new Hashtable();
        try {
            this.compositions.put("set", Class.forName("com.sun.ccpp.SetAttributeImpl"));
            this.compositions.put("sequence", Class.forName("com.sun.ccpp.SequenceAttributeImpl"));
        }
        catch (ClassNotFoundException e) {
            this.logger.info("Can't find composition class. " + e.getMessage());
        }
    }

    private void loadResPolicies() {
        this.resPolicies = new Hashtable();
        this.resPolicies.put("locked", new Integer(1));
        this.resPolicies.put("override", new Integer(2));
        this.resPolicies.put("append", new Integer(3));
    }

    private void loadDocBuilder() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        if (schema != null) {
            dbf.setValidating(true);
            dbf.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
            dbf.setAttribute(JAXP_SCHEMA_SOURCE, schema);
        }
        dbf.setIgnoringComments(true);
        dbf.setIgnoringElementContentWhitespace(true);
        dbf.setCoalescing(true);
        try {
            this.docBuilder = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            this.logger.info("ParserConfigurationException loading document builder. " + e.getMessage());
            return;
        }
    }

    private void loadVocabulary(Document doc) {
        ProfileDescriptionImpl profDesc = new ProfileDescriptionImpl();
        Element profElement = doc.getDocumentElement();
        String uri = profElement.getAttribute("id");
        try {
            profDesc.setURI(new URI(uri));
        }
        catch (URISyntaxException e) {
            this.logger.info("Invalid URI for profile description id. " + e.getMessage());
            return;
        }
        NodeList compNodes = profElement.getElementsByTagName("component-desc");
        int j = 0;
        while (j < compNodes.getLength()) {
            Element compElement = (Element)compNodes.item(j);
            ComponentDescriptionImpl compDesc = this.loadComponent(compElement, uri);
            if (compDesc == null) {
                return;
            }
            profDesc.addComponentDescription(compDesc);
            ++j;
        }
        ProfileDescriptionImpl parent = null;
        NodeList extNodes = profElement.getElementsByTagName("extends");
        int i = 0;
        while (i < extNodes.getLength()) {
            block10: {
                Element extElement = (Element)extNodes.item(i);
                try {
                    String extRef = extElement.getAttribute("ref");
                    URI extURI = new URI(extRef);
                    parent = this.getProfileDescription(extURI);
                    if (parent != null) {
                        profDesc.mergeProfileDescription(parent);
                        break block10;
                    }
                    this.logger.info("Parent vocabulary not defined.");
                    return;
                }
                catch (URISyntaxException e) {
                    this.logger.info("Invalid URI for parent vocabulary. " + e.getMessage());
                    return;
                }
            }
            ++i;
        }
        this.profDescs.put(profDesc.getURIObject(), profDesc);
        Iterator i2 = profDesc.getComponentDescriptions().iterator();
        while (i2.hasNext()) {
            ComponentDescriptionImpl compDesc = (ComponentDescriptionImpl)i2.next();
            this.compDescs.put(compDesc.getURIObject(), compDesc);
            Iterator j2 = compDesc.getAttributeDescriptions().iterator();
            while (j2.hasNext()) {
                AttributeDescriptionImpl attrDesc = (AttributeDescriptionImpl)j2.next();
                this.attrDescs.put(attrDesc.getURIObject(), attrDesc);
            }
        }
    }

    private ComponentDescriptionImpl loadComponent(Element compElement, String uri) {
        ComponentDescriptionImpl compDesc = new ComponentDescriptionImpl();
        String localType = compElement.getAttribute("id");
        compDesc.setLocalType(localType);
        try {
            compDesc.setURI(new URI(uri + localType));
        }
        catch (URISyntaxException e) {
            this.logger.info("Invalid URI for component description. " + e.getMessage());
            return null;
        }
        NodeList attrNodes = compElement.getElementsByTagName("attribute-desc");
        int k = 0;
        while (k < attrNodes.getLength()) {
            Element attrElement = (Element)attrNodes.item(k);
            AttributeDescriptionImpl attrDesc = this.loadAttribute(attrElement, uri);
            if (attrDesc == null) {
                return null;
            }
            attrDesc.setComponentDescription(compDesc);
            compDesc.addAttributeDescription(attrDesc);
            ++k;
        }
        compDesc.setDefined(true);
        return compDesc;
    }

    private AttributeDescriptionImpl loadAttribute(Element attrElement, String uri) {
        AttributeDescriptionImpl attrDesc = new AttributeDescriptionImpl();
        String name = attrElement.getAttribute("name");
        if (name == null || name.trim().equals("")) {
            this.logger.info("Invalid name for attribute description. Attribute URI: " + uri);
            return null;
        }
        attrDesc.setName(name);
        String baseType = attrElement.getAttribute("base-type");
        Class baseTypeClass = (Class)this.baseClasses.get(baseType);
        if (baseTypeClass == null) {
            this.logger.info("Invalid base-type for attribute description. Attribute name: " + name);
            return null;
        }
        attrDesc.setBaseType(baseTypeClass);
        String composition = attrElement.getAttribute("composition");
        Class compositionClass = (Class)this.compositions.get(composition);
        if (compositionClass == null && !"simple".equals(composition)) {
            this.logger.info("Invalid composition for attribute description. Attribute name: " + name);
            return null;
        }
        attrDesc.setComposition(compositionClass);
        String resolution = attrElement.getAttribute("resolution-policy");
        Integer resolutionInt = (Integer)this.resPolicies.get(resolution);
        if (resolutionInt == null) {
            this.logger.info("Invalid resolution-policy for attribute description. Attribute name: " + name);
            return null;
        }
        attrDesc.setResolution(resolutionInt);
        try {
            attrDesc.setURI(new URI(uri + name));
        }
        catch (URISyntaxException e) {
            this.logger.info("Invalid URI for attribute description. " + e.getMessage() + "Attribute name: " + name);
            return null;
        }
        attrDesc.setDefined(true);
        return attrDesc;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

