/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.engine;

import com.swabunga.spell.engine.SpellDictionaryASpell;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class SpellDictionaryDisk
extends SpellDictionaryASpell {
    private static final String DIRECTORY_WORDS = "words";
    private static final String DIRECTORY_DB = "db";
    private static final String FILE_CONTENTS = "contents";
    private static final String FILE_DB = "words.db";
    private static final String FILE_INDEX = "words.idx";
    private static final int INDEX_SIZE_MAX = 200;
    private File base;
    private File words;
    private File db;
    private Map index;
    protected boolean ready = false;
    private List indexCodeCache = null;

    public SpellDictionaryDisk(File file, File file2, boolean bl) throws FileNotFoundException, IOException {
        super(file2);
        this.base = file;
        this.words = new File(file, DIRECTORY_WORDS);
        this.db = new File(file, DIRECTORY_DB);
        if (!this.base.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.base + "'");
        }
        if (!this.words.exists()) {
            throw new FileNotFoundException("Couldn't find required path '" + this.words + "'");
        }
        if (!this.db.exists()) {
            this.db.mkdirs();
        }
        if (this.newDictionaryFiles()) {
            if (bl) {
                this.buildNewDictionaryDatabase();
                this.loadIndex();
                this.ready = true;
            } else {
                Thread thread = new Thread(){

                    public void run() {
                        try {
                            SpellDictionaryDisk.this.buildNewDictionaryDatabase();
                            SpellDictionaryDisk.this.loadIndex();
                            SpellDictionaryDisk.this.ready = true;
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                };
                thread.start();
            }
        } else {
            this.loadIndex();
        }
    }

    protected void buildNewDictionaryDatabase() throws FileNotFoundException, IOException {
        File file = this.buildSortedFile();
        this.buildCodeDb(file);
        file.delete();
        this.buildContentsFile();
    }

    public void addWord(String string) {
        throw new UnsupportedOperationException("addWord not yet implemented (sorry)");
    }

    public List getWords(String string) {
        Vector<String> vector = new Vector<String>();
        int[] nArray = this.getStartPosAndLen(string);
        if (nArray != null) {
            try {
                FileInputStream fileInputStream = new FileInputStream(new File(this.db, FILE_DB));
                ((InputStream)fileInputStream).skip(nArray[0]);
                byte[] byArray = new byte[nArray[1]];
                ((InputStream)fileInputStream).read(byArray, 0, nArray[1]);
                ((InputStream)fileInputStream).close();
                String string2 = new String(byArray);
                String[] stringArray = SpellDictionaryDisk.split(string2, "\n");
                for (int i = 0; i < stringArray.length; ++i) {
                    String[] stringArray2 = SpellDictionaryDisk.split(stringArray[i], ",");
                    if (!stringArray2[0].equals(string)) continue;
                    vector.addElement(stringArray2[1]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return vector;
    }

    public boolean isReady() {
        return this.ready;
    }

    private boolean newDictionaryFiles() throws FileNotFoundException, IOException {
        Object object;
        ArrayList<FileSize> arrayList = new ArrayList<FileSize>();
        File file = new File(this.db, FILE_CONTENTS);
        if (file.exists()) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new FileReader(file));
                while ((object = bufferedReader.readLine()) != null) {
                    String[] stringArray = SpellDictionaryDisk.split((String)object, ",");
                    arrayList.add(new FileSize(stringArray[0], Integer.parseInt(stringArray[1])));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw fileNotFoundException;
            }
            catch (IOException iOException) {
                throw iOException;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        boolean bl = false;
        object = this.words.listFiles();
        if (arrayList.size() != ((File[])object).length) {
            bl = true;
        } else {
            for (int i = 0; i < ((File[])object).length; ++i) {
                FileSize fileSize = new FileSize(object[i].getName(), object[i].length());
                if (arrayList.contains(fileSize)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private File buildSortedFile() throws FileNotFoundException, IOException {
        String string;
        Closeable closeable;
        ArrayList<String> arrayList = new ArrayList<String>();
        File[] fileArray = this.words.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            closeable = new BufferedReader(new FileReader(fileArray[i]));
            while ((string = ((BufferedReader)closeable).readLine()) != null) {
                if (string.equals("")) continue;
                arrayList.add(string.trim());
            }
            ((BufferedReader)closeable).close();
        }
        Collections.sort(arrayList);
        File file = File.createTempFile("jazzy", "sorted");
        closeable = new BufferedWriter(new FileWriter(file));
        string = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            String string2 = (String)arrayList.get(i);
            if (string == null || !string.equals(string2)) {
                ((Writer)closeable).write(string2);
                ((BufferedWriter)closeable).newLine();
            }
            string = string2;
        }
        ((BufferedWriter)closeable).close();
        return file;
    }

    private void buildCodeDb(File file) throws FileNotFoundException, IOException {
        Object[] objectArray;
        String string;
        ArrayList<CodeWord> arrayList = new ArrayList<CodeWord>();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            arrayList.add(new CodeWord(this.getCode(string), string));
        }
        bufferedReader.close();
        Collections.sort(arrayList);
        ArrayList<Object[]> arrayList2 = new ArrayList<Object[]>();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(this.db, FILE_DB)));
        Object[] objectArray2 = null;
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            CodeWord codeWord = (CodeWord)arrayList.get(i);
            objectArray = codeWord.getCode();
            objectArray = this.getIndexCode((String)objectArray, arrayList);
            String string2 = codeWord.getCode() + "," + codeWord.getWord() + "\n";
            byte[] byArray = string2.getBytes();
            if (objectArray2 == null) {
                objectArray2 = objectArray;
            }
            if (!objectArray2.equals(objectArray)) {
                arrayList2.add(new Object[]{objectArray2, new int[]{n, n2}});
                n += n2;
                n2 = byArray.length;
                objectArray2 = objectArray;
            } else {
                n2 += byArray.length;
            }
            bufferedOutputStream.write(byArray);
        }
        bufferedOutputStream.close();
        if (objectArray2 != null && n != 0 && n2 != 0) {
            arrayList2.add(new Object[]{objectArray2, new int[]{n, n2}});
        }
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.db, FILE_INDEX)));
        for (int i = 0; i < arrayList2.size(); ++i) {
            objectArray = (Object[])arrayList2.get(i);
            bufferedWriter.write(objectArray[0].toString());
            bufferedWriter.write(",");
            bufferedWriter.write(String.valueOf(((int[])objectArray[1])[0]));
            bufferedWriter.write(",");
            bufferedWriter.write(String.valueOf(((int[])objectArray[1])[1]));
            bufferedWriter.newLine();
        }
        bufferedWriter.close();
    }

    private void buildContentsFile() throws IOException {
        File[] fileArray = this.words.listFiles();
        if (fileArray.length > 0) {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(new File(this.db, FILE_CONTENTS)));
            for (int i = 0; i < fileArray.length; ++i) {
                bufferedWriter.write(fileArray[i].getName());
                bufferedWriter.write(",");
                bufferedWriter.write(String.valueOf(fileArray[i].length()));
                bufferedWriter.newLine();
            }
            bufferedWriter.close();
        } else {
            new File(this.db, FILE_CONTENTS).delete();
        }
    }

    protected void loadIndex() throws IOException {
        String string;
        this.index = new HashMap();
        File file = new File(this.db, FILE_INDEX);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            String[] stringArray = SpellDictionaryDisk.split(string, ",");
            this.index.put(stringArray[0], new int[]{Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2])});
        }
        bufferedReader.close();
    }

    private int[] getStartPosAndLen(String string) {
        while (string.length() > 0) {
            int[] nArray = (int[])this.index.get(string);
            if (nArray == null) {
                string = string.substring(0, string.length() - 1);
                continue;
            }
            return nArray;
        }
        return null;
    }

    private String getIndexCode(String string, List list) {
        String string2;
        int n;
        if (this.indexCodeCache == null) {
            this.indexCodeCache = new ArrayList();
        }
        if (string.length() <= 1) {
            return string;
        }
        for (n = 0; n < this.indexCodeCache.size(); ++n) {
            String string3 = (String)this.indexCodeCache.get(n);
            if (!string.startsWith(string3)) continue;
            return string3;
        }
        n = -1;
        boolean bl = false;
        for (int i = 1; i < string.length(); ++i) {
            String string4 = string.substring(0, i);
            int n2 = 0;
            for (int j = 0; j < list.size(); ++j) {
                CodeWord codeWord;
                if (j == 0 && (j = Collections.binarySearch(list, new CodeWord(string4, ""))) < 0) {
                    j = 0;
                }
                if ((codeWord = (CodeWord)list.get(j)).getCode().startsWith(string4) ? ++n2 > 200 : codeWord.getCode().compareTo(string4) > 0) break;
            }
            if (n2 > 200) continue;
            bl = true;
            n = i;
            break;
        }
        String string5 = string2 = n == -1 ? string : string.substring(0, n);
        if (bl) {
            this.indexCodeCache.add(string2);
        }
        return string2;
    }

    private static String[] split(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        int n = stringTokenizer.countTokens();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        return stringArray;
    }

    private class FileSize {
        private String filename;
        private long size;

        public FileSize(String string, long l) {
            this.filename = string;
            this.size = l;
        }

        public String getFilename() {
            return this.filename;
        }

        public long getSize() {
            return this.size;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof FileSize)) {
                return false;
            }
            FileSize fileSize = (FileSize)object;
            if (this.size != fileSize.size) {
                return false;
            }
            return this.filename.equals(fileSize.filename);
        }

        public int hashCode() {
            int n = this.filename.hashCode();
            n = (int)((long)(29 * n) + this.size);
            return n;
        }
    }

    private class CodeWord
    implements Comparable {
        private String code;
        private String word;

        public CodeWord(String string, String string2) {
            this.code = string;
            this.word = string2;
        }

        public String getCode() {
            return this.code;
        }

        public String getWord() {
            return this.word;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CodeWord)) {
                return false;
            }
            CodeWord codeWord = (CodeWord)object;
            return this.word.equals(codeWord.word);
        }

        public int hashCode() {
            return this.word.hashCode();
        }

        public int compareTo(Object object) {
            return this.code.compareTo(((CodeWord)object).getCode());
        }
    }
}

