/*
 * Decompiled with CFR 0.152.
 */
package org.apache.portals.bridges.struts;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.portals.bridges.struts.PortletServletRequestDispatcher;

public class PortletServletRequestWrapper
extends HttpServletRequestWrapper {
    private static final Log log = LogFactory.getLog((Class)PortletServletRequestWrapper.class);
    private ServletContext context;

    public PortletServletRequestWrapper(ServletContext context, HttpServletRequest request) {
        super(request);
        this.context = context;
    }

    public String getPathInfo() {
        return (String)this.getAttribute("javax.servlet.include.path_info");
    }

    public String getContextPath() {
        return (String)this.getAttribute("javax.servlet.include.context_path");
    }

    public String getRequestURI() {
        return (String)this.getAttribute("javax.servlet.include.request_uri");
    }

    public String getServletPath() {
        return (String)this.getAttribute("javax.servlet.include.servlet_path");
    }

    public String getQueryString() {
        return (String)this.getAttribute("javax.servlet.include.query_string");
    }

    public RequestDispatcher getRequestDispatcher(String relativePath) {
        String path;
        if (!relativePath.startsWith("/")) {
            path = this.getServletPath();
            path = path.substring(0, path.lastIndexOf(47)) + '/' + relativePath;
        } else {
            path = relativePath;
        }
        RequestDispatcher dispatcher = this.context.getRequestDispatcher(path);
        if (dispatcher != null) {
            return new PortletServletRequestDispatcher(dispatcher, path, false);
        }
        return null;
    }
}

