/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.ColumnSchema;
import org.hsqldb.Expression;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.RangeVariable;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.OrderedHashSet;
import org.hsqldb.lib.Set;
import org.hsqldb.persist.PersistentStore;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class ExpressionColumn
extends Expression {
    public static final ExpressionColumn[] emptyArray = new ExpressionColumn[0];
    ColumnSchema column;
    String schema;
    String tableName;
    String columnName;
    RangeVariable rangeVariable;
    NumberSequence sequence;
    boolean isWritable;
    boolean isParam;

    ExpressionColumn(String schema, String table, String column) {
        super(2);
        this.schema = schema;
        this.tableName = table;
        this.columnName = column;
    }

    ExpressionColumn(ColumnSchema column) {
        super(2);
        this.column = column;
        this.dataType = column.getDataType();
        this.columnName = column.getName().name;
    }

    ExpressionColumn(RangeVariable rangeVar, int index) {
        super(2);
        this.columnIndex = index;
        this.setAutoAttributesAsColumn(rangeVar, this.columnIndex);
    }

    ExpressionColumn(Expression e, int colIndex, int rangePosition) {
        super(5);
        this.dataType = e.dataType;
        this.columnIndex = colIndex;
        this.alias = e.alias;
        this.rangePosition = rangePosition;
    }

    ExpressionColumn() {
        super(10);
    }

    ExpressionColumn(int type) {
        super(type);
        if (type == 8) {
            this.isParam = true;
        }
    }

    ExpressionColumn(Expression[] nodes, String name) {
        super(3);
        this.nodes = nodes;
        this.columnName = name;
    }

    ExpressionColumn(String schema, String table) {
        super(97);
        this.schema = schema;
        this.tableName = table;
    }

    ExpressionColumn(NumberSequence sequence, int opType) {
        super(opType);
        this.sequence = sequence;
        this.dataType = sequence.getDataType();
    }

    void setAutoAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.columnName = range.getColumnAlias(i);
        this.tableName = range.getTableAlias();
        this.rangeVariable = range;
        this.rangeVariable.addColumn(this.columnIndex);
    }

    void setAttributesAsColumn(RangeVariable range, int i) {
        this.columnIndex = i;
        this.column = range.getColumn(i);
        this.dataType = this.column.getDataType();
        this.rangeVariable = range;
        if (range.rangeType == 1) {
            this.rangeVariable.addColumn(this.columnIndex);
        }
    }

    void setAttributesAsColumn(ColumnSchema column, boolean isWritable) {
        this.column = column;
        this.dataType = column.getDataType();
        this.isWritable = isWritable;
    }

    HsqlNameManager.SimpleName getSimpleName() {
        if (this.alias != null) {
            return this.alias;
        }
        if (this.column != null) {
            return this.column.getName();
        }
        if (this.opType == 3) {
            return this.nodes[0].getSimpleName();
        }
        return null;
    }

    String getAlias() {
        if (this.alias != null) {
            return this.alias.name;
        }
        if (this.opType == 2) {
            return this.columnName;
        }
        if (this.opType == 3) {
            return this.columnName;
        }
        return "";
    }

    public String getBaseColumnName() {
        if (this.opType == 2 && this.rangeVariable != null) {
            return this.rangeVariable.getTable().getColumn((int)this.columnIndex).getName().name;
        }
        return null;
    }

    public HsqlNameManager.HsqlName getBaseColumnHsqlName() {
        return this.column.getName();
    }

    void collectObjectNames(Set set) {
        switch (this.opType) {
            case 11: {
                HsqlNameManager.HsqlName name = this.sequence.getName();
                set.add(name);
                return;
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 97: {
                break;
            }
            case 6: 
            case 7: {
                break;
            }
            case 2: {
                set.add(this.column.getName());
                if (this.column.getName().parent != null) {
                    set.add(this.column.getName().parent);
                }
                return;
            }
        }
    }

    String getColumnName() {
        if (this.opType == 2 && this.column != null) {
            return this.column.getName().name;
        }
        return this.getAlias();
    }

    ColumnSchema getColumn() {
        return this.column;
    }

    String getSchemaName() {
        return this.schema;
    }

    RangeVariable getRangeVariable() {
        return this.rangeVariable;
    }

    public HsqlList resolveColumnReferences(Session session, RangeVariable[] rangeVarArray, int rangeCount, HsqlList unresolvedSet, boolean acceptsSequences) {
        switch (this.opType) {
            case 11: {
                if (acceptsSequences) break;
                throw Error.error(5598);
            }
            case 3: 
            case 5: 
            case 8: 
            case 10: 
            case 97: {
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                boolean tableQualified;
                boolean resolved = false;
                boolean bl = tableQualified = this.tableName != null;
                if (this.rangeVariable != null) {
                    return unresolvedSet;
                }
                for (int i = 0; i < rangeCount; ++i) {
                    RangeVariable rangeVar = rangeVarArray[i];
                    if (rangeVar == null) continue;
                    if (resolved) {
                        if (!session.database.sqlEnforceRefs || !this.resolvesDuplicateColumnReference(rangeVar)) continue;
                        String message = this.getColumnName();
                        if (this.alias != null) {
                            StringBuffer sb = new StringBuffer(message);
                            sb.append(' ').append("AS").append(' ').append(this.alias.getStatementName());
                            message = sb.toString();
                        }
                        throw Error.error(5580, message);
                    }
                    if (!this.resolveColumnReference(rangeVar)) continue;
                    if (tableQualified) {
                        return unresolvedSet;
                    }
                    resolved = true;
                }
                if (resolved) {
                    return unresolvedSet;
                }
                if (session.database.sqlSyntaxOra) {
                    if (acceptsSequences && this.tableName != null) {
                        NumberSequence seq;
                        if ("CURRVAL".equals(this.columnName)) {
                            NumberSequence seq2 = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false);
                            if (seq2 != null) {
                                this.opType = 12;
                                this.dataType = seq2.getDataType();
                                this.sequence = seq2;
                                this.schema = null;
                                this.tableName = null;
                                this.columnName = null;
                                resolved = true;
                            }
                        } else if ("NEXTVAL".equals(this.columnName) && (seq = session.database.schemaManager.getSequence(this.tableName, session.getSchemaName(this.schema), false)) != null) {
                            this.opType = 11;
                            this.dataType = seq.getDataType();
                            this.sequence = seq;
                            this.schema = null;
                            this.tableName = null;
                            this.columnName = null;
                            resolved = true;
                        }
                    }
                    if (this.tableName == null && "ROWNUM".equals(this.columnName)) {
                        this.opType = 13;
                        this.dataType = Type.SQL_INTEGER;
                        this.columnName = null;
                        resolved = true;
                    }
                }
                if (resolved) {
                    return unresolvedSet;
                }
                if (unresolvedSet == null) {
                    unresolvedSet = new ArrayListIdentity();
                }
                unresolvedSet.add(this);
            }
        }
        return unresolvedSet;
    }

    private boolean resolveColumnReference(RangeVariable rangeVar) {
        ExpressionColumn e = rangeVar.getColumnExpression(this.columnName);
        if (e != null) {
            this.opType = e.opType;
            this.nodes = e.nodes;
            this.dataType = e.dataType;
            return true;
        }
        int colIndex = rangeVar.findColumn(this);
        if (colIndex == -1) {
            return false;
        }
        switch (rangeVar.rangeType) {
            case 3: 
            case 4: {
                if (this.tableName != null) {
                    return false;
                }
                ColumnSchema column = rangeVar.getColumn(colIndex);
                if (column.getParameterMode() == 4) {
                    return false;
                }
                this.opType = rangeVar.rangeType == 4 ? 6 : 7;
                break;
            }
            case 2: {
                if (this.tableName == null) {
                    return false;
                }
                if (this.schema != null) {
                    return false;
                }
                if (!rangeVar.resolvesTableName(this.tableName)) {
                    return false;
                }
                this.opType = 9;
                break;
            }
            default: {
                if (!rangeVar.resolvesSchemaName(this.schema)) {
                    return false;
                }
                if (rangeVar.resolvesTableName(this.tableName)) break;
                return false;
            }
        }
        this.setAttributesAsColumn(rangeVar, colIndex);
        return true;
    }

    boolean resolvesDuplicateColumnReference(RangeVariable rangeVar) {
        if (this.tableName == null) {
            ExpressionColumn e = rangeVar.getColumnExpression(this.columnName);
            if (e != null) {
                return false;
            }
            switch (rangeVar.rangeType) {
                case 2: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            int colIndex = rangeVar.findColumn(this);
            return colIndex != -1;
        }
        return false;
    }

    public void resolveTypes(Session session, Expression parent) {
        switch (this.opType) {
            case 4: {
                if (parent == null || parent.opType == 25) break;
                throw Error.error(5544);
            }
            case 3: {
                Type type = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    type = Type.getAggregateType(this.nodes[i].dataType, type);
                }
                this.dataType = type;
                break;
            }
        }
    }

    public Object getValue(Session session) {
        switch (this.opType) {
            case 4: {
                return null;
            }
            case 6: {
                return session.sessionContext.routineVariables[this.columnIndex];
            }
            case 7: {
                return session.sessionContext.routineArguments[this.columnIndex];
            }
            case 9: {
                return session.sessionContext.triggerArguments[this.rangeVariable.rangePosition][this.columnIndex];
            }
            case 2: {
                Object value = session.sessionContext.rangeIterators[this.rangeVariable.rangePosition].getCurrent(this.columnIndex);
                if (this.dataType != this.column.dataType) {
                    value = this.dataType.convertToType(session, value, this.column.dataType);
                }
                return value;
            }
            case 5: {
                Object value = session.sessionContext.rangeIterators[this.rangePosition].getCurrent(this.columnIndex);
                return value;
            }
            case 3: {
                Object value = null;
                for (int i = 0; i < this.nodes.length; ++i) {
                    value = this.nodes[i].getValue(session, this.dataType);
                    if (value == null) continue;
                    return value;
                }
                return value;
            }
            case 8: {
                return session.sessionContext.dynamicArguments[this.parameterIndex];
            }
            case 11: {
                return session.sessionData.getSequenceValue(this.sequence);
            }
            case 12: {
                return session.sessionData.getSequenceCurrent(this.sequence);
            }
            case 13: {
                return ValuePool.getInt(session.sessionContext.rownum);
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    public String getSQL() {
        switch (this.opType) {
            case 4: {
                return "DEFAULT";
            }
            case 8: {
                return "?";
            }
            case 10: {
                return "*";
            }
            case 3: {
                return this.alias.getStatementName();
            }
            case 2: 
            case 6: 
            case 7: {
                if (this.column == null) {
                    if (this.alias != null) {
                        return this.alias.getStatementName();
                    }
                    return this.columnName;
                }
                if (this.rangeVariable.tableAlias == null) {
                    return this.column.getName().getSchemaQualifiedStatementName();
                }
                StringBuffer sb = new StringBuffer();
                sb.append(this.rangeVariable.tableAlias.getStatementName());
                sb.append('.');
                sb.append(this.column.getName().statementName);
                return sb.toString();
            }
            case 97: {
                if (this.nodes.length == 0) {
                    return "*";
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < this.nodes.length; ++i) {
                    Expression e = this.nodes[i];
                    if (i > 0) {
                        sb.append(',');
                    }
                    String s = e.getSQL();
                    sb.append(s);
                }
                return sb.toString();
            }
        }
        throw Error.runtimeError(201, "ExpressionColumn");
    }

    protected String describe(Session session, int blanks) {
        StringBuffer sb = new StringBuffer(64);
        sb.append('\n');
        for (int i = 0; i < blanks; ++i) {
            sb.append(' ');
        }
        switch (this.opType) {
            case 4: {
                sb.append("DEFAULT");
                break;
            }
            case 10: {
                sb.append("OpTypes.ASTERISK ");
                break;
            }
            case 6: {
                sb.append("VARIABLE: ");
                sb.append(this.column.getName().name);
                break;
            }
            case 7: {
                sb.append("PARAMETER").append(": ");
                sb.append(this.column.getName().name);
                break;
            }
            case 3: {
                sb.append("COLUMN").append(": ");
                sb.append(this.columnName);
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 2: {
                sb.append("COLUMN").append(": ");
                sb.append(this.column.getName().getSchemaQualifiedStatementName());
                if (this.alias == null) break;
                sb.append(" AS ").append(this.alias.name);
                break;
            }
            case 8: {
                sb.append("DYNAMIC PARAM: ");
                sb.append(", TYPE = ").append(this.dataType.getNameString());
                break;
            }
            case 11: {
                sb.append("SEQUENCE").append(": ");
                sb.append(this.sequence.getName().name);
                break;
            }
        }
        return sb.toString();
    }

    String getTableName() {
        if (this.opType == 97) {
            return this.tableName;
        }
        if (this.opType == 2) {
            if (this.rangeVariable == null) {
                return this.tableName;
            }
            return this.rangeVariable.getTable().getName().name;
        }
        return "";
    }

    static void checkColumnsResolved(HsqlList set) {
        if (set != null && !set.isEmpty()) {
            StringBuffer sb = new StringBuffer();
            Expression e = (Expression)set.get(0);
            if (e instanceof ExpressionColumn) {
                ExpressionColumn c = (ExpressionColumn)e;
                if (c.schema != null) {
                    sb.append(c.schema + '.');
                }
                if (c.tableName != null) {
                    sb.append(c.tableName + '.');
                }
                throw Error.error(5501, sb.toString() + c.getColumnName());
            }
            OrderedHashSet newSet = new OrderedHashSet();
            e.collectAllExpressions(newSet, Expression.columnExpressionSet, Expression.emptyExpressionSet);
            ExpressionColumn.checkColumnsResolved(newSet);
            throw Error.error(5501);
        }
    }

    public OrderedHashSet getUnkeyedColumns(OrderedHashSet unresolvedSet) {
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            unresolvedSet = this.nodes[i].getUnkeyedColumns(unresolvedSet);
        }
        if (this.opType == 2 && !this.rangeVariable.hasKeyedColumnInGroupBy) {
            if (unresolvedSet == null) {
                unresolvedSet = new OrderedHashSet();
            }
            unresolvedSet.add(this);
        }
        return unresolvedSet;
    }

    void collectRangeVariables(RangeVariable[] rangeVariables, Set set) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i].collectRangeVariables(rangeVariables, set);
        }
        if (this.rangeVariable != null) {
            for (i = 0; i < rangeVariables.length; ++i) {
                if (rangeVariables[i] != this.rangeVariable) continue;
                set.add(this.rangeVariable);
                break;
            }
        }
    }

    Expression replaceAliasInOrderBy(Expression[] columns, int length) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceAliasInOrderBy(columns, length);
        }
        switch (this.opType) {
            case 2: 
            case 3: {
                for (i = 0; i < length; ++i) {
                    String alias;
                    HsqlNameManager.SimpleName aliasName = columns[i].alias;
                    String string = alias = aliasName == null ? null : aliasName.name;
                    if (this.schema != null || this.tableName != null || !this.columnName.equals(alias)) continue;
                    return columns[i];
                }
                for (i = 0; i < length; ++i) {
                    if (!(columns[i] instanceof ExpressionColumn)) continue;
                    if (this.equals(columns[i])) {
                        return columns[i];
                    }
                    if (this.tableName != null || this.schema != null || !this.columnName.equals(((ExpressionColumn)columns[i]).columnName)) continue;
                    return columns[i];
                }
                break;
            }
        }
        return this;
    }

    Expression replaceColumnReferences(RangeVariable range, Expression[] list) {
        if (this.opType == 2 && this.rangeVariable == range) {
            return list[this.columnIndex];
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null) continue;
            this.nodes[i] = this.nodes[i].replaceColumnReferences(range, list);
        }
        return this;
    }

    int findMatchingRangeVariableIndex(RangeVariable[] rangeVarArray) {
        for (int i = 0; i < rangeVarArray.length; ++i) {
            RangeVariable rangeVar = rangeVarArray[i];
            if (!rangeVar.resolvesTableName(this)) continue;
            return i;
        }
        return -1;
    }

    boolean hasReference(RangeVariable range) {
        if (range == this.rangeVariable) {
            return true;
        }
        for (int i = 0; i < this.nodes.length; ++i) {
            if (this.nodes[i] == null || !this.nodes[i].hasReference(range)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Expression other) {
        if (other == this) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.opType != other.opType) {
            return false;
        }
        switch (this.opType) {
            case 5: {
                return this.columnIndex == other.columnIndex;
            }
            case 3: {
                return this.nodes == other.nodes;
            }
            case 2: 
            case 6: 
            case 7: {
                return this.column == other.getColumn() && this.rangeVariable == other.getRangeVariable();
            }
        }
        return false;
    }

    void replaceRangeVariables(RangeVariable[] ranges, RangeVariable[] newRanges) {
        int i;
        for (i = 0; i < this.nodes.length; ++i) {
            this.nodes[i].replaceRangeVariables(ranges, newRanges);
        }
        for (i = 0; i < ranges.length; ++i) {
            if (this.rangeVariable != ranges[i]) continue;
            this.rangeVariable = newRanges[i];
            break;
        }
    }

    void resetColumnReferences() {
        this.rangeVariable = null;
        this.columnIndex = -1;
    }

    public boolean isIndexable(RangeVariable range) {
        if (this.opType == 2) {
            return this.rangeVariable == range;
        }
        return false;
    }

    public boolean isUnresolvedParam() {
        return this.isParam && this.dataType == null;
    }

    boolean isDynamicParam() {
        return this.isParam;
    }

    boolean isTargetRangeVariables(RangeVariable range) {
        return this.rangeVariable == range;
    }

    RangeVariable[] getJoinRangeVariables(RangeVariable[] ranges) {
        if (this.opType == 2) {
            return new RangeVariable[]{this.rangeVariable};
        }
        return RangeVariable.emptyArray;
    }

    double costFactor(Session session, RangeVariable range, int operation) {
        double factor;
        PersistentStore store = range.rangeTable.getRowStore(session);
        int indexType = range.rangeTable.indexTypeForColumn(session, this.columnIndex);
        switch (indexType) {
            case 2: {
                if (operation == 41) {
                    factor = 1.0;
                    break;
                }
                factor = store.elementCount() / 2;
                break;
            }
            case 1: {
                if (operation == 41) {
                    factor = store.elementCount() / 8;
                    if (!(factor > 1024.0)) break;
                    factor = 1024.0;
                    break;
                }
                factor = store.elementCount() / 2;
                break;
            }
            default: {
                factor = store.elementCount();
            }
        }
        return factor < 16.0 ? 16.0 : factor;
    }
}

