/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Database;
import org.hsqldb.Row;
import org.hsqldb.RowAction;
import org.hsqldb.Session;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManagerCommon;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.persist.CachedObject;
import org.hsqldb.persist.PersistentStore;

public class TransactionManager2PL
extends TransactionManagerCommon
implements TransactionManager {
    public TransactionManager2PL(Database db) {
        this.database = db;
        this.lobSession = this.database.sessionManager.getSysLobSession();
        this.txModel = 0;
    }

    public long getGlobalChangeTimestamp() {
        return this.globalChangeTimestamp.get();
    }

    public boolean isMVRows() {
        return false;
    }

    public boolean isMVCC() {
        return false;
    }

    public int getTransactionControl() {
        return 0;
    }

    public void setTransactionControl(Session session, int mode) {
        super.setTransactionControl(session, mode);
    }

    public void completeActions(Session session) {
        this.endActionTPL(session);
    }

    public boolean prepareCommitActions(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commitTransaction(Session session) {
        if (session.abortTransaction) {
            return false;
        }
        int limit = session.rowActionList.size();
        Object[] list = session.rowActionList.getArray();
        this.writeLock.lock();
        try {
            session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            this.endTransaction(session);
            for (int i = 0; i < limit; ++i) {
                RowAction action = (RowAction)list[i];
                action.commit(session);
            }
            this.persistCommit(session, list, limit);
            this.endTransactionTPL(session);
            Object var7_6 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        session.tempSet.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Session session) {
        session.abortTransaction = false;
        session.transactionEndTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
        this.rollbackPartial(session, 0, session.transactionTimestamp);
        this.endTransaction(session);
        this.writeLock.lock();
        try {
            this.endTransactionTPL(session);
            Object var3_2 = null;
            this.writeLock.unlock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.writeLock.unlock();
            throw throwable;
        }
    }

    public void rollbackSavepoint(Session session, int index) {
        long timestamp = session.sessionContext.savepointTimestamps.get(index);
        Integer oi = (Integer)session.sessionContext.savepoints.get(index);
        int start = oi;
        while (session.sessionContext.savepoints.size() > index + 1) {
            session.sessionContext.savepoints.remove(session.sessionContext.savepoints.size() - 1);
            session.sessionContext.savepointTimestamps.removeLast();
        }
        this.rollbackPartial(session, start, timestamp);
    }

    public void rollbackAction(Session session) {
        this.rollbackPartial(session, session.actionIndex, session.actionTimestamp);
        this.endActionTPL(session);
    }

    void rollbackPartial(Session session, int start, long timestamp) {
        Object[] list = session.rowActionList.getArray();
        int limit = session.rowActionList.size();
        if (start == limit) {
            return;
        }
        for (int i = limit - 1; i >= start; --i) {
            RowAction action = (RowAction)list[i];
            if (action == null || action.type == 0 || action.type == 3) continue;
            Row row = action.memoryRow;
            if (row == null) {
                row = (Row)action.store.get(action.getPos(), false);
            }
            if (row == null) continue;
            action.rollback(session, timestamp);
            int type = action.mergeRollback(session, timestamp, row);
            action.store.rollbackRow(session, row, type, this.txModel);
        }
        session.rowActionList.setSize(start);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowAction addDeleteAction(Session session, Table table, Row row, int[] colMap) {
        RowAction action;
        Row row2 = row;
        synchronized (row2) {
            action = RowAction.addDeleteAction(session, table, row, colMap);
        }
        session.rowActionList.add(action);
        PersistentStore store = table.getRowStore(session);
        store.delete(session, row);
        row.rowAction = null;
        return action;
    }

    public void addInsertAction(Session session, Table table, PersistentStore store, Row row, int[] changedColumns) {
        RowAction action = row.rowAction;
        if (action == null) {
            System.out.println("null insert action " + session + " " + session.actionTimestamp);
        }
        store.indexRow(session, row);
        session.rowActionList.add(action);
        row.rowAction = null;
    }

    public boolean canRead(Session session, Row row, int mode, int[] colMap) {
        return true;
    }

    public boolean canRead(Session session, int id, int mode) {
        return true;
    }

    public void setTransactionInfo(CachedObject object) {
    }

    public void removeTransactionInfo(CachedObject object) {
    }

    public void beginTransaction(Session session) {
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp = this.nextChangeTimestamp();
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beginAction(Session session, Statement cs) {
        if (session.hasLocks(cs)) {
            return;
        }
        this.writeLock.lock();
        try {
            boolean canProceed;
            if (cs.getCompileTimestamp() < this.database.schemaManager.getSchemaChangeTimestamp()) {
                session.sessionContext.currentStatement = cs = session.statementManager.getStatement(session, cs);
                if (cs == null) {
                    Object var5_3 = null;
                    this.writeLock.unlock();
                    return;
                }
            }
            if (canProceed = this.setWaitedSessionsTPL(session, cs)) {
                if (session.tempSet.isEmpty()) {
                    this.lockTablesTPL(session, cs);
                } else {
                    this.setWaitingSessionTPL(session);
                }
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.writeLock.unlock();
            throw throwable;
        }
        Object var5_4 = null;
        this.writeLock.unlock();
    }

    public void beginActionResume(Session session) {
        session.actionTimestamp = this.nextChangeTimestamp();
        if (!session.isTransaction) {
            session.transactionTimestamp = session.actionTimestamp;
            session.isTransaction = true;
            ++this.transactionCount;
        }
    }

    void endTransaction(Session session) {
        if (session.isTransaction) {
            session.isTransaction = false;
            --this.transactionCount;
        }
    }

    public DoubleIntIndex getTransactionIDList() {
        DoubleIntIndex lookup = new DoubleIntIndex(10, false);
        return lookup;
    }

    public void convertTransactionIDs(DoubleIntIndex lookup) {
    }
}

