/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hsqldb.Database;
import org.hsqldb.error.Error;
import org.hsqldb.persist.LobStore;

public class LobStoreInJar
implements LobStore {
    final int lobBlockSize;
    Database database;
    DataInputStream file;
    final String fileName;
    long realPosition;

    public LobStoreInJar(Database database, int lobBlockSize) {
        this.lobBlockSize = lobBlockSize;
        this.database = database;
        try {
            this.fileName = database.getPath() + ".lobs";
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public byte[] getBlockBytes(int blockAddress, int blockCount) {
        if (this.file == null) {
            throw Error.error(452);
        }
        try {
            long address = (long)blockAddress * (long)this.lobBlockSize;
            int count = blockCount * this.lobBlockSize;
            byte[] dataBytes = new byte[count];
            this.fileSeek(address);
            this.file.readFully(dataBytes, 0, count);
            this.realPosition = address + (long)count;
            return dataBytes;
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    public void setBlockBytes(byte[] dataBytes, int blockAddress, int blockCount) {
    }

    public int getBlockSize() {
        return this.lobBlockSize;
    }

    public void close() {
        try {
            if (this.file != null) {
                this.file.close();
            }
        }
        catch (Throwable t) {
            throw Error.error(466, t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetStream() throws IOException {
        InputStream fis;
        block8: {
            if (this.file != null) {
                this.file.close();
            }
            fis = null;
            try {
                block7: {
                    try {
                        ClassLoader cl;
                        fis = this.getClass().getResourceAsStream(this.fileName);
                        if (fis != null || (cl = Thread.currentThread().getContextClassLoader()) == null) break block7;
                        fis = cl.getResourceAsStream(this.fileName);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        if (fis == null) {
                            throw new FileNotFoundException(this.fileName);
                        }
                        break block8;
                    }
                }
                Object var4_4 = null;
                if (fis != null) break block8;
                throw new FileNotFoundException(this.fileName);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                if (fis != null) throw throwable;
                throw new FileNotFoundException(this.fileName);
            }
        }
        this.file = new DataInputStream(fis);
        this.realPosition = 0L;
    }

    private void fileSeek(long position) throws IOException {
        long skipPosition;
        if (this.file == null) {
            this.resetStream();
        }
        if (position < (skipPosition = this.realPosition)) {
            this.resetStream();
            skipPosition = 0L;
        }
        while (position > skipPosition) {
            skipPosition += this.file.skip(position - skipPosition);
        }
        this.realPosition = position;
    }

    public void synch() {
    }
}

