/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import org.apache.catalina.websocket.WsFrame;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.res.StringManager;

@Deprecated
public class WsInputStream
extends InputStream {
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.websocket");
    private final UpgradeProcessor<?> processor;
    private final WsOutbound outbound;
    private WsFrame frame;
    private long remaining;
    private long readThisFragment;
    private String error = null;

    public WsInputStream(UpgradeProcessor<?> processor, WsOutbound outbound) {
        this.processor = processor;
        this.outbound = outbound;
    }

    public WsFrame nextFrame(boolean block) throws IOException {
        this.frame = WsFrame.nextFrame(this.processor, block);
        if (this.frame != null) {
            this.readThisFragment = 0L;
            this.remaining = this.frame.getPayLoadLength();
        }
        return this.frame;
    }

    @Override
    public int read() throws IOException {
        this.makePayloadDataAvailable();
        if (this.remaining == 0L) {
            return -1;
        }
        --this.remaining;
        ++this.readThisFragment;
        int masked = this.processor.read();
        if (masked == -1) {
            return -1;
        }
        return masked ^ this.frame.getMask()[(int)((this.readThisFragment - 1L) % 4L)] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int result;
        this.makePayloadDataAvailable();
        if (this.remaining == 0L) {
            return -1;
        }
        if ((long)len > this.remaining) {
            len = (int)this.remaining;
        }
        if ((result = this.processor.read(true, b, off, len)) == -1) {
            return -1;
        }
        for (int i = off; i < off + result; ++i) {
            b[i] = (byte)(b[i] ^ this.frame.getMask()[(int)((this.readThisFragment + (long)i - (long)off) % 4L)]);
        }
        this.remaining -= (long)result;
        this.readThisFragment += (long)result;
        return result;
    }

    private void makePayloadDataAvailable() throws IOException {
        if (this.error != null) {
            throw new IOException(this.error);
        }
        while (this.remaining == 0L && !this.frame.getFin()) {
            this.nextFrame(true);
            while (this.frame.isControl()) {
                if (this.frame.getOpCode() == 9) {
                    this.outbound.pong(this.frame.getPayLoad());
                } else if (this.frame.getOpCode() != 10) {
                    if (this.frame.getOpCode() == 8) {
                        this.outbound.close(this.frame);
                    } else {
                        throw new IOException(sm.getString("is.unknownOpCode", new Object[]{this.frame.getOpCode()}));
                    }
                }
                this.nextFrame(true);
            }
            if (this.frame.getOpCode() == 0) continue;
            this.error = sm.getString("is.notContinuation", new Object[]{this.frame.getOpCode()});
            throw new IOException(this.error);
        }
    }
}

