/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.mediatool.demos;

import com.xuggle.mediatool.IMediaViewer;
import com.xuggle.mediatool.IMediaWriter;
import com.xuggle.mediatool.ToolFactory;
import com.xuggle.mediatool.demos.MovingBalls;
import com.xuggle.xuggler.Global;
import com.xuggle.xuggler.IAudioSamples;
import java.awt.image.BufferedImage;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenerateAudioAndVideo {
    private static final Logger log = LoggerFactory.getLogger(GenerateAudioAndVideo.class);

    public GenerateAudioAndVideo() {
        log.trace("<init>");
    }

    public static void main(String[] args) {
        int ballCount = 2;
        long duration = Global.DEFAULT_TIME_UNIT.convert(60L, TimeUnit.SECONDS);
        boolean videoStreamIndex = false;
        boolean videoStreamId = false;
        long frameRate = Global.DEFAULT_TIME_UNIT.convert(15L, TimeUnit.MILLISECONDS);
        int width = 320;
        int height = 200;
        boolean audioStreamIndex = true;
        boolean audioStreamId = false;
        boolean channelCount = true;
        int sampleRate = 44100;
        int sampleCount = 1000;
        long nextFrameTime = 0L;
        long totalSampleCount = 0L;
        IMediaWriter writer = ToolFactory.makeWriter("myballs.mov");
        writer.addListener(ToolFactory.makeViewer(IMediaViewer.Mode.AUDIO_VIDEO, true, 3));
        writer.addVideoStream(0, 0, 320, 200);
        writer.addAudioStream(1, 0, 1, 44100);
        MovingBalls balls = new MovingBalls(2, 320, 200, 1000);
        long clock = 0L;
        while (clock < duration) {
            while (clock >= nextFrameTime) {
                BufferedImage frame = balls.getVideoFrame(frameRate);
                writer.encodeVideo(0, frame, nextFrameTime, Global.DEFAULT_TIME_UNIT);
                nextFrameTime += frameRate;
            }
            short[] samples = balls.getAudioFrame(44100);
            writer.encodeAudio(1, samples, clock, Global.DEFAULT_TIME_UNIT);
            clock = IAudioSamples.samplesToDefaultPts(totalSampleCount += 1000L, 44100);
        }
        writer.close();
    }
}

