/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryParser.standard.builders;

import org.apache.lucene.document.NumericField;
import org.apache.lucene.messages.Message;
import org.apache.lucene.messages.MessageImpl;
import org.apache.lucene.queryParser.core.QueryNodeException;
import org.apache.lucene.queryParser.core.messages.QueryParserMessages;
import org.apache.lucene.queryParser.core.nodes.QueryNode;
import org.apache.lucene.queryParser.core.util.StringUtils;
import org.apache.lucene.queryParser.standard.builders.StandardQueryBuilder;
import org.apache.lucene.queryParser.standard.config.NumericConfig;
import org.apache.lucene.queryParser.standard.nodes.NumericQueryNode;
import org.apache.lucene.queryParser.standard.nodes.NumericRangeQueryNode;
import org.apache.lucene.search.NumericRangeQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumericRangeQueryNodeBuilder
implements StandardQueryBuilder {
    public NumericRangeQuery<? extends Number> build(QueryNode queryNode) throws QueryNodeException {
        NumericRangeQueryNode numericRangeNode = (NumericRangeQueryNode)queryNode;
        NumericQueryNode lowerNumericNode = (NumericQueryNode)numericRangeNode.getLowerBound();
        NumericQueryNode upperNumericNode = (NumericQueryNode)numericRangeNode.getUpperBound();
        Number lowerNumber = lowerNumericNode != null ? (Number)lowerNumericNode.getValue() : (Number)null;
        Number upperNumber = upperNumericNode != null ? (Number)upperNumericNode.getValue() : (Number)null;
        NumericConfig numericConfig = numericRangeNode.getNumericConfig();
        NumericField.DataType numberType = numericConfig.getType();
        String field = StringUtils.toString(numericRangeNode.getField());
        boolean minInclusive = numericRangeNode.isLowerInclusive();
        boolean maxInclusive = numericRangeNode.isUpperInclusive();
        int precisionStep = numericConfig.getPrecisionStep();
        switch (numberType) {
            case LONG: {
                return NumericRangeQuery.newLongRange((String)field, (int)precisionStep, (Long)((Long)lowerNumber), (Long)((Long)upperNumber), (boolean)minInclusive, (boolean)maxInclusive);
            }
            case INT: {
                return NumericRangeQuery.newIntRange((String)field, (int)precisionStep, (Integer)((Integer)lowerNumber), (Integer)((Integer)upperNumber), (boolean)minInclusive, (boolean)maxInclusive);
            }
            case FLOAT: {
                return NumericRangeQuery.newFloatRange((String)field, (int)precisionStep, (Float)((Float)lowerNumber), (Float)((Float)upperNumber), (boolean)minInclusive, (boolean)maxInclusive);
            }
            case DOUBLE: {
                return NumericRangeQuery.newDoubleRange((String)field, (int)precisionStep, (Double)((Double)lowerNumber), (Double)((Double)upperNumber), (boolean)minInclusive, (boolean)maxInclusive);
            }
        }
        throw new QueryNodeException((Message)new MessageImpl(QueryParserMessages.UNSUPPORTED_NUMERIC_DATA_TYPE, new Object[]{numberType}));
    }
}

