/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.alloy.util;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DefaultValueUtil {
    private static final List<String> _EMPTY_STRINGS = Arrays.asList("", "''", "\"\"", "(empty)", "empty", "EMPTY_STR", "undefined", "WidgetStdMod.BODY", "HTMLTextNode");
    private static final String _GENERATED = "generated";
    private static final List<String> _INFINITY = Arrays.asList("infinity", "Infinity", "INFINITY");

    public static String getDefaultValue(String className, String value) {
        String defaultValue = "";
        if (className.equals(ArrayList.class.getName()) || className.equals(HashMap.class.getName()) || className.equals(Object.class.getName()) || className.equals(String.class.getName())) {
            if (!DefaultValueUtil.isValidStringValue(value)) {
                return defaultValue;
            }
            if (_EMPTY_STRINGS.contains(value)) {
                value = "";
            } else if (className.equals(ArrayList.class.getName()) && !StringUtil.startsWith((String)value.trim(), (String)"[")) {
                value = "[]";
            } else if (className.equals(HashMap.class.getName()) && !StringUtil.startsWith((String)value.trim(), (String)"{")) {
                value = "{}";
            }
            defaultValue = StringUtil.unquote((String)value);
        } else if (className.equals(Boolean.TYPE.getName()) || className.equals(Boolean.class.getName())) {
            defaultValue = String.valueOf(GetterUtil.getBoolean((String)value));
        } else if (className.equals(Integer.TYPE.getName()) || className.equals(Integer.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Integer.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getInteger((String)value));
        } else if (className.equals(Double.TYPE.getName()) || className.equals(Double.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Double.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getDouble((String)value));
        } else if (className.equals(Float.TYPE.getName()) || className.equals(Float.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Float.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getFloat((String)value));
        } else if (className.equals(Long.TYPE.getName()) || className.equals(Long.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Long.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getLong((String)value));
        } else if (className.equals(Short.TYPE.getName()) || className.equals(Short.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Short.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getShort((String)value));
        } else if (className.equals(Number.class.getName())) {
            if (_INFINITY.contains(value)) {
                value = String.valueOf(Integer.MAX_VALUE);
            }
            defaultValue = String.valueOf(GetterUtil.getNumber((String)value));
        }
        return defaultValue;
    }

    public static boolean isValidStringValue(String value) {
        if (Validator.isNull((String)(value = StringUtil.trim((String)GetterUtil.getString((String)value))))) {
            return false;
        }
        return StringUtils.isAlpha((String)value) || !StringUtils.containsIgnoreCase((String)value, (String)_GENERATED) && !StringUtils.isAlpha((String)value.substring(0, 1)) && !StringUtils.endsWith((String)value, (String)".");
    }
}

