/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.lib.util;

import com.sun.star.lib.util.UrlToFileMapper;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;

public final class NativeLibraryLoader {
    public static void loadLibrary(ClassLoader classLoader, String string) {
        File file = NativeLibraryLoader.getResource(classLoader, System.mapLibraryName(string));
        if (file == null) {
            System.loadLibrary(string);
        } else {
            System.load(file.getAbsolutePath());
        }
    }

    public static File getResource(ClassLoader classLoader, String string) {
        URL[] uRLArray;
        if (classLoader != null && (uRLArray = UrlToFileMapper.mapUrlToFile(classLoader.getResource(string))) != null) {
            return uRLArray;
        }
        if (classLoader instanceof URLClassLoader) {
            uRLArray = ((URLClassLoader)classLoader).getURLs();
            for (int i = 0; i < uRLArray.length; ++i) {
                File file;
                File file2 = UrlToFileMapper.mapUrlToFile(uRLArray[i]);
                if (file2 == null) continue;
                File file3 = file = file2.isDirectory() ? file2 : file2.getParentFile();
                if (file == null) continue;
                file2 = new File(file, string);
                if (file2.exists()) {
                    return file2;
                }
                if ((file = file.getParentFile()) == null || !(file2 = new File(file, string)).exists()) continue;
                return file2;
            }
        }
        return null;
    }

    private NativeLibraryLoader() {
    }
}

