/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.common.filespecification;

import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.common.filespecification.PDFileSpecification;

public class PDComplexFileSpecification
extends PDFileSpecification {
    private COSDictionary fs;

    public PDComplexFileSpecification() {
        this.fs = new COSDictionary();
        this.fs.setItem(COSName.TYPE, (COSBase)COSName.FILESPEC);
    }

    public PDComplexFileSpecification(COSDictionary dict) {
        this.fs = dict;
    }

    public COSBase getCOSObject() {
        return this.fs;
    }

    public COSDictionary getCOSDictionary() {
        return this.fs;
    }

    public String getFilename() {
        if (this.getUnicodeFile() != null) {
            return this.getUnicodeFile();
        }
        if (this.getFileDos() != null) {
            return this.getFileDos();
        }
        if (this.getFileMac() != null) {
            return this.getFileMac();
        }
        if (this.getFileUnix() != null) {
            return this.getFileUnix();
        }
        return this.getFile();
    }

    public String getUnicodeFile() {
        return this.fs.getString(COSName.UF);
    }

    public String getFile() {
        return this.fs.getString(COSName.F);
    }

    public void setFile(String file) {
        this.fs.setString(COSName.F, file);
    }

    public String getFileDos() {
        return this.fs.getString(COSName.DOS);
    }

    public void setFileDos(String file) {
        this.fs.setString(COSName.DOS, file);
    }

    public String getFileMac() {
        return this.fs.getString(COSName.MAC);
    }

    public void setFileMac(String file) {
        this.fs.setString(COSName.MAC, file);
    }

    public String getFileUnix() {
        return this.fs.getString(COSName.UNIX);
    }

    public void setFileUnix(String file) {
        this.fs.setString(COSName.UNIX, file);
    }

    public void setVolatile(boolean fileIsVolatile) {
        this.fs.setBoolean(COSName.V, fileIsVolatile);
    }

    public boolean isVolatile() {
        return this.fs.getBoolean(COSName.V, false);
    }

    public PDEmbeddedFile getEmbeddedFile() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/F");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFile(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject(COSName.EF);
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.F, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileDos() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/DOS");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileDos(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject(COSName.DOS);
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.DOS, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileMac() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/Mac");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileMac(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject(COSName.MAC);
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.MAC, (COSObjectable)file);
        }
    }

    public PDEmbeddedFile getEmbeddedFileUnix() {
        PDEmbeddedFile file = null;
        COSStream stream = (COSStream)this.fs.getObjectFromPath("EF/Unix");
        if (stream != null) {
            file = new PDEmbeddedFile(stream);
        }
        return file;
    }

    public void setEmbeddedFileUnix(PDEmbeddedFile file) {
        COSDictionary ef = (COSDictionary)this.fs.getDictionaryObject(COSName.UNIX);
        if (ef == null && file != null) {
            ef = new COSDictionary();
            this.fs.setItem(COSName.EF, (COSBase)ef);
        }
        if (ef != null) {
            ef.setItem(COSName.UNIX, (COSObjectable)file);
        }
    }
}

