/*
 * Decompiled with CFR 0.152.
 */
package org.jamwiki.parser.jflex;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.jamwiki.parser.ParserException;
import org.jamwiki.parser.jflex.HtmlTagItem;
import org.jamwiki.parser.jflex.JFlexParserUtil;
import org.jamwiki.utils.WikiLogger;

class JFlexTagItem {
    private static final WikiLogger logger = WikiLogger.getLogger(JFlexTagItem.class.getName());
    private static final List<String> EMPTY_BODY_TAGS = Arrays.asList("br", "col", "div", "hr", "td", "th");
    private static final List<String> LIST_ITEM_TAGS = Arrays.asList("dd", "dt", "li");
    private static final List<String> LIST_TAGS = Arrays.asList("dd", "dl", "dt", "li", "ol", "ul");
    private static final List<String> NON_NESTING_TAGS = Arrays.asList("col", "colgroup", "dd", "dl", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "ul");
    private static final List<String> NON_TEXT_BODY_TAGS = Arrays.asList("col", "colgroup", "dl", "ol", "table", "tbody", "tfoot", "thead", "tr", "ul");
    private static final List<String> NON_INLINE_TAGS = Arrays.asList("caption", "col", "colgroup", "dd", "div", "dl", "dt", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "li", "ol", "p", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "ul");
    private static final String nonInlineTagPattern = "(caption|col|colgroup|dd|div|dl|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|table|tbody|td|tfoot|th|thead|tr|ul)";
    private static final String nonInlineTagStartPattern = "<(caption|col|colgroup|dd|div|dl|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|table|tbody|td|tfoot|th|thead|tr|ul)[ >].*";
    private static final String nonInlineTagEndPattern = ".*</(caption|col|colgroup|dd|div|dl|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|table|tbody|td|tfoot|th|thead|tr|ul)>";
    private static final Pattern NON_INLINE_TAG_START_PATTERN = Pattern.compile("<(caption|col|colgroup|dd|div|dl|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|table|tbody|td|tfoot|th|thead|tr|ul)[ >].*", 34);
    private static final Pattern NON_INLINE_TAG_END_PATTERN = Pattern.compile(".*</(caption|col|colgroup|dd|div|dl|dt|h1|h2|h3|h4|h5|h6|hr|li|ol|p|table|tbody|td|tfoot|th|thead|tr|ul)>", 34);
    protected static final String ROOT_TAG = "jflex-root";
    private String closeTagOverride = null;
    private HtmlTagItem htmlTagItem = null;
    private final StringBuilder tagContent = new StringBuilder();
    private String tagType = null;

    JFlexTagItem(String tagType, String openTagRaw) throws ParserException {
        this.htmlTagItem = JFlexParserUtil.sanitizeHtmlTag(openTagRaw);
        if (tagType == null && this.htmlTagItem == null) {
            throw new IllegalArgumentException("tagType must not be null");
        }
        this.tagType = tagType == null ? this.htmlTagItem.getTagType() : tagType;
    }

    protected String getCloseTagOverride() {
        return this.closeTagOverride;
    }

    protected void setCloseTagOverride(String closeTagOverride) {
        this.closeTagOverride = closeTagOverride;
    }

    protected StringBuilder getTagContent() {
        return this.tagContent;
    }

    protected String getTagType() {
        return this.tagType;
    }

    protected void changeTagType(String tagType) {
        this.tagType = tagType;
    }

    private boolean isEmptyBodyTag() {
        if (this.isRootTag()) {
            return true;
        }
        return EMPTY_BODY_TAGS.indexOf(this.tagType) != -1;
    }

    protected boolean isInlineTag() {
        if (this.isRootTag()) {
            return true;
        }
        return NON_INLINE_TAGS.indexOf(this.tagType) == -1;
    }

    protected boolean isListItemTag() {
        return JFlexTagItem.isListItemTag(this.tagType);
    }

    protected static boolean isListItemTag(String tagType) {
        return LIST_ITEM_TAGS.indexOf(tagType) != -1;
    }

    protected boolean isListTag() {
        return JFlexTagItem.isListTag(this.tagType);
    }

    protected static boolean isListTag(String tagType) {
        return LIST_TAGS.indexOf(tagType) != -1;
    }

    protected boolean isNonNestingTag() {
        return JFlexTagItem.isNonNestingTag(this.tagType);
    }

    protected static boolean isNonNestingTag(String tagType) {
        return NON_NESTING_TAGS.indexOf(tagType) != -1;
    }

    private boolean isNonInlineTagEnd(String tagText) {
        if (!tagText.endsWith(">")) {
            return false;
        }
        Matcher matcher = NON_INLINE_TAG_END_PATTERN.matcher(tagText);
        return matcher.matches();
    }

    private boolean isNonInlineTagStart(String tagText) {
        if (!tagText.startsWith("<")) {
            return false;
        }
        Matcher matcher = NON_INLINE_TAG_START_PATTERN.matcher(tagText);
        return matcher.matches();
    }

    private boolean isTextBodyTag() {
        if (this.isRootTag()) {
            return true;
        }
        return NON_TEXT_BODY_TAGS.indexOf(this.tagType) == -1;
    }

    protected boolean isRootTag() {
        return this.tagType.equals(ROOT_TAG);
    }

    public String toHtml() {
        String content = this.tagContent.toString();
        if (StringUtils.isBlank((String)content) && !this.isEmptyBodyTag()) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        if (!this.isRootTag()) {
            if (this.htmlTagItem != null) {
                result.append(this.htmlTagItem.getHtml());
            } else {
                result.append('<').append(this.tagType).append('>');
            }
        }
        if (this.isRootTag()) {
            result.append(content);
        } else if (this.tagType.equals("pre")) {
            if (!content.startsWith("\n")) {
                result.append('\n');
            }
            result.append(content);
            if (!content.endsWith("\n")) {
                result.append('\n');
            }
        } else if (this.isTextBodyTag()) {
            if (this.isNonInlineTagStart(content.trim())) {
                result.append('\n');
            }
            result.append(content.trim());
            if (this.isNonInlineTagEnd(content.trim())) {
                result.append('\n');
            }
        } else {
            result.append('\n');
            result.append(content.trim());
            result.append('\n');
        }
        if (!this.isRootTag()) {
            result.append("</").append(this.tagType).append('>');
        }
        if (this.isTextBodyTag() && !this.isRootTag() && this.isInlineTag() && !this.tagType.equals("pre")) {
            int lastWhitespaceIndex;
            int firstWhitespaceIndex = content.indexOf(content.trim());
            if (firstWhitespaceIndex > 0) {
                result.insert(0, content.substring(0, firstWhitespaceIndex));
            }
            if ((lastWhitespaceIndex = firstWhitespaceIndex + content.trim().length()) > content.length()) {
                result.append(content.substring(lastWhitespaceIndex));
            }
        }
        return result.toString();
    }
}

