/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.security.pacl;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.security.pacl.ActivePACLPolicy;
import com.liferay.portal.security.pacl.checker.AuthorizationProperty;
import com.liferay.portal.security.pacl.checker.Checker;
import com.liferay.portal.security.pacl.checker.JNDIChecker;
import com.liferay.portal.security.pacl.checker.SQLChecker;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.locks.ReentrantLock;

public class GeneratingPACLPolicy
extends ActivePACLPolicy {
    private static Log _log = LogFactoryUtil.getLog(GeneratingPACLPolicy.class);
    private Map<String, Set<String>> _properties = new ConcurrentSkipListMap<String, Set<String>>();
    private ReentrantLock _reentrantLock = new ReentrantLock();

    public GeneratingPACLPolicy(String servletContextName, ClassLoader classLoader, Properties properties) {
        super(servletContextName, classLoader, properties);
    }

    @Override
    public boolean hasJNDI(String name) {
        JNDIChecker jndiChecker = this.getJndiChecker();
        if (!jndiChecker.hasJNDI(name)) {
            AuthorizationProperty authorizationProperty = jndiChecker.generateAuthorizationProperty(name);
            if (authorizationProperty == null) {
                return false;
            }
            this.mergeAuthorizationProperty(authorizationProperty);
        }
        return true;
    }

    @Override
    public boolean hasSQL(String sql) {
        SQLChecker sqlChecker = this.getSqlChecker();
        if (!sqlChecker.hasSQL(sql)) {
            AuthorizationProperty authorizationProperty = sqlChecker.generateAuthorizationProperty(sql);
            if (authorizationProperty == null) {
                return false;
            }
            this.mergeAuthorizationProperty(authorizationProperty);
        }
        return true;
    }

    @Override
    public boolean implies(Permission permission) {
        AuthorizationProperty authorizationProperty;
        block4: {
            Checker checker = this.getChecker(permission.getClass());
            if (checker.implies(permission)) {
                return true;
            }
            try {
                authorizationProperty = checker.generateAuthorizationProperty(permission);
                if (authorizationProperty != null) break block4;
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
        this.mergeAuthorizationProperty(authorizationProperty);
        return true;
    }

    protected void mergeAuthorizationProperty(AuthorizationProperty authorizationProperty) {
        AccessController.doPrivileged(new AuthorizationPropertyPrivilegedAction(authorizationProperty));
    }

    protected void mergeExistingProperties() {
        Properties properties = this.getProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            if (this._properties.containsKey(key) || !key.startsWith("security-manager-") || key.equals("security-manager-enabled")) continue;
            this._properties.put(key, this.getPropertySet(key));
        }
    }

    protected void writePACLPolicyFile() {
        try {
            StringBundler sb = new StringBundler();
            for (Map.Entry<String, Set<String>> entry : this._properties.entrySet()) {
                String key = entry.getKey();
                sb.append(key);
                sb.append("=");
                Set<String> values = entry.getValue();
                for (String value : values) {
                    sb.append("\\");
                    sb.append("\n");
                    sb.append("    ");
                    sb.append(value);
                    sb.append(",");
                }
                sb.setIndex(sb.index() - 1);
                sb.append("\n\n");
            }
            if (sb.length() > 0) {
                sb.setIndex(sb.index() - 1);
            }
            FileUtil.write((String)(String.valueOf(PropsValues.LIFERAY_HOME) + "/pacl-policy"), (String)(String.valueOf(this.getServletContextName()) + ".pacl-policy"), (String)sb.toString());
        }
        catch (IOException ioe) {
            _log.error((Object)ioe, (Throwable)ioe);
        }
    }

    private class AuthorizationPropertyPrivilegedAction
    implements PrivilegedAction<Void> {
        private AuthorizationProperty _authorizationProperty;

        public AuthorizationPropertyPrivilegedAction(AuthorizationProperty authorizationProperty) {
            this._authorizationProperty = authorizationProperty;
        }

        @Override
        public Void run() {
            String key = this._authorizationProperty.getKey();
            Set<String> values = (Set<String>)GeneratingPACLPolicy.this._properties.get(key);
            boolean modified = false;
            if (values == null) {
                values = GeneratingPACLPolicy.this.getPropertySet(key);
                modified = true;
            }
            String[] stringArray = this._authorizationProperty.getValues();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                if (!values.contains(value)) {
                    values.add(value);
                    modified = true;
                }
                ++n2;
            }
            if (!modified) {
                return null;
            }
            GeneratingPACLPolicy.this._reentrantLock.lock();
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(String.valueOf(GeneratingPACLPolicy.this.getServletContextName()) + " generated authorization property " + this._authorizationProperty));
                }
                GeneratingPACLPolicy.this._properties.put(key, values);
                GeneratingPACLPolicy.this.mergeExistingProperties();
                GeneratingPACLPolicy.this.writePACLPolicyFile();
            }
            finally {
                GeneratingPACLPolicy.this._reentrantLock.unlock();
            }
            return null;
        }
    }
}

