/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.sharepoint;

import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.InstancePool;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.webdav.WebDAVException;
import com.liferay.portal.kernel.webdav.WebDAVUtil;
import com.liferay.portal.security.auth.CompanyThreadLocal;
import com.liferay.portal.sharepoint.CompanySharepointStorageImpl;
import com.liferay.portal.sharepoint.GroupSharepointStorageImpl;
import com.liferay.portal.sharepoint.SharepointStorage;
import com.liferay.portal.util.PropsUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class SharepointUtil {
    public static final String VEERMER_URLENCODED = "application/x-vermeer-urlencoded";
    public static final String VERSION = "6.0.2.8117";
    private static Log _log = LogFactoryUtil.getLog(SharepointUtil.class);
    private static SharepointUtil _instance = new SharepointUtil();
    private final Map<String, String> _storageMap = new HashMap<String, String>();

    public static long getGroupId(String path) {
        long groupId;
        block2: {
            groupId = 0L;
            long companyId = CompanyThreadLocal.getCompanyId();
            try {
                groupId = WebDAVUtil.getGroupId((long)companyId, (String)path);
            }
            catch (WebDAVException webDAVException) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn((Object)("Unable to get groupId for path " + path));
            }
        }
        return groupId;
    }

    public static String[] getPathArray(String path) {
        path = HttpUtil.fixPath((String)path, (boolean)true, (boolean)true);
        return StringUtil.split((String)path, (char)'/');
    }

    public static SharepointStorage getStorage(String path) {
        String storageClass = null;
        if (path == null) {
            return null;
        }
        String[] pathArray = SharepointUtil.getPathArray(path);
        if (pathArray.length == 0) {
            storageClass = CompanySharepointStorageImpl.class.getName();
        } else if (pathArray.length == 1) {
            storageClass = GroupSharepointStorageImpl.class.getName();
        } else if (pathArray.length >= 2) {
            storageClass = SharepointUtil.getStorageClass(pathArray[1]);
        }
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Storage class for path " + path + " is " + storageClass));
        }
        return (SharepointStorage)InstancePool.get((String)storageClass);
    }

    public static String getStorageClass(String token) {
        return _instance._getStorageClass(token);
    }

    public static String getStorageToken(String className) {
        return _instance._getStorageToken(className);
    }

    public static Collection<String> getStorageTokens() {
        return _instance._getStorageTokens();
    }

    public static String replaceBackSlashes(String value) {
        return value.replaceAll("\\\\", "");
    }

    public static String stripService(String url, boolean trailingSlash) {
        return _instance._stripService(url, trailingSlash);
    }

    private SharepointUtil() {
        String[] tokens;
        String[] stringArray = tokens = PropsUtil.getArray("sharepoint.storage.tokens");
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            String token = stringArray[n2];
            Filter filter = new Filter(token);
            String className = PropsUtil.get("sharepoint.storage.class", filter);
            if (Validator.isNotNull((String)className)) {
                this._storageMap.put(className, token);
            }
            ++n2;
        }
    }

    private String _getStorageClass(String token) {
        for (Map.Entry<String, String> entry : this._storageMap.entrySet()) {
            String value = entry.getValue();
            if (!value.equals(token)) continue;
            return entry.getKey();
        }
        return null;
    }

    private String _getStorageToken(String className) {
        return this._storageMap.get(className);
    }

    private Collection<String> _getStorageTokens() {
        return this._storageMap.values();
    }

    private String _stripService(String url, boolean trailingSlash) {
        url = this._stripService(url, "sharepoint", trailingSlash);
        url = this._stripService(url, "webdav", trailingSlash);
        return url;
    }

    private String _stripService(String url, String service, boolean trailingSlash) {
        service = trailingSlash ? String.valueOf(service) + "/" : "/" + service;
        int pos = url.lastIndexOf(service);
        if (pos != -1) {
            url = url.substring(pos + service.length());
        }
        return url;
    }
}

