/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.bookmarks.service.impl;

import com.liferay.portal.kernel.dao.orm.Criterion;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.Property;
import com.liferay.portal.kernel.dao.orm.PropertyFactoryUtil;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackRegistryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.AuditedModel;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.ServiceContextUtil;
import com.liferay.portal.util.SubscriptionSender;
import com.liferay.portlet.asset.model.AssetEntry;
import com.liferay.portlet.bookmarks.EntryURLException;
import com.liferay.portlet.bookmarks.model.BookmarksEntry;
import com.liferay.portlet.bookmarks.model.BookmarksFolder;
import com.liferay.portlet.bookmarks.service.base.BookmarksEntryLocalServiceBaseImpl;
import com.liferay.portlet.bookmarks.service.persistence.BookmarksEntryActionableDynamicQuery;
import com.liferay.portlet.bookmarks.util.BookmarksUtil;
import com.liferay.portlet.bookmarks.util.comparator.EntryModifiedDateComparator;
import com.liferay.portlet.trash.model.TrashEntry;
import com.liferay.portlet.trash.model.TrashVersion;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.portlet.PortletPreferences;

public class BookmarksEntryLocalServiceImpl
extends BookmarksEntryLocalServiceBaseImpl {
    private static Log _log = LogFactoryUtil.getLog(BookmarksEntryLocalServiceImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry addEntry(long userId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        Date now = new Date();
        this.validate(url);
        long entryId = this.counterLocalService.increment();
        BookmarksEntry entry = this.bookmarksEntryPersistence.create(entryId);
        entry.setUuid(serviceContext.getUuid());
        entry.setGroupId(groupId);
        entry.setCompanyId(user.getCompanyId());
        entry.setUserId(user.getUserId());
        entry.setUserName(user.getFullName());
        entry.setCreateDate(serviceContext.getCreateDate(now));
        entry.setModifiedDate(serviceContext.getModifiedDate(now));
        entry.setFolderId(folderId);
        entry.setTreePath(entry.buildTreePath());
        entry.setName(name);
        entry.setUrl(url);
        entry.setDescription(description);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry);
        this.resourceLocalService.addModelResources((AuditedModel)entry, serviceContext);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getName());
        this.socialActivityLocalService.addActivity(userId, groupId, BookmarksEntry.class.getName(), entryId, 1, extraDataJSONObject.toString(), 0L);
        this.notifySubscribers(entry, serviceContext);
        return entry;
    }

    public void deleteEntries(long groupId, long folderId) throws PortalException, SystemException {
        this.deleteEntries(groupId, folderId, true);
    }

    public void deleteEntries(long groupId, long folderId, boolean includeTrashedEntries) throws PortalException, SystemException {
        List entries = this.bookmarksEntryPersistence.findByG_F(groupId, folderId);
        for (BookmarksEntry entry : entries) {
            if (!includeTrashedEntries && entry.isInTrashExplicitly()) continue;
            this.bookmarksEntryLocalService.deleteEntry(entry);
        }
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksEntry deleteEntry(BookmarksEntry entry) throws PortalException, SystemException {
        this.bookmarksEntryPersistence.remove((BaseModel)entry);
        this.resourceLocalService.deleteResource((AuditedModel)entry, 4);
        this.assetEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        this.expandoRowLocalService.deleteRows(entry.getEntryId());
        this.subscriptionLocalService.deleteSubscriptions(entry.getCompanyId(), BookmarksEntry.class.getName(), entry.getEntryId());
        this.trashEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        return entry;
    }

    @Indexable(type=IndexableType.DELETE)
    public BookmarksEntry deleteEntry(long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        return this.deleteEntry(entry);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end) throws SystemException {
        return this.getEntries(groupId, folderId, 0, start, end);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int status, int start, int end) throws SystemException {
        return this.getEntries(groupId, folderId, status, start, end, null);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int status, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.bookmarksEntryPersistence.findByG_F_S(groupId, folderId, status, start, end, orderByComparator);
    }

    public List<BookmarksEntry> getEntries(long groupId, long folderId, int start, int end, OrderByComparator orderByComparator) throws SystemException {
        return this.getEntries(groupId, folderId, 0, start, end, orderByComparator);
    }

    public int getEntriesCount(long groupId, long folderId) throws SystemException {
        return this.getEntriesCount(groupId, folderId, 0);
    }

    public int getEntriesCount(long groupId, long folderId, int status) throws SystemException {
        return this.bookmarksEntryPersistence.countByG_F_S(groupId, folderId, status);
    }

    public BookmarksEntry getEntry(long entryId) throws PortalException, SystemException {
        return this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
    }

    public int getFoldersEntriesCount(long groupId, List<Long> folderIds) throws SystemException {
        return this.bookmarksEntryPersistence.countByG_F_S(groupId, ArrayUtil.toArray((Long[])folderIds.toArray(new Long[folderIds.size()])), 0);
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, int start, int end) throws SystemException {
        return this.bookmarksEntryPersistence.findByG_S(groupId, 0, start, end, (OrderByComparator)new EntryModifiedDateComparator());
    }

    public List<BookmarksEntry> getGroupEntries(long groupId, long userId, int start, int end) throws SystemException {
        EntryModifiedDateComparator orderByComparator = new EntryModifiedDateComparator();
        if (userId <= 0L) {
            return this.bookmarksEntryPersistence.findByG_S(groupId, 0, start, end, (OrderByComparator)orderByComparator);
        }
        return this.bookmarksEntryPersistence.findByG_U_S(groupId, userId, 0, start, end, (OrderByComparator)orderByComparator);
    }

    public int getGroupEntriesCount(long groupId) throws SystemException {
        return this.bookmarksEntryPersistence.countByG_S(groupId, 0);
    }

    public int getGroupEntriesCount(long groupId, long userId) throws SystemException {
        if (userId <= 0L) {
            return this.getGroupEntriesCount(groupId);
        }
        return this.bookmarksEntryPersistence.countByG_U_S(groupId, userId, 0);
    }

    public List<BookmarksEntry> getNoAssetEntries() throws SystemException {
        return this.bookmarksEntryFinder.findByNoAssets();
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntry(long entryId, long parentFolderId) throws PortalException, SystemException {
        BookmarksEntry entry = this.getBookmarksEntry(entryId);
        entry.setFolderId(parentFolderId);
        entry.setTreePath(entry.buildTreePath());
        this.bookmarksEntryPersistence.update((BaseModel)entry);
        return entry;
    }

    public BookmarksEntry moveEntryFromTrash(long userId, long entryId, long parentFolderId) throws PortalException, SystemException {
        BookmarksEntry entry = this.getBookmarksEntry(entryId);
        if (entry.isInTrashExplicitly()) {
            this.restoreEntryFromTrash(userId, entryId);
        } else {
            TrashEntry trashEntry = entry.getTrashEntry();
            TrashVersion trashVersion = this.trashVersionLocalService.fetchVersion(trashEntry.getEntryId(), BookmarksEntry.class.getName(), entryId);
            int status = 0;
            if (trashVersion != null) {
                status = trashVersion.getStatus();
            }
            this.updateStatus(userId, entry, status);
            if (trashVersion != null) {
                this.trashVersionLocalService.deleteTrashVersion(trashVersion);
            }
        }
        return this.bookmarksEntryLocalService.moveEntry(entryId, parentFolderId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntryToTrash(long userId, BookmarksEntry entry) throws PortalException, SystemException {
        int oldStatus = entry.getStatus();
        entry = this.updateStatus(userId, entry, 8);
        this.trashEntryLocalService.addTrashEntry(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUuid(), null, oldStatus, null, null);
        return entry;
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry moveEntryToTrash(long userId, long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.getEntry(entryId);
        return this.moveEntryToTrash(userId, entry);
    }

    public BookmarksEntry openEntry(long userId, BookmarksEntry entry) throws SystemException {
        entry.setVisits(entry.getVisits() + 1);
        this.bookmarksEntryPersistence.update((BaseModel)entry);
        this.assetEntryLocalService.incrementViewCounter(userId, BookmarksEntry.class.getName(), entry.getEntryId(), 1);
        return entry;
    }

    public BookmarksEntry openEntry(long userId, long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        return this.openEntry(userId, entry);
    }

    public void rebuildTree(long companyId) throws PortalException, SystemException {
        this.bookmarksFolderLocalService.rebuildTree(companyId);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry restoreEntryFromTrash(long userId, long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        TrashEntry trashEntry = this.trashEntryLocalService.getEntry(BookmarksEntry.class.getName(), entryId);
        entry = this.updateStatus(userId, entry, trashEntry.getStatus());
        this.trashEntryLocalService.deleteEntry(BookmarksEntry.class.getName(), entry.getEntryId());
        return entry;
    }

    public Hits search(long groupId, long userId, long creatorUserId, int status, int start, int end) throws PortalException, SystemException {
        Indexer indexer = IndexerRegistryUtil.getIndexer((String)BookmarksEntry.class.getName());
        SearchContext searchContext = new SearchContext();
        searchContext.setAttribute("status", (Serializable)Integer.valueOf(status));
        if (creatorUserId > 0L) {
            searchContext.setAttribute("userId", (Serializable)((Object)String.valueOf(creatorUserId)));
        }
        searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
        Group group = this.groupLocalService.getGroup(groupId);
        searchContext.setCompanyId(group.getCompanyId());
        searchContext.setEnd(end);
        searchContext.setGroupIds(new long[]{groupId});
        searchContext.setSorts(new Sort[]{new Sort("modified", true)});
        searchContext.setStart(start);
        searchContext.setUserId(userId);
        return indexer.search(searchContext);
    }

    public void setTreePaths(final long folderId, final String treePath, final boolean reindex) throws PortalException, SystemException {
        if (treePath == null) {
            throw new IllegalArgumentException("Tree path is null");
        }
        final Indexer indexer = IndexerRegistryUtil.getIndexer((String)BookmarksEntry.class.getName());
        BookmarksEntryActionableDynamicQuery actionableDynamicQuery = new BookmarksEntryActionableDynamicQuery(){

            protected void addCriteria(DynamicQuery dynamicQuery) {
                Property folderIdProperty = PropertyFactoryUtil.forName((String)"folderId");
                dynamicQuery.add(folderIdProperty.eq((Object)folderId));
                Property treePathProperty = PropertyFactoryUtil.forName((String)"treePath");
                dynamicQuery.add(RestrictionsFactoryUtil.or((Criterion)treePathProperty.isNull(), (Criterion)treePathProperty.ne((Object)treePath)));
            }

            protected void performAction(Object object) throws PortalException, SystemException {
                BookmarksEntry entry = (BookmarksEntry)object;
                entry.setTreePath(treePath);
                BookmarksEntryLocalServiceImpl.this.updateBookmarksEntry(entry);
                if (!reindex) {
                    return;
                }
                indexer.reindex((Object)entry);
            }
        };
        actionableDynamicQuery.performActions();
    }

    public void subscribeEntry(long userId, long entryId) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        this.subscriptionLocalService.addSubscription(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entryId);
    }

    public void unsubscribeEntry(long userId, long entryId) throws PortalException, SystemException {
        this.subscriptionLocalService.deleteSubscription(userId, BookmarksEntry.class.getName(), entryId);
    }

    public void updateAsset(long userId, BookmarksEntry entry, long[] assetCategoryIds, String[] assetTagNames, long[] assetLinkEntryIds) throws PortalException, SystemException {
        AssetEntry assetEntry = this.assetEntryLocalService.updateEntry(userId, entry.getGroupId(), entry.getCreateDate(), entry.getModifiedDate(), BookmarksEntry.class.getName(), entry.getEntryId(), entry.getUuid(), 0L, assetCategoryIds, assetTagNames, true, null, null, null, "text/plain", entry.getName(), entry.getDescription(), null, entry.getUrl(), null, 0, 0, null, false);
        this.assetLinkLocalService.updateLinks(userId, assetEntry.getEntryId(), assetLinkEntryIds, 0);
    }

    @Indexable(type=IndexableType.REINDEX)
    public BookmarksEntry updateEntry(long userId, long entryId, long groupId, long folderId, String name, String url, String description, ServiceContext serviceContext) throws PortalException, SystemException {
        BookmarksEntry entry = this.bookmarksEntryPersistence.findByPrimaryKey(entryId);
        if (Validator.isNull((String)name)) {
            name = url;
        }
        this.validate(url);
        entry.setModifiedDate(serviceContext.getModifiedDate(null));
        entry.setFolderId(folderId);
        entry.setTreePath(entry.buildTreePath());
        entry.setName(name);
        entry.setUrl(url);
        entry.setDescription(description);
        entry.setExpandoBridgeAttributes(serviceContext);
        this.bookmarksEntryPersistence.update((BaseModel)entry);
        this.updateAsset(userId, entry, serviceContext.getAssetCategoryIds(), serviceContext.getAssetTagNames(), serviceContext.getAssetLinkEntryIds());
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getName());
        this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entryId, 2, extraDataJSONObject.toString(), 0L);
        this.notifySubscribers(entry, serviceContext);
        return entry;
    }

    public BookmarksEntry updateStatus(long userId, BookmarksEntry entry, int status) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        entry.setStatus(status);
        entry.setStatusByUserId(userId);
        entry.setStatusByUserName(user.getScreenName());
        entry.setStatusDate(new Date());
        this.bookmarksEntryPersistence.update((BaseModel)entry);
        JSONObject extraDataJSONObject = JSONFactoryUtil.createJSONObject();
        extraDataJSONObject.put("title", entry.getName());
        if (status == 0) {
            this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), true);
            this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), 10008, extraDataJSONObject.toString(), 0L);
        } else if (status == 8) {
            this.assetEntryLocalService.updateVisible(BookmarksEntry.class.getName(), entry.getEntryId(), false);
            this.socialActivityLocalService.addActivity(userId, entry.getGroupId(), BookmarksEntry.class.getName(), entry.getEntryId(), 10007, extraDataJSONObject.toString(), 0L);
        }
        return entry;
    }

    protected long getFolder(BookmarksEntry entry, long folderId) throws SystemException {
        BookmarksFolder newFolder;
        if (entry.getFolderId() != folderId && folderId != 0L && ((newFolder = this.bookmarksFolderPersistence.fetchByPrimaryKey(folderId)) == null || entry.getGroupId() != newFolder.getGroupId())) {
            folderId = entry.getFolderId();
        }
        return folderId;
    }

    protected void notify(final SubscriptionSender subscriptionSender) {
        TransactionCommitCallbackRegistryUtil.registerCallback((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                subscriptionSender.flushNotificationsAsync();
                return null;
            }
        });
    }

    protected void notifySubscribers(BookmarksEntry entry, ServiceContext serviceContext) throws PortalException, SystemException {
        String layoutFullURL = serviceContext.getLayoutFullURL();
        if (Validator.isNull((String)layoutFullURL)) {
            return;
        }
        PortletPreferences preferences = ServiceContextUtil.getPortletPreferences((ServiceContext)serviceContext);
        if (preferences == null) {
            long ownerId = entry.getGroupId();
            int ownerType = 2;
            long plid = 0L;
            String portletId = "28";
            String defaultPreferences = null;
            preferences = this.portletPreferencesLocalService.getPreferences(entry.getCompanyId(), ownerId, ownerType, plid, portletId, defaultPreferences);
        }
        if (serviceContext.isCommandAdd() && !BookmarksUtil.getEmailEntryAddedEnabled(preferences) || serviceContext.isCommandUpdate() && !BookmarksUtil.getEmailEntryUpdatedEnabled(preferences)) {
            return;
        }
        String statusByUserName = "";
        try {
            User user = this.userLocalService.getUserById(serviceContext.getGuestOrUserId());
            statusByUserName = user.getFullName();
        }
        catch (Exception e2) {
            _log.error((Object)e2, (Throwable)e2);
        }
        String entryURL = String.valueOf(layoutFullURL) + "/-/" + "bookmarks" + "/" + entry.getEntryId();
        String fromAddress = BookmarksUtil.getEmailFromAddress(preferences, entry.getCompanyId());
        String fromName = BookmarksUtil.getEmailFromName(preferences, entry.getCompanyId());
        Map<Locale, String> localizedSubjectMap = null;
        Map<Locale, String> localizedBodyMap = null;
        if (serviceContext.isCommandUpdate()) {
            localizedSubjectMap = BookmarksUtil.getEmailEntryUpdatedSubjectMap(preferences);
            localizedBodyMap = BookmarksUtil.getEmailEntryUpdatedBodyMap(preferences);
        } else {
            localizedSubjectMap = BookmarksUtil.getEmailEntryAddedSubjectMap(preferences);
            localizedBodyMap = BookmarksUtil.getEmailEntryAddedBodyMap(preferences);
        }
        SubscriptionSender subscriptionSender = new SubscriptionSender();
        subscriptionSender.setCompanyId(entry.getCompanyId());
        subscriptionSender.setContextAttributes(new Object[]{"[$BOOKMARKS_ENTRY_STATUS_BY_USER_NAME$]", statusByUserName, "[$BOOKMARKS_ENTRY_URL$]", entryURL});
        subscriptionSender.setContextUserPrefix("BOOKMARKS_ENTRY");
        subscriptionSender.setFrom(fromAddress, fromName);
        subscriptionSender.setHtmlFormat(true);
        subscriptionSender.setLocalizedBodyMap(localizedBodyMap);
        subscriptionSender.setLocalizedSubjectMap(localizedSubjectMap);
        subscriptionSender.setMailId("bookmarks_entry", new Object[]{entry.getEntryId()});
        subscriptionSender.setPortletId("28");
        subscriptionSender.setReplyToAddress(fromAddress);
        subscriptionSender.setScopeGroupId(entry.getGroupId());
        subscriptionSender.setServiceContext(serviceContext);
        subscriptionSender.setUserId(entry.getUserId());
        BookmarksFolder folder = entry.getFolder();
        ArrayList<Long> folderIds = new ArrayList<Long>();
        if (folder != null) {
            folderIds.add(folder.getFolderId());
            folderIds.addAll(folder.getAncestorFolderIds());
        }
        Iterator iterator = folderIds.iterator();
        while (iterator.hasNext()) {
            long curFolderId = (Long)iterator.next();
            subscriptionSender.addPersistedSubscribers(BookmarksFolder.class.getName(), curFolderId);
        }
        subscriptionSender.addPersistedSubscribers(BookmarksFolder.class.getName(), entry.getGroupId());
        subscriptionSender.addPersistedSubscribers(BookmarksEntry.class.getName(), entry.getEntryId());
        this.notify(subscriptionSender);
    }

    protected void validate(String url) throws PortalException {
        if (!Validator.isUrl((String)url)) {
            throw new EntryURLException();
        }
    }
}

