/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.mobiledevicerules.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.model.BaseModel;
import com.liferay.portal.model.User;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portlet.mobiledevicerules.model.MDRAction;
import com.liferay.portlet.mobiledevicerules.model.MDRRuleGroupInstance;
import com.liferay.portlet.mobiledevicerules.service.base.MDRActionLocalServiceBaseImpl;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class MDRActionLocalServiceImpl
extends MDRActionLocalServiceBaseImpl {
    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        User user = this.userPersistence.findByPrimaryKey(serviceContext.getUserId());
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(ruleGroupInstanceId);
        Date now = new Date();
        long actionId = this.counterLocalService.increment();
        MDRAction action = this.mdrActionLocalService.createMDRAction(actionId);
        action.setUuid(serviceContext.getUuid());
        action.setGroupId(ruleGroupInstance.getGroupId());
        action.setCompanyId(serviceContext.getCompanyId());
        action.setCreateDate(serviceContext.getCreateDate(now));
        action.setModifiedDate(serviceContext.getModifiedDate(now));
        action.setUserId(serviceContext.getUserId());
        action.setUserName(user.getFullName());
        action.setClassNameId(ruleGroupInstance.getClassNameId());
        action.setClassPK(ruleGroupInstance.getClassPK());
        action.setRuleGroupInstanceId(ruleGroupInstanceId);
        action.setNameMap(nameMap);
        action.setDescriptionMap(descriptionMap);
        action.setType(type);
        action.setTypeSettings(typeSettings);
        action = this.updateMDRAction(action);
        ruleGroupInstance.setModifiedDate(now);
        this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        return action;
    }

    public MDRAction addAction(long ruleGroupInstanceId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.addAction(ruleGroupInstanceId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }

    public void deleteAction(long actionId) throws SystemException {
        MDRAction action = this.mdrActionPersistence.fetchByPrimaryKey(actionId);
        if (action != null) {
            this.mdrActionLocalService.deleteAction(action);
        }
    }

    @SystemEvent(type=1)
    public void deleteAction(MDRAction action) throws SystemException {
        this.mdrActionPersistence.remove((BaseModel)action);
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.fetchByPrimaryKey(action.getRuleGroupInstanceId());
        if (ruleGroupInstance != null) {
            ruleGroupInstance.setModifiedDate(new Date());
            this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        }
    }

    public void deleteActions(long ruleGroupInstanceId) throws SystemException {
        List actions = this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId);
        for (MDRAction action : actions) {
            this.mdrActionLocalService.deleteAction(action);
        }
    }

    public MDRAction fetchAction(long actionId) throws SystemException {
        return this.mdrActionPersistence.fetchByPrimaryKey(actionId);
    }

    public MDRAction getAction(long actionId) throws PortalException, SystemException {
        return this.mdrActionPersistence.findByPrimaryKey(actionId);
    }

    public List<MDRAction> getActions(long ruleGroupInstanceId) throws SystemException {
        return this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId);
    }

    public List<MDRAction> getActions(long ruleGroupInstanceId, int start, int end) throws SystemException {
        return this.mdrActionPersistence.findByRuleGroupInstanceId(ruleGroupInstanceId, start, end);
    }

    public int getActionsCount(long ruleGroupInstanceId) throws SystemException {
        return this.mdrActionPersistence.countByRuleGroupInstanceId(ruleGroupInstanceId);
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, String typeSettings, ServiceContext serviceContext) throws PortalException, SystemException {
        MDRAction action = this.mdrActionPersistence.findByPrimaryKey(actionId);
        action.setModifiedDate(serviceContext.getModifiedDate(null));
        action.setNameMap(nameMap);
        action.setDescriptionMap(descriptionMap);
        action.setType(type);
        action.setTypeSettings(typeSettings);
        this.mdrActionPersistence.update((BaseModel)action);
        MDRRuleGroupInstance ruleGroupInstance = this.mdrRuleGroupInstancePersistence.findByPrimaryKey(action.getRuleGroupInstanceId());
        ruleGroupInstance.setModifiedDate(serviceContext.getModifiedDate(null));
        this.mdrRuleGroupInstancePersistence.update((BaseModel)ruleGroupInstance);
        return action;
    }

    public MDRAction updateAction(long actionId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, String type, UnicodeProperties typeSettingsProperties, ServiceContext serviceContext) throws PortalException, SystemException {
        return this.updateAction(actionId, nameMap, descriptionMap, type, typeSettingsProperties.toString(), serviceContext);
    }
}

