/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.util;

import com.liferay.portal.NoSuchOrganizationException;
import com.liferay.portal.NoSuchUserGroupException;
import com.liferay.portal.kernel.configuration.Filter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Tuple;
import com.liferay.portal.kernel.util.UniqueList;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.Address;
import com.liferay.portal.model.EmailAddress;
import com.liferay.portal.model.Group;
import com.liferay.portal.model.OrgLabor;
import com.liferay.portal.model.Organization;
import com.liferay.portal.model.Phone;
import com.liferay.portal.model.Role;
import com.liferay.portal.model.User;
import com.liferay.portal.model.UserGroup;
import com.liferay.portal.model.UserGroupRole;
import com.liferay.portal.model.Website;
import com.liferay.portal.security.auth.PrincipalThreadLocal;
import com.liferay.portal.security.membershippolicy.OrganizationMembershipPolicyUtil;
import com.liferay.portal.security.membershippolicy.SiteMembershipPolicyUtil;
import com.liferay.portal.security.permission.PermissionChecker;
import com.liferay.portal.security.permission.PermissionThreadLocal;
import com.liferay.portal.service.AddressLocalServiceUtil;
import com.liferay.portal.service.AddressServiceUtil;
import com.liferay.portal.service.EmailAddressLocalServiceUtil;
import com.liferay.portal.service.EmailAddressServiceUtil;
import com.liferay.portal.service.GroupLocalServiceUtil;
import com.liferay.portal.service.OrgLaborLocalServiceUtil;
import com.liferay.portal.service.OrgLaborServiceUtil;
import com.liferay.portal.service.OrganizationLocalServiceUtil;
import com.liferay.portal.service.PhoneLocalServiceUtil;
import com.liferay.portal.service.PhoneServiceUtil;
import com.liferay.portal.service.RoleLocalServiceUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.service.UserGroupLocalServiceUtil;
import com.liferay.portal.service.UserGroupRoleLocalServiceUtil;
import com.liferay.portal.service.UserLocalServiceUtil;
import com.liferay.portal.service.WebsiteLocalServiceUtil;
import com.liferay.portal.service.WebsiteServiceUtil;
import com.liferay.portal.service.permission.GroupPermissionUtil;
import com.liferay.portal.service.permission.OrganizationPermissionUtil;
import com.liferay.portal.service.permission.RolePermissionUtil;
import com.liferay.portal.service.permission.UserGroupPermissionUtil;
import com.liferay.portal.service.permission.UserGroupRolePermissionUtil;
import com.liferay.portal.service.permission.UserPermissionUtil;
import com.liferay.portal.service.persistence.UserGroupRolePK;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.portal.util.comparator.GroupNameComparator;
import com.liferay.portal.util.comparator.GroupTypeComparator;
import com.liferay.portal.util.comparator.OrganizationNameComparator;
import com.liferay.portal.util.comparator.OrganizationTypeComparator;
import com.liferay.portal.util.comparator.RoleDescriptionComparator;
import com.liferay.portal.util.comparator.RoleNameComparator;
import com.liferay.portal.util.comparator.RoleTypeComparator;
import com.liferay.portal.util.comparator.UserEmailAddressComparator;
import com.liferay.portal.util.comparator.UserFirstNameComparator;
import com.liferay.portal.util.comparator.UserGroupDescriptionComparator;
import com.liferay.portal.util.comparator.UserGroupNameComparator;
import com.liferay.portal.util.comparator.UserJobTitleComparator;
import com.liferay.portal.util.comparator.UserLastNameComparator;
import com.liferay.portal.util.comparator.UserScreenNameComparator;
import com.liferay.portlet.usersadmin.util.UsersAdmin;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.portlet.ActionRequest;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.servlet.http.HttpServletRequest;

@DoPrivileged
public class UsersAdminImpl
implements UsersAdmin {
    public void addPortletBreadcrumbEntries(Organization organization, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("struts_action", "/users_admin/view");
        List ancestorOrganizations = organization.getAncestors();
        Collections.reverse(ancestorOrganizations);
        for (Organization ancestorOrganization : ancestorOrganizations) {
            portletURL.setParameter("organizationId", String.valueOf(ancestorOrganization.getOrganizationId()));
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorOrganization.getName(), (String)portletURL.toString());
        }
        Organization unescapedOrganization = organization.toUnescapedModel();
        portletURL.setParameter("organizationId", String.valueOf(unescapedOrganization.getOrganizationId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedOrganization.getName(), (String)portletURL.toString());
    }

    public long[] addRequiredRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        User user = UserLocalServiceUtil.getUser((long)userId);
        return this.addRequiredRoles(user, roleIds);
    }

    public long[] addRequiredRoles(User user, long[] roleIds) throws PortalException, SystemException {
        Role userRole;
        if (user.isDefaultUser()) {
            return this.removeRequiredRoles(user, roleIds);
        }
        Role administratorRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"Administrator");
        long[] administratorUserIds = UserLocalServiceUtil.getRoleUserIds((long)administratorRole.getRoleId());
        if (ArrayUtil.contains((long[])administratorUserIds, (long)user.getUserId()) && !ArrayUtil.contains((long[])roleIds, (long)administratorRole.getRoleId()) && administratorUserIds.length == 1) {
            roleIds = ArrayUtil.append((long[])roleIds, (long)administratorRole.getRoleId());
        }
        if (!ArrayUtil.contains((long[])roleIds, (long)(userRole = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User")).getRoleId())) {
            roleIds = ArrayUtil.append((long[])roleIds, (long)userRole.getRoleId());
        }
        return roleIds;
    }

    public List<Role> filterGroupRoles(PermissionChecker permissionChecker, long groupId, List<Role> roles) throws PortalException, SystemException {
        List filteredGroupRoles = ListUtil.copy(roles);
        Iterator itr = filteredGroupRoles.iterator();
        while (itr.hasNext()) {
            Role groupRole = (Role)itr.next();
            String roleName = groupRole.getName();
            if (!roleName.equals("Organization User") && !roleName.equals("Site Member")) continue;
            itr.remove();
        }
        if (permissionChecker.isCompanyAdmin() || permissionChecker.isGroupOwner(groupId)) {
            return filteredGroupRoles;
        }
        Group group = GroupLocalServiceUtil.getGroup((long)groupId);
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (Group)group, (String)"ASSIGN_USER_ROLES") && !OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getOrganizationId(), (String)"ASSIGN_USER_ROLES")) {
            return Collections.emptyList();
        }
        itr = filteredGroupRoles.iterator();
        while (itr.hasNext()) {
            Role groupRole = (Role)itr.next();
            String roleName = groupRole.getName();
            if (!roleName.equals("Organization Administrator") && !roleName.equals("Organization Owner") && !roleName.equals("Site Administrator") && !roleName.equals("Site Owner") && RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (long)groupRole.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredGroupRoles;
    }

    public List<Group> filterGroups(PermissionChecker permissionChecker, List<Group> groups) throws PortalException, SystemException {
        if (permissionChecker.isCompanyAdmin()) {
            return groups;
        }
        List filteredGroups = ListUtil.copy(groups);
        Iterator itr = filteredGroups.iterator();
        while (itr.hasNext()) {
            Group group = (Group)itr.next();
            if (GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredGroups;
    }

    public List<Organization> filterOrganizations(PermissionChecker permissionChecker, List<Organization> organizations) throws PortalException, SystemException {
        if (permissionChecker.isCompanyAdmin()) {
            return organizations;
        }
        List filteredOrganizations = ListUtil.copy(organizations);
        Iterator itr = filteredOrganizations.iterator();
        while (itr.hasNext()) {
            Organization organization = (Organization)itr.next();
            if (OrganizationPermissionUtil.contains((PermissionChecker)permissionChecker, (long)organization.getOrganizationId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredOrganizations;
    }

    public List<Role> filterRoles(PermissionChecker permissionChecker, List<Role> roles) {
        Role role;
        List filteredRoles = ListUtil.copy(roles);
        Iterator itr = filteredRoles.iterator();
        while (itr.hasNext()) {
            role = (Role)itr.next();
            String roleName = role.getName();
            if (!roleName.equals("Guest") && !roleName.equals("Organization User") && !roleName.equals("Owner") && !roleName.equals("Site Member") && !roleName.equals("User")) continue;
            itr.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredRoles;
        }
        itr = filteredRoles.iterator();
        while (itr.hasNext()) {
            role = (Role)itr.next();
            if (RolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)role.getRoleId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredRoles;
    }

    public long[] filterUnsetGroupUserIds(PermissionChecker permissionChecker, long groupId, long[] userIds) throws PortalException, SystemException {
        long[] filteredUserIds = userIds;
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            if (SiteMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)userId, (long)groupId)) {
                filteredUserIds = ArrayUtil.remove((long[])filteredUserIds, (long)userId);
            }
            ++n2;
        }
        return filteredUserIds;
    }

    public long[] filterUnsetOrganizationUserIds(PermissionChecker permissionChecker, long organizationId, long[] userIds) throws PortalException, SystemException {
        long[] filteredUserIds = userIds;
        long[] lArray = userIds;
        int n = userIds.length;
        int n2 = 0;
        while (n2 < n) {
            long userId = lArray[n2];
            if (OrganizationMembershipPolicyUtil.isMembershipProtected((PermissionChecker)permissionChecker, (long)userId, (long)organizationId)) {
                filteredUserIds = ArrayUtil.remove((long[])filteredUserIds, (long)userId);
            }
            ++n2;
        }
        return filteredUserIds;
    }

    public List<UserGroupRole> filterUserGroupRoles(PermissionChecker permissionChecker, List<UserGroupRole> userGroupRoles) throws PortalException, SystemException {
        UserGroupRole userGroupRole;
        List filteredUserGroupRoles = ListUtil.copy(userGroupRoles);
        Iterator itr = filteredUserGroupRoles.iterator();
        while (itr.hasNext()) {
            userGroupRole = (UserGroupRole)itr.next();
            Role role = userGroupRole.getRole();
            String roleName = role.getName();
            if (!roleName.equals("Organization User") && !roleName.equals("Site Member")) continue;
            itr.remove();
        }
        if (permissionChecker.isCompanyAdmin()) {
            return filteredUserGroupRoles;
        }
        itr = filteredUserGroupRoles.iterator();
        while (itr.hasNext()) {
            userGroupRole = (UserGroupRole)itr.next();
            if (UserGroupRolePermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroupRole.getGroupId(), (long)userGroupRole.getRoleId())) continue;
            itr.remove();
        }
        return filteredUserGroupRoles;
    }

    public List<UserGroup> filterUserGroups(PermissionChecker permissionChecker, List<UserGroup> userGroups) {
        if (permissionChecker.isCompanyAdmin()) {
            return userGroups;
        }
        List filteredUserGroups = ListUtil.copy(userGroups);
        Iterator itr = filteredUserGroups.iterator();
        while (itr.hasNext()) {
            UserGroup userGroup = (UserGroup)itr.next();
            if (UserGroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)userGroup.getUserGroupId(), (String)"ASSIGN_MEMBERS")) continue;
            itr.remove();
        }
        return filteredUserGroups;
    }

    public List<Address> getAddresses(ActionRequest actionRequest) {
        return this.getAddresses(actionRequest, Collections.<Address>emptyList());
    }

    public List<Address> getAddresses(ActionRequest actionRequest, List<Address> defaultAddresses) {
        String addressesIndexesString = actionRequest.getParameter("addressesIndexes");
        if (addressesIndexesString == null) {
            return defaultAddresses;
        }
        ArrayList<Address> addresses = new ArrayList<Address>();
        int[] addressesIndexes = StringUtil.split((String)addressesIndexesString, (int)0);
        int addressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"addressPrimary");
        int[] nArray = addressesIndexes;
        int n = addressesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int addressesIndex = nArray[n2];
            long addressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressId" + addressesIndex));
            String street1 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet1_" + addressesIndex));
            String street2 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet2_" + addressesIndex));
            String street3 = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressStreet3_" + addressesIndex));
            String city = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressCity" + addressesIndex));
            String zip = ParamUtil.getString((PortletRequest)actionRequest, (String)("addressZip" + addressesIndex));
            long countryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressCountryId" + addressesIndex));
            if (!(Validator.isNull((String)street1) && Validator.isNull((String)street2) && Validator.isNull((String)street3) && Validator.isNull((String)city) && Validator.isNull((String)zip) && countryId == 0L)) {
                long regionId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("addressRegionId" + addressesIndex));
                int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("addressTypeId" + addressesIndex));
                boolean mailing = ParamUtil.getBoolean((PortletRequest)actionRequest, (String)("addressMailing" + addressesIndex));
                boolean primary = false;
                if (addressesIndex == addressPrimary) {
                    primary = true;
                }
                Address address = AddressLocalServiceUtil.createAddress((long)addressId);
                address.setStreet1(street1);
                address.setStreet2(street2);
                address.setStreet3(street3);
                address.setCity(city);
                address.setZip(zip);
                address.setRegionId(regionId);
                address.setCountryId(countryId);
                address.setTypeId(typeId);
                address.setMailing(mailing);
                address.setPrimary(primary);
                addresses.add(address);
            }
            ++n2;
        }
        return addresses;
    }

    public List<EmailAddress> getEmailAddresses(ActionRequest actionRequest) {
        return this.getEmailAddresses(actionRequest, Collections.<EmailAddress>emptyList());
    }

    public List<EmailAddress> getEmailAddresses(ActionRequest actionRequest, List<EmailAddress> defaultEmailAddresses) {
        String emailAddressesIndexesString = actionRequest.getParameter("emailAddressesIndexes");
        if (emailAddressesIndexesString == null) {
            return defaultEmailAddresses;
        }
        ArrayList<EmailAddress> emailAddresses = new ArrayList<EmailAddress>();
        int[] emailAddressesIndexes = StringUtil.split((String)emailAddressesIndexesString, (int)0);
        int emailAddressPrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"emailAddressPrimary");
        int[] nArray = emailAddressesIndexes;
        int n = emailAddressesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int emailAddressesIndex = nArray[n2];
            long emailAddressId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("emailAddressId" + emailAddressesIndex));
            String address = ParamUtil.getString((PortletRequest)actionRequest, (String)("emailAddressAddress" + emailAddressesIndex));
            if (!Validator.isNull((String)address)) {
                int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("emailAddressTypeId" + emailAddressesIndex));
                boolean primary = false;
                if (emailAddressesIndex == emailAddressPrimary) {
                    primary = true;
                }
                EmailAddress emailAddress = EmailAddressLocalServiceUtil.createEmailAddress((long)emailAddressId);
                emailAddress.setAddress(address);
                emailAddress.setTypeId(typeId);
                emailAddress.setPrimary(primary);
                emailAddresses.add(emailAddress);
            }
            ++n2;
        }
        return emailAddresses;
    }

    public long[] getGroupIds(PortletRequest portletRequest) throws PortalException, SystemException {
        long[] groupIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            groupIds = user.getGroupIds();
        }
        return this.getRequestPrimaryKeys(portletRequest, groupIds, "addGroupIds", "deleteGroupIds");
    }

    public OrderByComparator getGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new GroupNameComparator(orderByAsc) : (orderByCol.equals("type") ? new GroupTypeComparator(orderByAsc) : new GroupNameComparator(orderByAsc));
        return orderByComparator;
    }

    public Long[] getOrganizationIds(List<Organization> organizations) {
        if (organizations == null || organizations.isEmpty()) {
            return new Long[0];
        }
        Long[] organizationIds = new Long[organizations.size()];
        int i2 = 0;
        while (i2 < organizations.size()) {
            Organization organization = organizations.get(i2);
            organizationIds[i2] = new Long(organization.getOrganizationId());
            ++i2;
        }
        return organizationIds;
    }

    public long[] getOrganizationIds(PortletRequest portletRequest) throws PortalException, SystemException {
        long[] organizationIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            organizationIds = user.getOrganizationIds();
        }
        return this.getRequestPrimaryKeys(portletRequest, organizationIds, "addOrganizationIds", "deleteOrganizationIds");
    }

    public OrderByComparator getOrganizationOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new OrganizationNameComparator(orderByAsc) : (orderByCol.equals("type") ? new OrganizationTypeComparator(orderByAsc) : new OrganizationNameComparator(orderByAsc));
        return orderByComparator;
    }

    public Tuple getOrganizations(Hits hits) throws PortalException, SystemException {
        ArrayList<Organization> organizations = new ArrayList<Organization>();
        boolean corruptIndex = false;
        List documents = hits.toList();
        for (Document document : documents) {
            long organizationId = GetterUtil.getLong((String)document.get("organizationId"));
            try {
                Organization organization = OrganizationLocalServiceUtil.getOrganization((long)organizationId);
                organizations.add(organization);
            }
            catch (NoSuchOrganizationException noSuchOrganizationException) {
                corruptIndex = true;
                Indexer indexer = IndexerRegistryUtil.getIndexer(Organization.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
            }
        }
        return new Tuple(new Object[]{organizations, corruptIndex});
    }

    public List<OrgLabor> getOrgLabors(ActionRequest actionRequest) {
        int[] orgLaborsIndexes;
        ArrayList<OrgLabor> orgLabors = new ArrayList<OrgLabor>();
        int[] nArray = orgLaborsIndexes = StringUtil.split((String)ParamUtil.getString((PortletRequest)actionRequest, (String)"orgLaborsIndexes"), (int)0);
        int n = orgLaborsIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int orgLaborsIndex = nArray[n2];
            long orgLaborId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("orgLaborId" + orgLaborsIndex));
            int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("orgLaborTypeId" + orgLaborsIndex), (int)-1);
            if (typeId != -1) {
                int sunOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunOpen" + orgLaborsIndex), (int)-1);
                int sunClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("sunClose" + orgLaborsIndex), (int)-1);
                int monOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monOpen" + orgLaborsIndex), (int)-1);
                int monClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("monClose" + orgLaborsIndex), (int)-1);
                int tueOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueOpen" + orgLaborsIndex), (int)-1);
                int tueClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("tueClose" + orgLaborsIndex), (int)-1);
                int wedOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedOpen" + orgLaborsIndex), (int)-1);
                int wedClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("wedClose" + orgLaborsIndex), (int)-1);
                int thuOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuOpen" + orgLaborsIndex), (int)-1);
                int thuClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("thuClose" + orgLaborsIndex), (int)-1);
                int friOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friOpen" + orgLaborsIndex), (int)-1);
                int friClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("friClose" + orgLaborsIndex), (int)-1);
                int satOpen = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satOpen" + orgLaborsIndex), (int)-1);
                int satClose = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("satClose" + orgLaborsIndex), (int)-1);
                OrgLabor orgLabor = OrgLaborLocalServiceUtil.createOrgLabor((long)orgLaborId);
                orgLabor.setTypeId(typeId);
                orgLabor.setSunOpen(sunOpen);
                orgLabor.setSunClose(sunClose);
                orgLabor.setMonOpen(monOpen);
                orgLabor.setMonClose(monClose);
                orgLabor.setTueOpen(tueOpen);
                orgLabor.setTueClose(tueClose);
                orgLabor.setWedOpen(wedOpen);
                orgLabor.setWedClose(wedClose);
                orgLabor.setThuOpen(thuOpen);
                orgLabor.setThuClose(thuClose);
                orgLabor.setFriOpen(friOpen);
                orgLabor.setFriClose(friClose);
                orgLabor.setSatOpen(satOpen);
                orgLabor.setSatClose(satClose);
                orgLabors.add(orgLabor);
            }
            ++n2;
        }
        return orgLabors;
    }

    public List<Phone> getPhones(ActionRequest actionRequest) {
        return this.getPhones(actionRequest, Collections.<Phone>emptyList());
    }

    public List<Phone> getPhones(ActionRequest actionRequest, List<Phone> defaultPhones) {
        String phonesIndexesString = actionRequest.getParameter("phonesIndexes");
        if (phonesIndexesString == null) {
            return defaultPhones;
        }
        ArrayList<Phone> phones = new ArrayList<Phone>();
        int[] phonesIndexes = StringUtil.split((String)phonesIndexesString, (int)0);
        int phonePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"phonePrimary");
        int[] nArray = phonesIndexes;
        int n = phonesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int phonesIndex = nArray[n2];
            long phoneId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("phoneId" + phonesIndex));
            String number = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneNumber" + phonesIndex));
            String extension = ParamUtil.getString((PortletRequest)actionRequest, (String)("phoneExtension" + phonesIndex));
            if (!Validator.isNull((String)number) || !Validator.isNull((String)extension)) {
                int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("phoneTypeId" + phonesIndex));
                boolean primary = false;
                if (phonesIndex == phonePrimary) {
                    primary = true;
                }
                Phone phone = PhoneLocalServiceUtil.createPhone((long)phoneId);
                phone.setNumber(number);
                phone.setExtension(extension);
                phone.setTypeId(typeId);
                phone.setPrimary(primary);
                phones.add(phone);
            }
            ++n2;
        }
        return phones;
    }

    public long[] getRoleIds(PortletRequest portletRequest) throws PortalException, SystemException {
        long[] roleIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            roleIds = user.getRoleIds();
        }
        return this.getRequestPrimaryKeys(portletRequest, roleIds, "addRoleIds", "deleteRoleIds");
    }

    public OrderByComparator getRoleOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new RoleNameComparator(orderByAsc) : (orderByCol.equals("description") ? new RoleDescriptionComparator(orderByAsc) : (orderByCol.equals("type") ? new RoleTypeComparator(orderByAsc) : new RoleNameComparator(orderByAsc)));
        return orderByComparator;
    }

    public long[] getUserGroupIds(PortletRequest portletRequest) throws PortalException, SystemException {
        long[] userGroupIds = new long[]{};
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user != null) {
            userGroupIds = user.getUserGroupIds();
        }
        return this.getRequestPrimaryKeys(portletRequest, userGroupIds, "addUserGroupIds", "deleteUserGroupIds");
    }

    public OrderByComparator getUserGroupOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("name") ? new UserGroupNameComparator(orderByAsc) : (orderByCol.equals("description") ? new UserGroupDescriptionComparator(orderByAsc) : new UserGroupNameComparator(orderByAsc));
        return orderByComparator;
    }

    public List<UserGroupRole> getUserGroupRoles(PortletRequest portletRequest) throws PortalException, SystemException {
        User user = PortalUtil.getSelectedUser((PortletRequest)portletRequest);
        if (user == null) {
            return Collections.emptyList();
        }
        HashSet<UserGroupRole> userGroupRoles = new HashSet<UserGroupRole>(UserGroupRoleLocalServiceUtil.getUserGroupRoles((long)user.getUserId()));
        userGroupRoles.addAll(this.getUserGroupRoles(portletRequest, user, "addGroupRolesGroupIds", "addGroupRolesRoleIds"));
        userGroupRoles.removeAll(this.getUserGroupRoles(portletRequest, user, "deleteGroupRolesGroupIds", "deleteGroupRolesRoleIds"));
        return new ArrayList<UserGroupRole>(userGroupRoles);
    }

    public Tuple getUserGroups(Hits hits) throws PortalException, SystemException {
        ArrayList<UserGroup> userGroups = new ArrayList<UserGroup>();
        boolean corruptIndex = false;
        List documents = hits.toList();
        for (Document document : documents) {
            long userGroupId = GetterUtil.getLong((String)document.get("userGroupId"));
            try {
                UserGroup userGroup = UserGroupLocalServiceUtil.getUserGroup((long)userGroupId);
                userGroups.add(userGroup);
            }
            catch (NoSuchUserGroupException noSuchUserGroupException) {
                corruptIndex = true;
                Indexer indexer = IndexerRegistryUtil.getIndexer(UserGroup.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
            }
        }
        return new Tuple(new Object[]{userGroups, corruptIndex});
    }

    public OrderByComparator getUserOrderByComparator(String orderByCol, String orderByType) {
        boolean orderByAsc = false;
        if (orderByType.equals("asc")) {
            orderByAsc = true;
        }
        Object orderByComparator = null;
        orderByComparator = orderByCol.equals("email-address") ? new UserEmailAddressComparator(orderByAsc) : (orderByCol.equals("first-name") ? new UserFirstNameComparator(orderByAsc) : (orderByCol.equals("job-title") ? new UserJobTitleComparator(orderByAsc) : (orderByCol.equals("last-name") ? new UserLastNameComparator(orderByAsc) : (orderByCol.equals("screen-name") ? new UserScreenNameComparator(orderByAsc) : new UserLastNameComparator(orderByAsc)))));
        return orderByComparator;
    }

    public Tuple getUsers(Hits hits) throws PortalException, SystemException {
        ArrayList<User> users = new ArrayList<User>();
        boolean corruptIndex = false;
        List documents = hits.toList();
        for (Document document : documents) {
            long userId = GetterUtil.getLong((String)document.get("userId"));
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            if (user != null) {
                users.add(user);
                continue;
            }
            corruptIndex = true;
            Indexer indexer = IndexerRegistryUtil.getIndexer(User.class);
            long companyId = GetterUtil.getLong((String)document.get("companyId"));
            indexer.delete(companyId, document.getUID());
        }
        return new Tuple(new Object[]{users, corruptIndex});
    }

    public List<Website> getWebsites(ActionRequest actionRequest) {
        return this.getWebsites(actionRequest, Collections.<Website>emptyList());
    }

    public List<Website> getWebsites(ActionRequest actionRequest, List<Website> defaultWebsites) {
        String websitesIndexesString = actionRequest.getParameter("websitesIndexes");
        if (websitesIndexesString == null) {
            return defaultWebsites;
        }
        ArrayList<Website> websites = new ArrayList<Website>();
        int[] websitesIndexes = StringUtil.split((String)websitesIndexesString, (int)0);
        int websitePrimary = ParamUtil.getInteger((PortletRequest)actionRequest, (String)"websitePrimary");
        int[] nArray = websitesIndexes;
        int n = websitesIndexes.length;
        int n2 = 0;
        while (n2 < n) {
            int websitesIndex = nArray[n2];
            long websiteId = ParamUtil.getLong((PortletRequest)actionRequest, (String)("websiteId" + websitesIndex));
            String url = ParamUtil.getString((PortletRequest)actionRequest, (String)("websiteUrl" + websitesIndex));
            if (!Validator.isNull((String)url)) {
                int typeId = ParamUtil.getInteger((PortletRequest)actionRequest, (String)("websiteTypeId" + websitesIndex));
                boolean primary = false;
                if (websitesIndex == websitePrimary) {
                    primary = true;
                }
                Website website = WebsiteLocalServiceUtil.createWebsite((long)websiteId);
                website.setUrl(url);
                website.setTypeId(typeId);
                website.setPrimary(primary);
                websites.add(website);
            }
            ++n2;
        }
        return websites;
    }

    public boolean hasUpdateEmailAddress(PermissionChecker permissionChecker, User user) throws PortalException, SystemException {
        return this.hasUpdateFieldPermission(permissionChecker, null, user, "emailAddress");
    }

    public boolean hasUpdateFieldPermission(PermissionChecker permissionChecker, User updatingUser, User updatedUser, String field) throws PortalException, SystemException {
        String[] fieldEditableDomainNames;
        long updatingUserId;
        if (updatedUser == null) {
            return true;
        }
        if (updatingUser == null && (updatingUserId = PrincipalThreadLocal.getUserId()) > 0L) {
            updatingUser = UserLocalServiceUtil.fetchUserById((long)updatingUserId);
        }
        if (updatingUser != null && !updatingUser.equals(updatedUser) && UserPermissionUtil.contains((PermissionChecker)permissionChecker, (long)updatingUser.getUserId(), (String)"UPDATE_USER")) {
            return true;
        }
        String[] stringArray = PropsValues.FIELD_EDITABLE_USER_TYPES;
        int n = PropsValues.FIELD_EDITABLE_USER_TYPES.length;
        int n2 = 0;
        while (n2 < n) {
            String userType = stringArray[n2];
            if (userType.equals("user-with-mx") && updatedUser.hasCompanyMx()) {
                return true;
            }
            if (userType.equals("user-without-mx") && !updatedUser.hasCompanyMx()) {
                return true;
            }
            ++n2;
        }
        stringArray = PropsValues.FIELD_EDITABLE_ROLES;
        n = PropsValues.FIELD_EDITABLE_ROLES.length;
        n2 = 0;
        while (n2 < n) {
            String roleName = stringArray[n2];
            Role role = RoleLocalServiceUtil.fetchRole((long)updatedUser.getCompanyId(), (String)roleName);
            if (role != null && RoleLocalServiceUtil.hasUserRole((long)updatedUser.getUserId(), (long)role.getRoleId())) {
                return true;
            }
            ++n2;
        }
        String emailAddress = updatedUser.getEmailAddress();
        String[] stringArray2 = PropsValues.FIELD_EDITABLE_DOMAINS;
        int n3 = PropsValues.FIELD_EDITABLE_DOMAINS.length;
        n = 0;
        while (n < n3) {
            String domainName = stringArray2[n];
            if (emailAddress.endsWith(domainName)) {
                return true;
            }
            ++n;
        }
        String[] stringArray3 = fieldEditableDomainNames = PropsUtil.getArray("field.editable.domains", new Filter(field));
        int n4 = fieldEditableDomainNames.length;
        n3 = 0;
        while (n3 < n4) {
            String domainName = stringArray3[n3];
            if (domainName.equals("*") || emailAddress.endsWith(domainName)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasUpdateFieldPermission(User user, String field) throws PortalException, SystemException {
        PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
        return this.hasUpdateFieldPermission(permissionChecker, null, user, field);
    }

    @Deprecated
    public boolean hasUpdateScreenName(PermissionChecker permissionChecker, User user) throws PortalException, SystemException {
        return this.hasUpdateFieldPermission(permissionChecker, null, user, "screenName");
    }

    public long[] removeRequiredRoles(long userId, long[] roleIds) throws PortalException, SystemException {
        User user = UserLocalServiceUtil.getUser((long)userId);
        return this.removeRequiredRoles(user, roleIds);
    }

    public long[] removeRequiredRoles(User user, long[] roleIds) throws PortalException, SystemException {
        Role role = RoleLocalServiceUtil.getRole((long)user.getCompanyId(), (String)"User");
        roleIds = ArrayUtil.remove((long[])roleIds, (long)role.getRoleId());
        return roleIds;
    }

    public void updateAddresses(String className, long classPK, List<Address> addresses) throws PortalException, SystemException {
        HashSet<Long> addressIds = new HashSet<Long>();
        for (Address address : addresses) {
            long addressId = address.getAddressId();
            String street1 = address.getStreet1();
            String street2 = address.getStreet2();
            String street3 = address.getStreet3();
            String city = address.getCity();
            String zip = address.getZip();
            long regionId = address.getRegionId();
            long countryId = address.getCountryId();
            int typeId = address.getTypeId();
            boolean mailing = address.isMailing();
            boolean primary = address.isPrimary();
            if (addressId <= 0L) {
                address = AddressServiceUtil.addAddress((String)className, (long)classPK, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (int)typeId, (boolean)mailing, (boolean)primary, (ServiceContext)new ServiceContext());
                addressId = address.getAddressId();
            } else {
                AddressServiceUtil.updateAddress((long)addressId, (String)street1, (String)street2, (String)street3, (String)city, (String)zip, (long)regionId, (long)countryId, (int)typeId, (boolean)mailing, (boolean)primary);
            }
            addressIds.add(addressId);
        }
        addresses = AddressServiceUtil.getAddresses((String)className, (long)classPK);
        for (Address address : addresses) {
            if (addressIds.contains(address.getAddressId())) continue;
            AddressServiceUtil.deleteAddress((long)address.getAddressId());
        }
    }

    public void updateEmailAddresses(String className, long classPK, List<EmailAddress> emailAddresses) throws PortalException, SystemException {
        HashSet<Long> emailAddressIds = new HashSet<Long>();
        for (EmailAddress emailAddress : emailAddresses) {
            long emailAddressId = emailAddress.getEmailAddressId();
            String address = emailAddress.getAddress();
            int typeId = emailAddress.getTypeId();
            boolean primary = emailAddress.isPrimary();
            if (emailAddressId <= 0L) {
                emailAddress = EmailAddressServiceUtil.addEmailAddress((String)className, (long)classPK, (String)address, (int)typeId, (boolean)primary, (ServiceContext)new ServiceContext());
                emailAddressId = emailAddress.getEmailAddressId();
            } else {
                EmailAddressServiceUtil.updateEmailAddress((long)emailAddressId, (String)address, (int)typeId, (boolean)primary);
            }
            emailAddressIds.add(emailAddressId);
        }
        emailAddresses = EmailAddressServiceUtil.getEmailAddresses((String)className, (long)classPK);
        for (EmailAddress emailAddress : emailAddresses) {
            if (emailAddressIds.contains(emailAddress.getEmailAddressId())) continue;
            EmailAddressServiceUtil.deleteEmailAddress((long)emailAddress.getEmailAddressId());
        }
    }

    public void updateOrgLabors(long classPK, List<OrgLabor> orgLabors) throws PortalException, SystemException {
        HashSet<Long> orgLaborsIds = new HashSet<Long>();
        for (OrgLabor orgLabor : orgLabors) {
            long orgLaborId = orgLabor.getOrgLaborId();
            int typeId = orgLabor.getTypeId();
            int sunOpen = orgLabor.getSunOpen();
            int sunClose = orgLabor.getSunClose();
            int monOpen = orgLabor.getMonOpen();
            int monClose = orgLabor.getMonClose();
            int tueOpen = orgLabor.getTueOpen();
            int tueClose = orgLabor.getTueClose();
            int wedOpen = orgLabor.getWedOpen();
            int wedClose = orgLabor.getWedClose();
            int thuOpen = orgLabor.getThuOpen();
            int thuClose = orgLabor.getThuClose();
            int friOpen = orgLabor.getFriOpen();
            int friClose = orgLabor.getFriClose();
            int satOpen = orgLabor.getSatOpen();
            int satClose = orgLabor.getSatClose();
            if (orgLaborId <= 0L) {
                orgLabor = OrgLaborServiceUtil.addOrgLabor((long)classPK, (int)typeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
                orgLaborId = orgLabor.getOrgLaborId();
            } else {
                OrgLaborServiceUtil.updateOrgLabor((long)orgLaborId, (int)typeId, (int)sunOpen, (int)sunClose, (int)monOpen, (int)monClose, (int)tueOpen, (int)tueClose, (int)wedOpen, (int)wedClose, (int)thuOpen, (int)thuClose, (int)friOpen, (int)friClose, (int)satOpen, (int)satClose);
            }
            orgLaborsIds.add(orgLaborId);
        }
        orgLabors = OrgLaborServiceUtil.getOrgLabors((long)classPK);
        for (OrgLabor orgLabor : orgLabors) {
            if (orgLaborsIds.contains(orgLabor.getOrgLaborId())) continue;
            OrgLaborServiceUtil.deleteOrgLabor((long)orgLabor.getOrgLaborId());
        }
    }

    public void updatePhones(String className, long classPK, List<Phone> phones) throws PortalException, SystemException {
        HashSet<Long> phoneIds = new HashSet<Long>();
        for (Phone phone : phones) {
            long phoneId = phone.getPhoneId();
            String number = phone.getNumber();
            String extension = phone.getExtension();
            int typeId = phone.getTypeId();
            boolean primary = phone.isPrimary();
            if (phoneId <= 0L) {
                phone = PhoneServiceUtil.addPhone((String)className, (long)classPK, (String)number, (String)extension, (int)typeId, (boolean)primary, (ServiceContext)new ServiceContext());
                phoneId = phone.getPhoneId();
            } else {
                PhoneServiceUtil.updatePhone((long)phoneId, (String)number, (String)extension, (int)typeId, (boolean)primary);
            }
            phoneIds.add(phoneId);
        }
        phones = PhoneServiceUtil.getPhones((String)className, (long)classPK);
        for (Phone phone : phones) {
            if (phoneIds.contains(phone.getPhoneId())) continue;
            PhoneServiceUtil.deletePhone((long)phone.getPhoneId());
        }
    }

    public void updateWebsites(String className, long classPK, List<Website> websites) throws PortalException, SystemException {
        HashSet<Long> websiteIds = new HashSet<Long>();
        for (Website website : websites) {
            long websiteId = website.getWebsiteId();
            String url = website.getUrl();
            int typeId = website.getTypeId();
            boolean primary = website.isPrimary();
            if (websiteId <= 0L) {
                website = WebsiteServiceUtil.addWebsite((String)className, (long)classPK, (String)url, (int)typeId, (boolean)primary, (ServiceContext)new ServiceContext());
                websiteId = website.getWebsiteId();
            } else {
                WebsiteServiceUtil.updateWebsite((long)websiteId, (String)url, (int)typeId, (boolean)primary);
            }
            websiteIds.add(websiteId);
        }
        websites = WebsiteServiceUtil.getWebsites((String)className, (long)classPK);
        for (Website website : websites) {
            if (websiteIds.contains(website.getWebsiteId())) continue;
            WebsiteServiceUtil.deleteWebsite((long)website.getWebsiteId());
        }
    }

    protected long[] getRequestPrimaryKeys(PortletRequest portletRequest, long[] currentPKs, String addParam, String deleteParam) {
        Set primaryKeys = SetUtil.fromArray((long[])currentPKs);
        long[] addPrimaryKeys = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)addParam), (long)0L);
        long[] deletePrimaryKeys = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)deleteParam), (long)0L);
        long[] lArray = addPrimaryKeys;
        int n = addPrimaryKeys.length;
        int n2 = 0;
        while (n2 < n) {
            long addPrimaryKey = lArray[n2];
            primaryKeys.add(addPrimaryKey);
            ++n2;
        }
        lArray = deletePrimaryKeys;
        n = deletePrimaryKeys.length;
        n2 = 0;
        while (n2 < n) {
            long deletePrimaryKey = lArray[n2];
            primaryKeys.remove(deletePrimaryKey);
            ++n2;
        }
        return ArrayUtil.toLongArray((Collection)primaryKeys);
    }

    protected List<UserGroupRole> getUserGroupRoles(PortletRequest portletRequest, User user, String groupIdsParam, String roleIdsParam) {
        long[] groupRolesRoleIds;
        UniqueList userGroupRoles = new UniqueList();
        long[] groupRolesGroupIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)groupIdsParam), (long)0L);
        if (groupRolesGroupIds.length != (groupRolesRoleIds = StringUtil.split((String)ParamUtil.getString((PortletRequest)portletRequest, (String)roleIdsParam), (long)0L)).length) {
            return userGroupRoles;
        }
        long userId = 0L;
        if (user != null) {
            userId = user.getUserId();
        }
        int i2 = 0;
        while (i2 < groupRolesGroupIds.length) {
            if (groupRolesGroupIds[i2] != 0L && groupRolesRoleIds[i2] != 0L) {
                UserGroupRolePK userGroupRolePK = new UserGroupRolePK(userId, groupRolesGroupIds[i2], groupRolesRoleIds[i2]);
                UserGroupRole userGroupRole = UserGroupRoleLocalServiceUtil.createUserGroupRole((UserGroupRolePK)userGroupRolePK);
                userGroupRoles.add(userGroupRole);
            }
            ++i2;
        }
        return userGroupRoles;
    }
}

