/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.search;

import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringPool;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HitsImpl
implements Hits {
    private String _collatedSpellCheckResult;
    private Document[] _docs;
    private int _length;
    private Query _query;
    private String[] _querySuggestions;
    private String[] _queryTerms;
    private float[] _scores = new float[0];
    private float _searchTime;
    private String[] _snippets = new String[0];
    private Map<String, List<String>> _spellCheckResults;
    private long _start;

    @Override
    public void copy(Hits hits) {
        this.setDocs(hits.getDocs());
        this.setLength(hits.getLength());
        this.setQuery(hits.getQuery());
        this.setQuerySuggestions(hits.getQuerySuggestions());
        this.setQueryTerms(hits.getQueryTerms());
        this.setScores(hits.getScores());
        this.setSearchTime(hits.getSearchTime());
        this.setSnippets(hits.getSnippets());
        this.setSpellCheckResults(hits.getSpellCheckResults());
        this.setStart(hits.getStart());
    }

    @Override
    public Document doc(int n) {
        return this._docs[n];
    }

    @Override
    @JSON
    public String getCollatedSpellCheckResult() {
        return this._collatedSpellCheckResult;
    }

    @Override
    @JSON
    public Document[] getDocs() {
        return this._docs;
    }

    @Override
    public int getLength() {
        return this._length;
    }

    @Override
    @JSON(include=false)
    public Query getQuery() {
        return this._query;
    }

    @Override
    @JSON
    public String[] getQuerySuggestions() {
        if (ArrayUtil.isEmpty(this._querySuggestions)) {
            return StringPool.EMPTY_ARRAY;
        }
        return this._querySuggestions;
    }

    @Override
    @JSON
    public String[] getQueryTerms() {
        return this._queryTerms;
    }

    @Override
    @JSON
    public float[] getScores() {
        return this._scores;
    }

    @Override
    public float getSearchTime() {
        return this._searchTime;
    }

    @Override
    @JSON
    public String[] getSnippets() {
        return this._snippets;
    }

    @Override
    public Map<String, List<String>> getSpellCheckResults() {
        return this._spellCheckResults;
    }

    @Override
    public long getStart() {
        return this._start;
    }

    @Override
    public float score(int n) {
        return this._scores[n];
    }

    @Override
    public void setCollatedSpellCheckResult(String collatedSpellCheckResult) {
        this._collatedSpellCheckResult = collatedSpellCheckResult;
    }

    @Override
    public void setDocs(Document[] docs) {
        this._docs = docs;
    }

    @Override
    public void setLength(int length) {
        this._length = length;
    }

    @Override
    public void setQuery(Query query) {
        this._query = query;
    }

    @Override
    public void setQuerySuggestions(String[] querySuggestions) {
        this._querySuggestions = querySuggestions;
    }

    @Override
    public void setQueryTerms(String[] queryTerms) {
        this._queryTerms = queryTerms;
    }

    @Override
    public void setScores(float[] scores) {
        this._scores = scores;
    }

    @Override
    public void setScores(Float[] scores) {
        float[] primScores = new float[scores.length];
        int i = 0;
        while (i < scores.length) {
            primScores[i] = scores[i].floatValue();
            ++i;
        }
        this.setScores(primScores);
    }

    @Override
    public void setSearchTime(float time) {
        this._searchTime = time;
    }

    @Override
    public void setSnippets(String[] snippets) {
        this._snippets = snippets;
    }

    @Override
    public void setSpellCheckResults(Map<String, List<String>> spellCheckResults) {
        this._spellCheckResults = spellCheckResults;
    }

    @Override
    public void setStart(long start) {
        this._start = start;
    }

    @Override
    public String snippet(int n) {
        return this._snippets[n];
    }

    @Override
    public List<Document> toList() {
        ArrayList<Document> subset = new ArrayList<Document>(this._docs.length);
        Document[] documentArray = this._docs;
        int n = this._docs.length;
        int n2 = 0;
        while (n2 < n) {
            Document _doc = documentArray[n2];
            subset.add(_doc);
            ++n2;
        }
        return subset;
    }
}

