/*
 * Decompiled with CFR 0.152.
 */
package org.portletbridge.portlet;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.portlet.PortletPreferences;
import javax.portlet.RenderRequest;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.portletbridge.PortletBridgeException;
import org.portletbridge.ResourceException;
import org.portletbridge.portlet.BridgeAuthenticator;
import org.portletbridge.portlet.PerPortletMemento;
import org.portletbridge.portlet.PortletBridgeContent;
import org.portletbridge.portlet.SerializeableHttpState;

public class DefaultPerPortletMemento
implements PerPortletMemento,
Serializable {
    private static final long serialVersionUID = 7117499680906225653L;
    private URI initUrl;
    private SerializeableHttpState state = new SerializeableHttpState();
    private String proxyHost;
    private int proxyPort;
    private Pattern scope = Pattern.compile(".*");
    private Map bridgeContent = new HashMap();
    private final BridgeAuthenticator bridgeAuthenticator;

    public DefaultPerPortletMemento(BridgeAuthenticator bridgeAuthenticator) {
        this.bridgeAuthenticator = bridgeAuthenticator;
    }

    public SerializeableHttpState getHttpState() {
        return this.state;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPreferences(RenderRequest request) throws ResourceException {
        PortletPreferences preferences = request.getPreferences();
        String initUrlPreference = preferences.getValue("initUrl", null);
        if (initUrlPreference == null || initUrlPreference.trim().length() == 0) {
            throw new ResourceException("error.initurl", (Object)"preference not defined");
        }
        try {
            this.initUrl = new URI(initUrlPreference);
        }
        catch (URISyntaxException e) {
            throw new ResourceException("error.initurl", (Object)e.getMessage(), (Throwable)e);
        }
        String configProxyAuthentication = preferences.getValue("proxyAuthentication", "none");
        String configProxyAuthenticationUsername = preferences.getValue("proxyAuthenticationUsername", null);
        String configProxyAuthenticationPassword = preferences.getValue("proxyAuthenticationPassword", null);
        String configProxyAuthenticationHost = preferences.getValue("proxyAuthenticationHost", null);
        String configProxyAuthenticationDomain = preferences.getValue("proxyAuthenticationDomain", null);
        if (configProxyAuthentication == null || configProxyAuthentication.trim().length() <= 0) throw new PortletBridgeException("error.configProxyEnabled");
        if ("ntlm".equalsIgnoreCase(configProxyAuthentication)) {
            this.state.setProxyCredentials(AuthScope.ANY, (Credentials)new NTCredentials(configProxyAuthenticationUsername, configProxyAuthenticationPassword, configProxyAuthenticationHost, configProxyAuthenticationDomain));
        } else if ("basic".equalsIgnoreCase(configProxyAuthentication)) {
            this.state.setProxyCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(configProxyAuthenticationUsername, configProxyAuthenticationPassword));
        } else {
            if (!"none".equalsIgnoreCase(configProxyAuthentication)) throw new PortletBridgeException("error.configProxyAuthentication");
            this.state.clearProxyCredentials();
        }
        if (this.bridgeAuthenticator != null) {
            Credentials credentials = this.bridgeAuthenticator.getCredentials(request);
            if (credentials != null) {
                this.state.setCredentials(AuthScope.ANY, credentials);
            } else {
                this.state.clearCredentials();
            }
        }
        this.proxyHost = preferences.getValue("proxyHost", System.getProperty("http.proxyHost"));
        String proxyPortPreference = preferences.getValue("proxyPort", System.getProperty("http.proxyPort"));
        if (proxyPortPreference != null) {
            String trimmed = proxyPortPreference.trim();
            if (trimmed.length() > 0) {
                try {
                    this.proxyPort = Integer.parseInt(proxyPortPreference);
                }
                catch (NumberFormatException e) {
                    this.proxyPort = 80;
                }
            } else {
                this.proxyPort = 80;
            }
        } else {
            this.proxyPort = 80;
        }
        String scopePreference = preferences.getValue("scope", null);
        if (scopePreference == null || this.scope.pattern().equals(scopePreference)) return;
        this.scope = Pattern.compile(scopePreference);
    }

    public Pattern getScope() {
        return this.scope;
    }

    public URI getInitUrl() {
        return this.initUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueContent(String bridgeRequestId, PortletBridgeContent content) {
        Map map = this.bridgeContent;
        synchronized (map) {
            this.bridgeContent.clear();
            this.bridgeContent.put(bridgeRequestId, content);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PortletBridgeContent dequeueContent(String bridgeRequestId) {
        Map map = this.bridgeContent;
        synchronized (map) {
            PortletBridgeContent portletBridgeContent = (PortletBridgeContent)this.bridgeContent.get(bridgeRequestId);
            this.bridgeContent.clear();
            return portletBridgeContent;
        }
    }
}

