/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.transform;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.transform.FastFourierTransformer;
import org.apache.commons.math.transform.RealTransformer;

public class FastSineTransformer
implements RealTransformer {
    public double[] transform(double[] f) throws IllegalArgumentException {
        return this.fst(f);
    }

    public double[] transform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        return this.fst(data);
    }

    public double[] transform2(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = Math.sqrt(2.0 / (double)f.length);
        return FastFourierTransformer.scaleArray(this.fst(f), scaling_coefficient);
    }

    public double[] transform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        double scaling_coefficient = Math.sqrt(2.0 / (double)n);
        return FastFourierTransformer.scaleArray(this.fst(data), scaling_coefficient);
    }

    public double[] inversetransform(double[] f) throws IllegalArgumentException {
        double scaling_coefficient = 2.0 / (double)f.length;
        return FastFourierTransformer.scaleArray(this.fst(f), scaling_coefficient);
    }

    public double[] inversetransform(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        double[] data = FastFourierTransformer.sample(f, min, max, n);
        data[0] = 0.0;
        double scaling_coefficient = 2.0 / (double)n;
        return FastFourierTransformer.scaleArray(this.fst(data), scaling_coefficient);
    }

    public double[] inversetransform2(double[] f) throws IllegalArgumentException {
        return this.transform2(f);
    }

    public double[] inversetransform2(UnivariateRealFunction f, double min, double max, int n) throws FunctionEvaluationException, IllegalArgumentException {
        return this.transform2(f, min, max, n);
    }

    protected double[] fst(double[] f) throws IllegalArgumentException {
        double[] F = new double[f.length];
        FastFourierTransformer.verifyDataSet(f);
        if (f[0] != 0.0) {
            throw MathRuntimeException.createIllegalArgumentException("first element is not 0: {0}", f[0]);
        }
        int N = f.length;
        if (N == 1) {
            F[0] = 0.0;
            return F;
        }
        double[] x = new double[N];
        x[0] = 0.0;
        x[N >> 1] = 2.0 * f[N >> 1];
        for (int i = 1; i < N >> 1; ++i) {
            double A = Math.sin((double)i * Math.PI / (double)N) * (f[i] + f[N - i]);
            double B = 0.5 * (f[i] - f[N - i]);
            x[i] = A + B;
            x[N - i] = A - B;
        }
        FastFourierTransformer transformer = new FastFourierTransformer();
        Complex[] y = transformer.transform(x);
        F[0] = 0.0;
        F[1] = 0.5 * y[0].getReal();
        for (int i = 1; i < N >> 1; ++i) {
            F[2 * i] = -y[i].getImaginary();
            F[2 * i + 1] = y[i].getReal() + F[2 * i - 1];
        }
        return F;
    }
}

