/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBigDecimal;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.java.proxies.ArrayJavaProxy;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.java.proxies.RubyObjectHolderProxy;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;
import org.jruby.util.TypeConverter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaUtil {
    private static final Pattern RUBY_CASE_SPLITTER = Pattern.compile("([a-z][0-9]*)_([a-z])");
    private static final JavaConverter JAVA_DEFAULT_CONVERTER = new JavaConverter(Object.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            IRubyObject result2 = JavaUtil.trySimpleConversions(runtime2, object);
            if (result2 != null) {
                return result2;
            }
            return JavaObject.wrap(runtime2, object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Object[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_BOOLEAN_CONVERTER = new JavaConverter(Boolean.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyBoolean.newBoolean(runtime2, (Boolean)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Boolean[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_FLOAT_CONVERTER = new JavaConverter(Float.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFloat.newFloat(runtime2, ((Float)object).doubleValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Float[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_DOUBLE_CONVERTER = new JavaConverter(Double.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFloat.newFloat(runtime2, (Double)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Double[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_CHAR_CONVERTER = new JavaConverter(Character.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Character)object).charValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Character[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_BYTE_CONVERTER = new JavaConverter(Byte.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Byte)object).byteValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Byte[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_SHORT_CONVERTER = new JavaConverter(Short.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Short)object).shortValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Short[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_INT_CONVERTER = new JavaConverter(Integer.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Integer)object).intValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Integer[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_LONG_CONVERTER = new JavaConverter(Long.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, (Long)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((Long[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_BOOLEANPRIM_CONVERTER = new JavaConverter(Boolean.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyBoolean.newBoolean(runtime2, (Boolean)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyBoolean.newBoolean(runtime2, ((boolean[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_FLOATPRIM_CONVERTER = new JavaConverter(Float.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFloat.newFloat(runtime2, ((Float)object).doubleValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFloat.newFloat(runtime2, ((float[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_DOUBLEPRIM_CONVERTER = new JavaConverter(Double.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFloat.newFloat(runtime2, (Double)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFloat.newFloat(runtime2, ((double[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_CHARPRIM_CONVERTER = new JavaConverter(Character.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Character)object).charValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFixnum.newFixnum(runtime2, ((char[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_BYTEPRIM_CONVERTER = new JavaConverter(Byte.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Byte)object).byteValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFixnum.newFixnum(runtime2, ((byte[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_SHORTPRIM_CONVERTER = new JavaConverter(Short.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Short)object).shortValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFixnum.newFixnum(runtime2, ((short[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_INTPRIM_CONVERTER = new JavaConverter(Integer.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, ((Integer)object).intValue());
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFixnum.newFixnum(runtime2, ((int[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_LONGPRIM_CONVERTER = new JavaConverter(Long.TYPE){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyFixnum.newFixnum(runtime2, (Long)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return RubyFixnum.newFixnum(runtime2, ((long[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_STRING_CONVERTER = new JavaConverter(String.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyString.newUnicodeString(runtime2, (String)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((String[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_CHARSEQUENCE_CONVERTER = new JavaConverter(String.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyString.newUnicodeString(runtime2, (CharSequence)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((CharSequence[])array)[i2]);
        }
    };
    private static final JavaConverter BYTELIST_CONVERTER = new JavaConverter(ByteList.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyString.newString(runtime2, (ByteList)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((ByteList[])array)[i2]);
        }
    };
    private static final JavaConverter JAVA_BIGINTEGER_CONVERTER = new JavaConverter(BigInteger.class){

        public IRubyObject convert(Ruby runtime2, Object object) {
            if (object == null) {
                return runtime2.getNil();
            }
            return RubyBignum.newBignum(runtime2, (BigInteger)object);
        }

        public IRubyObject get(Ruby runtime2, Object array, int i2) {
            return this.convert(runtime2, ((BigInteger[])array)[i2]);
        }
    };
    private static final Map<Class, JavaConverter> JAVA_CONVERTERS = new HashMap<Class, JavaConverter>();
    private static final NumericConverter NUMERIC_TO_BYTE;
    private static final NumericConverter NUMERIC_TO_SHORT;
    private static final NumericConverter NUMERIC_TO_CHARACTER;
    private static final NumericConverter NUMERIC_TO_INTEGER;
    private static final NumericConverter NUMERIC_TO_LONG;
    private static final NumericConverter NUMERIC_TO_FLOAT;
    private static final NumericConverter NUMERIC_TO_DOUBLE;
    private static final NumericConverter NUMERIC_TO_BIGINTEGER;
    private static final NumericConverter NUMERIC_TO_OBJECT;
    private static final NumericConverter NUMERIC_TO_OTHER;
    private static final NumericConverter NUMERIC_TO_VOID;
    private static final Map<Class, NumericConverter> NUMERIC_CONVERTERS;
    @Deprecated
    public static final RubyConverter RUBY_BOOLEAN_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_BYTE_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_SHORT_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_CHAR_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_INTEGER_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_LONG_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_FLOAT_CONVERTER;
    @Deprecated
    public static final RubyConverter RUBY_DOUBLE_CONVERTER;
    @Deprecated
    public static final Map<Class, RubyConverter> RUBY_CONVERTERS;
    @Deprecated
    public static final RubyConverter ARRAY_BOOLEAN_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BYTE_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_SHORT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_CHAR_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_INT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_LONG_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_FLOAT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_DOUBLE_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_OBJECT_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_CLASS_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_STRING_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BIGINTEGER_CONVERTER;
    @Deprecated
    public static final RubyConverter ARRAY_BIGDECIMAL_CONVERTER;
    @Deprecated
    public static final Map<Class, RubyConverter> ARRAY_CONVERTERS;

    public static IRubyObject[] convertJavaArrayToRuby(Ruby runtime2, Object[] objects) {
        if (objects == null) {
            return IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] rubyObjects = new IRubyObject[objects.length];
        for (int i2 = 0; i2 < objects.length; ++i2) {
            rubyObjects[i2] = JavaUtil.convertJavaToUsableRubyObject(runtime2, objects[i2]);
        }
        return rubyObjects;
    }

    public static RubyArray convertJavaArrayToRubyWithNesting(ThreadContext context, Object array) {
        int length2 = Array.getLength(array);
        RubyArray outer = context.runtime.newArray(length2);
        for (int i2 = 0; i2 < length2; ++i2) {
            Object element = Array.get(array, i2);
            if (element instanceof ArrayJavaProxy) {
                outer.append(JavaUtil.convertJavaArrayToRubyWithNesting(context, ((ArrayJavaProxy)element).getObject()));
                continue;
            }
            outer.append(JavaUtil.convertJavaToUsableRubyObject(context.runtime, element));
        }
        return outer;
    }

    public static JavaConverter getJavaConverter(Class clazz) {
        JavaConverter converter = JAVA_CONVERTERS.get(clazz);
        if (converter == null) {
            converter = JAVA_DEFAULT_CONVERTER;
        }
        return converter;
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, Object object) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, object);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, Object object, Class javaClass) {
        return JavaUtil.convertJavaToUsableRubyObjectWithConverter(runtime2, object, JavaUtil.getJavaConverter(javaClass));
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, int i2) {
        return runtime2.newFixnum(i2);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, long l) {
        return runtime2.newFixnum(l);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, float f) {
        return runtime2.newFloat(f);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, double d) {
        return runtime2.newFloat(d);
    }

    public static IRubyObject convertJavaToRuby(Ruby runtime2, boolean b) {
        return runtime2.newBoolean(b);
    }

    public static IRubyObject convertJavaToUsableRubyObject(Ruby runtime2, Object object) {
        IRubyObject result2 = JavaUtil.trySimpleConversions(runtime2, object);
        if (result2 != null) {
            return result2;
        }
        JavaConverter converter = JavaUtil.getJavaConverter(object.getClass());
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime2, object);
        }
        return converter.convert(runtime2, object);
    }

    public static IRubyObject convertJavaToUsableRubyObjectWithConverter(Ruby runtime2, Object object, JavaConverter converter) {
        IRubyObject result2 = JavaUtil.trySimpleConversions(runtime2, object);
        if (result2 != null) {
            return result2;
        }
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime2, object);
        }
        return converter.convert(runtime2, object);
    }

    public static IRubyObject convertJavaArrayElementToRuby(Ruby runtime2, JavaConverter converter, Object array, int i2) {
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            IRubyObject x = JavaUtil.convertJavaToUsableRubyObject(runtime2, ((Object[])array)[i2]);
            return x;
        }
        return converter.get(runtime2, array, i2);
    }

    public static Class<?> primitiveToWrapper(Class<?> type2) {
        if (type2.isPrimitive()) {
            if (type2 == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type2 == Byte.TYPE) {
                return Byte.class;
            }
            if (type2 == Short.TYPE) {
                return Short.class;
            }
            if (type2 == Character.TYPE) {
                return Character.class;
            }
            if (type2 == Integer.TYPE) {
                return Integer.class;
            }
            if (type2 == Long.TYPE) {
                return Long.class;
            }
            if (type2 == Float.TYPE) {
                return Float.class;
            }
            if (type2 == Double.TYPE) {
                return Double.class;
            }
            if (type2 == Void.TYPE) {
                return Void.class;
            }
        }
        return type2;
    }

    public static boolean isDuckTypeConvertable(Class providedArgumentType, Class parameterType) {
        return parameterType.isInterface() && !parameterType.isAssignableFrom(providedArgumentType) && RubyObject.class.isAssignableFrom(providedArgumentType);
    }

    public static Object convertProcToInterface(ThreadContext context, RubyObject rubyObject, Class target) {
        return JavaUtil.convertProcToInterface(context, (RubyBasicObject)rubyObject, target);
    }

    public static Object convertProcToInterface(ThreadContext context, RubyBasicObject rubyObject, Class target) {
        Ruby runtime2 = context.getRuntime();
        RubyModule javaInterfaceModule = (RubyModule)Java.get_interface_module(runtime2, JavaClass.get(runtime2, target));
        if (!javaInterfaceModule.isInstance(rubyObject)) {
            javaInterfaceModule.callMethod(context, "extend_object", (IRubyObject)rubyObject);
            javaInterfaceModule.callMethod(context, "extended", (IRubyObject)rubyObject);
        }
        if (rubyObject instanceof RubyProc) {
            RubyClass singletonClass = rubyObject.getSingletonClass();
            singletonClass.addMethod("method_missing", new DynamicMethod(singletonClass, Visibility.PUBLIC, CallConfiguration.FrameNoneScopeNone){

                public IRubyObject call(ThreadContext context, IRubyObject self, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
                    IRubyObject[] newArgs;
                    if (!(self instanceof RubyProc)) {
                        throw context.getRuntime().newTypeError("interface impl method_missing for block used with non-Proc object");
                    }
                    RubyProc proc2 = (RubyProc)self;
                    if (args2.length == 1) {
                        newArgs = IRubyObject.NULL_ARRAY;
                    } else {
                        newArgs = new IRubyObject[args2.length - 1];
                        System.arraycopy(args2, 1, newArgs, 0, args2.length - 1);
                    }
                    return proc2.call(context, newArgs);
                }

                public DynamicMethod dup() {
                    return this;
                }
            });
        }
        JavaObject jo = (JavaObject)RuntimeHelpers.invoke(context, rubyObject, "__jcreate_meta!");
        return jo.getValue();
    }

    public static NumericConverter getNumericConverter(Class target) {
        NumericConverter converter = NUMERIC_CONVERTERS.get(target);
        if (converter == null) {
            return NUMERIC_TO_OTHER;
        }
        return converter;
    }

    public static boolean isJavaObject(IRubyObject candidate) {
        return candidate instanceof JavaProxy || candidate.dataGetStruct() instanceof JavaObject;
    }

    public static Object unwrapJavaObject(IRubyObject object) {
        if (object instanceof JavaProxy) {
            return ((JavaProxy)object).getObject();
        }
        return ((JavaObject)object.dataGetStruct()).getValue();
    }

    public static Object unwrapJavaValue(Ruby runtime2, IRubyObject obj, String errorMessage) {
        if (obj instanceof JavaProxy) {
            return ((JavaProxy)obj).getObject();
        }
        if (obj instanceof JavaObject) {
            return ((JavaObject)obj).getValue();
        }
        if (obj.dataGetStruct() != null && obj.dataGetStruct() instanceof IRubyObject) {
            return JavaUtil.unwrapJavaValue(runtime2, (IRubyObject)obj.dataGetStruct(), errorMessage);
        }
        throw runtime2.newTypeError(errorMessage);
    }

    public static String getJavaPropertyName(String beanMethodName) {
        char ch;
        int length2 = beanMethodName.length();
        if ((beanMethodName.startsWith("get") || beanMethodName.startsWith("set")) && length2 > 3) {
            char ch2 = beanMethodName.charAt(3);
            if (JavaUtil.isUpperDigit(ch2)) {
                if (length2 == 4) {
                    return Character.toString(Character.toLowerCase(ch2));
                }
                return "" + Character.toLowerCase(ch2) + beanMethodName.substring(4);
            }
        } else if (beanMethodName.startsWith("is") && length2 > 2 && JavaUtil.isUpperDigit(ch = beanMethodName.charAt(2))) {
            if (length2 == 3) {
                return Character.toString(Character.toLowerCase(ch));
            }
            return "" + Character.toLowerCase(ch) + beanMethodName.substring(3);
        }
        return null;
    }

    public static String getRubyCasedName(String javaCasedName) {
        StringBuilder b = new StringBuilder();
        char[] chars2 = javaCasedName.toCharArray();
        int behind = 0;
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            if (behind < 2) {
                ++behind;
                continue;
            }
            behind = JavaUtil.consume(b, chars2, i2);
        }
        if (behind == 2) {
            b.append(Character.toLowerCase(chars2[chars2.length - 2]));
            if (Character.isUpperCase(chars2[chars2.length - 1]) && !Character.isUpperCase(chars2[chars2.length - 2])) {
                b.append('_');
            }
            b.append(Character.toLowerCase(chars2[chars2.length - 1]));
        } else if (behind > 0) {
            if (behind > 1) {
                b.append(Character.toLowerCase(chars2[chars2.length - 2]));
            }
            b.append(Character.toLowerCase(chars2[chars2.length - 1]));
        }
        return b.toString();
    }

    private static int consume(StringBuilder b, char[] chars2, int i2) {
        char cur;
        char prev;
        char prev2 = chars2[i2 - 2];
        if (JavaUtil.isLowerDigit(prev2) && Character.isUpperCase(prev = chars2[i2 - 1])) {
            b.append(prev2).append('_').append(Character.toLowerCase(prev));
            return 1;
        }
        if (JavaUtil.isLetterDigit(prev2) && Character.isUpperCase(prev = chars2[i2 - 1]) && Character.isLowerCase(cur = chars2[i2])) {
            b.append(Character.toLowerCase(prev2)).append('_').append(Character.toLowerCase(prev)).append(cur);
            return 0;
        }
        b.append(Character.toLowerCase(prev2));
        return 2;
    }

    private static boolean isUpperDigit(char c) {
        return Character.isUpperCase(c) || Character.isDigit(c);
    }

    private static boolean isLowerDigit(char c) {
        return Character.isLowerCase(c) || Character.isDigit(c);
    }

    private static boolean isLetterDigit(char c) {
        return Character.isLetter(c) || Character.isDigit(c);
    }

    public static String getJavaCasedName(String javaCasedName) {
        Matcher m = RUBY_CASE_SPLITTER.matcher(javaCasedName);
        StringBuffer newName = new StringBuffer();
        if (!m.find()) {
            return null;
        }
        m.reset();
        while (m.find()) {
            m.appendReplacement(newName, m.group(1) + Character.toUpperCase(m.group(2).charAt(0)));
        }
        m.appendTail(newName);
        return newName.toString();
    }

    public static Set<String> getRubyNamesForJavaName(String javaName, List<Method> methods2) {
        String javaPropertyName = JavaUtil.getJavaPropertyName(javaName);
        String rubyName = JavaUtil.getRubyCasedName(javaName);
        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
        nameSet.add(javaName);
        nameSet.add(rubyName);
        String rubyPropertyName = null;
        for (Method method2 : methods2) {
            Class<?>[] argTypes = method2.getParameterTypes();
            Class<?> resultType = method2.getReturnType();
            int argCount = argTypes.length;
            if (javaPropertyName != null) {
                if (rubyName.startsWith("get_")) {
                    rubyPropertyName = rubyName.substring(4);
                    if (argCount != 0 && (argCount != 1 || argTypes[0] != Integer.TYPE)) continue;
                    nameSet.add(javaPropertyName);
                    nameSet.add(rubyPropertyName);
                    if (resultType != Boolean.TYPE) continue;
                    nameSet.add(javaPropertyName + '?');
                    nameSet.add(rubyPropertyName + '?');
                    continue;
                }
                if (rubyName.startsWith("set_")) {
                    rubyPropertyName = rubyName.substring(4);
                    if (argCount != 1 || resultType != Void.TYPE) continue;
                    nameSet.add(javaPropertyName + '=');
                    nameSet.add(rubyPropertyName + '=');
                    continue;
                }
                if (!rubyName.startsWith("is_")) continue;
                rubyPropertyName = rubyName.substring(3);
                if (resultType != Boolean.TYPE) continue;
                nameSet.add(javaPropertyName);
                nameSet.add(rubyPropertyName);
                nameSet.add(javaPropertyName + '?');
                nameSet.add(rubyPropertyName + '?');
                continue;
            }
            if (resultType != Boolean.TYPE) continue;
            nameSet.add(javaName + '?');
            nameSet.add(rubyName + '?');
        }
        return nameSet;
    }

    private static IRubyObject trySimpleConversions(Ruby runtime2, Object object) {
        InternalJavaProxy internalJavaProxy;
        IRubyObject orig;
        if (object == null) {
            return runtime2.getNil();
        }
        if (object instanceof IRubyObject) {
            return (IRubyObject)object;
        }
        if (object instanceof RubyObjectHolderProxy) {
            return ((RubyObjectHolderProxy)object).__ruby_object();
        }
        if (object instanceof InternalJavaProxy && (orig = (internalJavaProxy = (InternalJavaProxy)object).___getInvocationHandler().getOrig()) != null) {
            return orig;
        }
        return null;
    }

    private static boolean isDoubleFloatable(double value2) {
        return true;
    }

    private static boolean isLongByteable(long value2) {
        return value2 >= -128L && value2 <= 127L;
    }

    private static boolean isLongShortable(long value2) {
        return value2 >= -32768L && value2 <= 32767L;
    }

    private static boolean isLongCharable(long value2) {
        return value2 >= 0L && value2 <= 65535L;
    }

    private static boolean isLongIntable(long value2) {
        return value2 >= Integer.MIN_VALUE && value2 <= Integer.MAX_VALUE;
    }

    @Deprecated
    public static Object convertRubyToJava(IRubyObject rubyObject) {
        return JavaUtil.convertRubyToJava(rubyObject, Object.class);
    }

    @Deprecated
    public static Object convertRubyToJava(IRubyObject rubyObject, Class javaClass) {
        if (javaClass == Void.TYPE || rubyObject == null || rubyObject.isNil()) {
            return null;
        }
        ThreadContext context = rubyObject.getRuntime().getCurrentContext();
        IRubyObject origObject = rubyObject;
        if (rubyObject.dataGetStruct() instanceof JavaObject) {
            if ((rubyObject = (JavaObject)rubyObject.dataGetStruct()) == null) {
                throw new RuntimeException("dataGetStruct returned null for " + origObject.getType().getName());
            }
        } else if (rubyObject.respondsTo("java_object") && (rubyObject = rubyObject.callMethod(context, "java_object")) == null) {
            throw new RuntimeException("java_object returned null for " + origObject.getType().getName());
        }
        if (rubyObject instanceof JavaObject) {
            Object value2 = ((JavaObject)rubyObject).getValue();
            return JavaUtil.convertArgument(rubyObject.getRuntime(), value2, value2.getClass());
        }
        if (javaClass == Object.class || javaClass == null) {
            javaClass = rubyObject.getJavaClass();
        }
        if (javaClass.isInstance(rubyObject)) {
            return rubyObject;
        }
        RubyConverter converter = RUBY_CONVERTERS.get(javaClass);
        if (converter != null) {
            return converter.convert(context, rubyObject);
        }
        if (javaClass.isPrimitive()) {
            String s2 = ((RubyString)TypeConverter.convertToType(rubyObject, rubyObject.getRuntime().getString(), "to_s", true)).getUnicodeValue();
            if (s2.length() > 0) {
                return Character.valueOf(s2.charAt(0));
            }
            return Character.valueOf('\u0000');
        }
        if (javaClass == String.class) {
            RubyString rubyString = (RubyString)rubyObject.callMethod(context, "to_s");
            ByteList bytes2 = rubyString.getByteList();
            return RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        if (javaClass == ByteList.class) {
            return rubyObject.convertToString().getByteList();
        }
        if (javaClass == BigInteger.class) {
            if (rubyObject instanceof RubyBignum) {
                return ((RubyBignum)rubyObject).getValue();
            }
            if (rubyObject instanceof RubyNumeric) {
                return BigInteger.valueOf(((RubyNumeric)rubyObject).getLongValue());
            }
            if (rubyObject.respondsTo("to_i")) {
                RubyNumeric rubyNumeric = (RubyNumeric)rubyObject.callMethod(context, "to_f");
                return BigInteger.valueOf(rubyNumeric.getLongValue());
            }
        } else if (javaClass == BigDecimal.class && !(rubyObject instanceof JavaObject) && rubyObject.respondsTo("to_f")) {
            double double_value = ((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue();
            return new BigDecimal(double_value);
        }
        try {
            if (JavaUtil.isDuckTypeConvertable(rubyObject.getClass(), javaClass)) {
                return JavaUtil.convertProcToInterface(context, (RubyObject)rubyObject, javaClass);
            }
            return ((JavaObject)rubyObject).getValue();
        }
        catch (ClassCastException ex) {
            if (rubyObject.getRuntime().getDebug().isTrue()) {
                ex.printStackTrace();
            }
            return null;
        }
    }

    @Deprecated
    public static byte convertRubyToJavaByte(IRubyObject rubyObject) {
        return (Byte)JavaUtil.convertRubyToJava(rubyObject, Byte.TYPE);
    }

    @Deprecated
    public static short convertRubyToJavaShort(IRubyObject rubyObject) {
        return (Short)JavaUtil.convertRubyToJava(rubyObject, Short.TYPE);
    }

    @Deprecated
    public static char convertRubyToJavaChar(IRubyObject rubyObject) {
        return ((Character)JavaUtil.convertRubyToJava(rubyObject, Character.TYPE)).charValue();
    }

    @Deprecated
    public static int convertRubyToJavaInt(IRubyObject rubyObject) {
        return (Integer)JavaUtil.convertRubyToJava(rubyObject, Integer.TYPE);
    }

    @Deprecated
    public static long convertRubyToJavaLong(IRubyObject rubyObject) {
        return (Long)JavaUtil.convertRubyToJava(rubyObject, Long.TYPE);
    }

    @Deprecated
    public static float convertRubyToJavaFloat(IRubyObject rubyObject) {
        return ((Float)JavaUtil.convertRubyToJava(rubyObject, Float.TYPE)).floatValue();
    }

    @Deprecated
    public static double convertRubyToJavaDouble(IRubyObject rubyObject) {
        return (Double)JavaUtil.convertRubyToJava(rubyObject, Double.TYPE);
    }

    @Deprecated
    public static boolean convertRubyToJavaBoolean(IRubyObject rubyObject) {
        return (Boolean)JavaUtil.convertRubyToJava(rubyObject, Boolean.TYPE);
    }

    @Deprecated
    public static Object convertArgumentToType(ThreadContext context, IRubyObject arg2, Class target) {
        return arg2.toJava(target);
    }

    @Deprecated
    public static Object coerceNilToType(RubyNil nil, Class target) {
        return nil.toJava(target);
    }

    @Deprecated
    public static IRubyObject convertJavaToRuby(Ruby runtime2, JavaConverter converter, Object object) {
        if (converter == null || converter == JAVA_DEFAULT_CONVERTER) {
            return Java.getInstance(runtime2, object);
        }
        return converter.convert(runtime2, object);
    }

    @Deprecated
    public static RubyConverter getArrayConverter(Class type2) {
        RubyConverter converter = ARRAY_CONVERTERS.get(type2);
        if (converter == null) {
            return ARRAY_OBJECT_CONVERTER;
        }
        return converter;
    }

    @Deprecated
    public static IRubyObject ruby_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        if (object.respondsTo("to_java_object")) {
            IRubyObject result2 = (JavaObject)object.dataGetStruct();
            if (result2 == null) {
                result2 = object.callMethod(recv2.getRuntime().getCurrentContext(), "to_java_object");
            }
            if (result2 instanceof JavaObject) {
                recv2.getRuntime().getJavaSupport().getObjectProxyCache().put(((JavaObject)result2).getValue(), object);
            }
            return result2;
        }
        return JavaUtil.primitive_to_java(recv2, object, unusedBlock);
    }

    @Deprecated
    public static IRubyObject java_to_primitive(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToRuby(recv2.getRuntime(), ((JavaObject)object).getValue());
        }
        return object;
    }

    @Deprecated
    public static IRubyObject primitive_to_java(IRubyObject recv2, IRubyObject object, Block unusedBlock) {
        Object javaObject;
        if (object instanceof JavaObject) {
            return object;
        }
        Ruby runtime2 = recv2.getRuntime();
        switch (object.getMetaClass().index) {
            case 5: {
                javaObject = null;
                break;
            }
            case 1: {
                javaObject = ((RubyFixnum)object).getLongValue();
                break;
            }
            case 2: {
                javaObject = ((RubyBignum)object).getValue();
                break;
            }
            case 11: {
                javaObject = new Double(((RubyFloat)object).getValue());
                break;
            }
            case 4: {
                ByteList bytes2 = ((RubyString)object).getByteList();
                javaObject = RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
                break;
            }
            case 6: {
                javaObject = Boolean.TRUE;
                break;
            }
            case 7: {
                javaObject = Boolean.FALSE;
                break;
            }
            case 19: {
                javaObject = ((RubyTime)object).getJavaDate();
                break;
            }
            default: {
                return object;
            }
        }
        return JavaObject.wrap(runtime2, javaObject);
    }

    @Deprecated
    public static Object convertArgument(Ruby runtime2, Object argument, Class<?> parameterType) {
        RubyObject rubyObject;
        if (argument == null) {
            if (parameterType.isPrimitive()) {
                throw runtime2.newTypeError("primitives do not accept null");
            }
            return null;
        }
        if (argument instanceof JavaObject && (argument = ((JavaObject)argument).getValue()) == null) {
            return null;
        }
        Class<?> type2 = JavaUtil.primitiveToWrapper(parameterType);
        if (type2 == Void.class) {
            return null;
        }
        if (argument instanceof Number) {
            Number number = (Number)argument;
            if (type2 == Long.class) {
                return number.longValue();
            }
            if (type2 == Integer.class) {
                return number.intValue();
            }
            if (type2 == Byte.class) {
                return number.byteValue();
            }
            if (type2 == Character.class) {
                return Character.valueOf((char)number.intValue());
            }
            if (type2 == Double.class) {
                return new Double(number.doubleValue());
            }
            if (type2 == Float.class) {
                return new Float(number.floatValue());
            }
            if (type2 == Short.class) {
                return number.shortValue();
            }
        }
        if (JavaUtil.isDuckTypeConvertable(argument.getClass(), parameterType) && !(rubyObject = (RubyObject)argument).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(runtime2.getCurrentContext(), rubyObject, parameterType);
        }
        return argument;
    }

    @Deprecated
    public static IRubyObject java_to_ruby(Ruby runtime2, IRubyObject object) {
        if (object instanceof JavaObject) {
            return JavaUtil.convertJavaToUsableRubyObject(runtime2, ((JavaObject)object).getValue());
        }
        return object;
    }

    @Deprecated
    public static Object coerceStringToType(RubyString string2, Class target) {
        try {
            ByteList bytes2 = string2.getByteList();
            if (string2.getRuntime().is1_9()) {
                return new String(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length(), string2.getEncoding().toString());
            }
            return RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.begin(), bytes2.length());
        }
        catch (UnsupportedEncodingException uee) {
            return string2.toString();
        }
    }

    @Deprecated
    public static Object coerceOtherToType(ThreadContext context, IRubyObject arg2, Class target) {
        RubyObject rubyObject;
        if (JavaUtil.isDuckTypeConvertable(arg2.getClass(), target) && !(rubyObject = (RubyObject)arg2).respondsTo("java_object")) {
            return JavaUtil.convertProcToInterface(context, rubyObject, target);
        }
        return arg2;
    }

    @Deprecated
    public static Object coerceJavaObjectToType(ThreadContext context, Object javaObject, Class target) {
        if (javaObject != null && JavaUtil.isDuckTypeConvertable(javaObject.getClass(), target)) {
            RubyObject rubyObject = (RubyObject)javaObject;
            if (!rubyObject.respondsTo("java_object")) {
                return JavaUtil.convertProcToInterface(context, rubyObject, target);
            }
            return javaObject;
        }
        return javaObject;
    }

    @Deprecated
    public static JavaObject unwrapJavaObject(Ruby runtime2, IRubyObject convertee, String errorMessage) {
        IRubyObject obj = convertee;
        if (!(obj instanceof JavaObject)) {
            if (obj.dataGetStruct() != null && obj.dataGetStruct() instanceof JavaObject) {
                obj = (JavaObject)obj.dataGetStruct();
            } else {
                throw runtime2.newTypeError(errorMessage);
            }
        }
        return (JavaObject)obj;
    }

    static {
        JAVA_CONVERTERS.put(Byte.class, JAVA_BYTE_CONVERTER);
        JAVA_CONVERTERS.put(Byte.TYPE, JAVA_BYTEPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Short.class, JAVA_SHORT_CONVERTER);
        JAVA_CONVERTERS.put(Short.TYPE, JAVA_SHORTPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Character.class, JAVA_CHAR_CONVERTER);
        JAVA_CONVERTERS.put(Character.TYPE, JAVA_CHARPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Integer.class, JAVA_INT_CONVERTER);
        JAVA_CONVERTERS.put(Integer.TYPE, JAVA_INTPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Long.class, JAVA_LONG_CONVERTER);
        JAVA_CONVERTERS.put(Long.TYPE, JAVA_LONGPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Float.class, JAVA_FLOAT_CONVERTER);
        JAVA_CONVERTERS.put(Float.TYPE, JAVA_FLOATPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Double.class, JAVA_DOUBLE_CONVERTER);
        JAVA_CONVERTERS.put(Double.TYPE, JAVA_DOUBLEPRIM_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.class, JAVA_BOOLEAN_CONVERTER);
        JAVA_CONVERTERS.put(Boolean.TYPE, JAVA_BOOLEANPRIM_CONVERTER);
        JAVA_CONVERTERS.put(String.class, JAVA_STRING_CONVERTER);
        JAVA_CONVERTERS.put(CharSequence.class, JAVA_CHARSEQUENCE_CONVERTER);
        JAVA_CONVERTERS.put(ByteList.class, BYTELIST_CONVERTER);
        JAVA_CONVERTERS.put(BigInteger.class, JAVA_BIGINTEGER_CONVERTER);
        NUMERIC_TO_BYTE = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongByteable(value2)) {
                    return (byte)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for byte: " + numeric);
            }
        };
        NUMERIC_TO_SHORT = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongShortable(value2)) {
                    return (short)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for short: " + numeric);
            }
        };
        NUMERIC_TO_CHARACTER = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongCharable(value2)) {
                    return Character.valueOf((char)value2);
                }
                throw numeric.getRuntime().newRangeError("too big for char: " + numeric);
            }
        };
        NUMERIC_TO_INTEGER = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                long value2 = numeric.getLongValue();
                if (JavaUtil.isLongIntable(value2)) {
                    return (int)value2;
                }
                throw numeric.getRuntime().newRangeError("too big for int: " + numeric);
            }
        };
        NUMERIC_TO_LONG = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getLongValue();
            }
        };
        NUMERIC_TO_FLOAT = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                double value2 = numeric.getDoubleValue();
                if (JavaUtil.isDoubleFloatable(value2)) {
                    return Float.valueOf((float)value2);
                }
                throw numeric.getRuntime().newTypeError("too big for float: " + numeric);
            }
        };
        NUMERIC_TO_DOUBLE = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getDoubleValue();
            }
        };
        NUMERIC_TO_BIGINTEGER = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                return numeric.getBigIntegerValue();
            }
        };
        NUMERIC_TO_OBJECT = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                if (numeric instanceof RubyFixnum) {
                    long value2 = numeric.getLongValue();
                    return value2;
                }
                if (numeric instanceof RubyFloat) {
                    double value3 = numeric.getDoubleValue();
                    return value3;
                }
                if (numeric instanceof RubyBignum) {
                    return ((RubyBignum)numeric).getValue();
                }
                if (numeric instanceof RubyBigDecimal) {
                    return ((RubyBigDecimal)numeric).getValue();
                }
                return NUMERIC_TO_OTHER.coerce(numeric, target);
            }
        };
        NUMERIC_TO_OTHER = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                if (target.isAssignableFrom(numeric.getClass())) {
                    return numeric;
                }
                throw numeric.getRuntime().newTypeError("could not coerce " + numeric.getMetaClass() + " to " + target);
            }
        };
        NUMERIC_TO_VOID = new NumericConverter(){

            public Object coerce(RubyNumeric numeric, Class target) {
                return null;
            }
        };
        NUMERIC_CONVERTERS = new HashMap<Class, NumericConverter>();
        NUMERIC_CONVERTERS.put(Byte.TYPE, NUMERIC_TO_BYTE);
        NUMERIC_CONVERTERS.put(Byte.class, NUMERIC_TO_BYTE);
        NUMERIC_CONVERTERS.put(Short.TYPE, NUMERIC_TO_SHORT);
        NUMERIC_CONVERTERS.put(Short.class, NUMERIC_TO_SHORT);
        NUMERIC_CONVERTERS.put(Character.TYPE, NUMERIC_TO_CHARACTER);
        NUMERIC_CONVERTERS.put(Character.class, NUMERIC_TO_CHARACTER);
        NUMERIC_CONVERTERS.put(Integer.TYPE, NUMERIC_TO_INTEGER);
        NUMERIC_CONVERTERS.put(Integer.class, NUMERIC_TO_INTEGER);
        NUMERIC_CONVERTERS.put(Long.TYPE, NUMERIC_TO_LONG);
        NUMERIC_CONVERTERS.put(Long.class, NUMERIC_TO_LONG);
        NUMERIC_CONVERTERS.put(Float.TYPE, NUMERIC_TO_FLOAT);
        NUMERIC_CONVERTERS.put(Float.class, NUMERIC_TO_FLOAT);
        NUMERIC_CONVERTERS.put(Double.TYPE, NUMERIC_TO_DOUBLE);
        NUMERIC_CONVERTERS.put(Double.class, NUMERIC_TO_DOUBLE);
        NUMERIC_CONVERTERS.put(BigInteger.class, NUMERIC_TO_BIGINTEGER);
        NUMERIC_CONVERTERS.put(Object.class, NUMERIC_TO_OBJECT);
        NUMERIC_CONVERTERS.put(Void.TYPE, NUMERIC_TO_VOID);
        RUBY_BOOLEAN_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.isTrue();
            }
        };
        RUBY_BYTE_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (byte)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return (byte)0;
            }
        };
        RUBY_SHORT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (short)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return (short)0;
            }
        };
        RUBY_CHAR_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return Character.valueOf((char)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue());
                }
                return Character.valueOf('\u0000');
            }
        };
        RUBY_INTEGER_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return (int)((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return 0;
            }
        };
        RUBY_LONG_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_i")) {
                    return ((RubyNumeric)rubyObject.callMethod(context, "to_i")).getLongValue();
                }
                return 0L;
            }
        };
        RUBY_FLOAT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_f")) {
                    return new Float((float)((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue());
                }
                return new Float(0.0);
            }
        };
        RUBY_DOUBLE_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                if (rubyObject.respondsTo("to_f")) {
                    return new Double(((RubyNumeric)rubyObject.callMethod(context, "to_f")).getDoubleValue());
                }
                return new Double(0.0);
            }
        };
        RUBY_CONVERTERS = new HashMap<Class, RubyConverter>();
        RUBY_CONVERTERS.put(Boolean.class, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Boolean.TYPE, RUBY_BOOLEAN_CONVERTER);
        RUBY_CONVERTERS.put(Byte.class, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Byte.TYPE, RUBY_BYTE_CONVERTER);
        RUBY_CONVERTERS.put(Short.class, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Short.TYPE, RUBY_SHORT_CONVERTER);
        RUBY_CONVERTERS.put(Integer.class, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Integer.TYPE, RUBY_INTEGER_CONVERTER);
        RUBY_CONVERTERS.put(Long.class, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Long.TYPE, RUBY_LONG_CONVERTER);
        RUBY_CONVERTERS.put(Float.class, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Float.TYPE, RUBY_FLOAT_CONVERTER);
        RUBY_CONVERTERS.put(Double.class, RUBY_DOUBLE_CONVERTER);
        RUBY_CONVERTERS.put(Double.TYPE, RUBY_DOUBLE_CONVERTER);
        ARRAY_BOOLEAN_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Boolean.class);
            }
        };
        ARRAY_BYTE_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Byte.class);
            }
        };
        ARRAY_SHORT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Short.class);
            }
        };
        ARRAY_CHAR_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Character.class);
            }
        };
        ARRAY_INT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Integer.class);
            }
        };
        ARRAY_LONG_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Long.class);
            }
        };
        ARRAY_FLOAT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Float.class);
            }
        };
        ARRAY_DOUBLE_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Double.class);
            }
        };
        ARRAY_OBJECT_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Object.class);
            }
        };
        ARRAY_CLASS_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(Class.class);
            }
        };
        ARRAY_STRING_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(String.class);
            }
        };
        ARRAY_BIGINTEGER_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(BigInteger.class);
            }
        };
        ARRAY_BIGDECIMAL_CONVERTER = new RubyConverter(){

            public Object convert(ThreadContext context, IRubyObject rubyObject) {
                return rubyObject.toJava(BigDecimal.class);
            }
        };
        ARRAY_CONVERTERS = new HashMap<Class, RubyConverter>();
        ARRAY_CONVERTERS.put(Boolean.class, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Boolean.TYPE, ARRAY_BOOLEAN_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.class, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Byte.TYPE, ARRAY_BYTE_CONVERTER);
        ARRAY_CONVERTERS.put(Short.class, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Short.TYPE, ARRAY_SHORT_CONVERTER);
        ARRAY_CONVERTERS.put(Character.class, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Character.TYPE, ARRAY_CHAR_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.class, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Integer.TYPE, ARRAY_INT_CONVERTER);
        ARRAY_CONVERTERS.put(Long.class, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Long.TYPE, ARRAY_LONG_CONVERTER);
        ARRAY_CONVERTERS.put(Float.class, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Float.TYPE, ARRAY_FLOAT_CONVERTER);
        ARRAY_CONVERTERS.put(Double.class, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(Double.TYPE, ARRAY_DOUBLE_CONVERTER);
        ARRAY_CONVERTERS.put(String.class, ARRAY_STRING_CONVERTER);
        ARRAY_CONVERTERS.put(Class.class, ARRAY_CLASS_CONVERTER);
        ARRAY_CONVERTERS.put(BigInteger.class, ARRAY_BIGINTEGER_CONVERTER);
        ARRAY_CONVERTERS.put(BigDecimal.class, ARRAY_BIGDECIMAL_CONVERTER);
    }

    @Deprecated
    public static interface RubyConverter {
        public Object convert(ThreadContext var1, IRubyObject var2);
    }

    public static interface NumericConverter {
        public Object coerce(RubyNumeric var1, Class var2);
    }

    public static abstract class JavaConverter {
        private final Class type;

        public JavaConverter(Class type2) {
            this.type = type2;
        }

        public abstract IRubyObject convert(Ruby var1, Object var2);

        public abstract IRubyObject get(Ruby var1, Object var2, int var3);

        public String toString() {
            return this.type.getName() + " converter";
        }
    }
}

