/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import java.security.SignatureException;
import javax.servlet.http.HttpServletRequest;
import net.oauth.jsontoken.Clock;
import net.oauth.jsontoken.JsonTokenParser;
import net.oauth.jsontoken.SystemClock;
import net.oauth.jsontoken.discovery.VerifierProviders;
import net.oauth.signatures.NonceChecker;
import net.oauth.signatures.SignedJsonAssertionAudienceChecker;
import net.oauth.signatures.SignedJsonAssertionToken;

public class SignedJsonAssertionTokenParser {
    public static String EXPECTED_CONTENT_TYPE = "application/x-www-form-urlencoded";
    private final VerifierProviders locators;
    private final NonceChecker nonceChecker;
    private final Clock clock;

    public SignedJsonAssertionTokenParser(VerifierProviders locators, NonceChecker nonceChecker) {
        this(locators, nonceChecker, new SystemClock());
    }

    public SignedJsonAssertionTokenParser(VerifierProviders locators, NonceChecker nonceChecker, Clock clock) {
        this.locators = locators;
        this.nonceChecker = nonceChecker;
        this.clock = clock;
    }

    public SignedJsonAssertionToken parseToken(HttpServletRequest request) throws SignatureException {
        if (!request.getContentType().startsWith(EXPECTED_CONTENT_TYPE)) {
            throw new SignatureException("bad content type: " + request.getContentType());
        }
        String grantType = request.getParameter("grant_type");
        if (grantType == null || !grantType.equalsIgnoreCase("http://oauth.net/grant_type/jwt/1.0/bearer")) {
            throw new SignatureException("bad grant_type: " + grantType);
        }
        String assertion = request.getParameter("jwt");
        if (assertion == null) {
            throw new SignatureException("empty json assertion");
        }
        StringBuffer uri = request.getRequestURL();
        if (request.getQueryString() != null) {
            uri.append("?");
            uri.append(request.getQueryString());
        }
        return this.parseToken(assertion, uri.toString());
    }

    public SignedJsonAssertionToken parseToken(String jsonAssertion, String uri) throws SignatureException {
        JsonTokenParser parser = new JsonTokenParser(this.clock, this.locators, new SignedJsonAssertionAudienceChecker(uri));
        SignedJsonAssertionToken token = new SignedJsonAssertionToken(parser.verifyAndDeserialize(jsonAssertion));
        if (this.nonceChecker != null) {
            this.nonceChecker.checkNonce(token.getNonce());
        }
        return token;
    }
}

