/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.oscache.base.algorithm;

import com.opensymphony.oscache.base.algorithm.AbstractConcurrentReadCache;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;

public class LRUCache
extends AbstractConcurrentReadCache {
    private static final long serialVersionUID = -7379608101794788534L;
    private Collection list = new LinkedHashSet();
    private volatile boolean removeInProgress = false;

    public LRUCache() {
    }

    public LRUCache(int capacity) {
        this();
        this.maxEntries = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemRetrieved(Object key) {
        while (this.removeInProgress) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(key);
            this.list.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void itemPut(Object key) {
        Collection collection = this.list;
        synchronized (collection) {
            this.list.remove(key);
            this.list.add(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object removeItem() {
        Object toRemove = null;
        this.removeInProgress = true;
        try {
            while (toRemove == null) {
                try {
                    toRemove = this.removeFirst();
                }
                catch (Exception e) {
                    do {
                        try {
                            Thread.sleep(5L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    } while (this.list.isEmpty());
                }
            }
        }
        finally {
            this.removeInProgress = false;
        }
        return toRemove;
    }

    protected void itemRemoved(Object key) {
        this.list.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object removeFirst() {
        Object toRemove = null;
        Collection collection = this.list;
        synchronized (collection) {
            Iterator it = this.list.iterator();
            toRemove = it.next();
            it.remove();
        }
        return toRemove;
    }
}

