/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.scheduler.config;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.SchedulerEntry;
import com.liferay.portal.kernel.scheduler.config.AbstractSchedulingConfigurator;
import com.liferay.portal.kernel.util.BasePortalLifecycle;

public class DefaultSchedulingConfigurator
extends AbstractSchedulingConfigurator {
    private static Log _log = LogFactoryUtil.getLog(DefaultSchedulingConfigurator.class);

    @Override
    public void configure() {
        if (this.schedulerEntries.isEmpty()) {
            return;
        }
        SchedulingConfiguratorLifecycle schedulingConfiguratorLifecycle = new SchedulingConfiguratorLifecycle();
        schedulingConfiguratorLifecycle.registerPortalLifecycle(2);
    }

    private class SchedulingConfiguratorLifecycle
    extends BasePortalLifecycle {
        private SchedulingConfiguratorLifecycle() {
        }

        @Override
        protected void doPortalDestroy() throws Exception {
        }

        @Override
        protected void doPortalInit() throws Exception {
            for (SchedulerEntry schedulerEntry : DefaultSchedulingConfigurator.this.schedulerEntries) {
                try {
                    SchedulerEngineHelperUtil.schedule(schedulerEntry, DefaultSchedulingConfigurator.this.storageType, null, DefaultSchedulingConfigurator.this.exceptionsMaxSize);
                }
                catch (Exception e) {
                    _log.error("Unable to schedule " + schedulerEntry, e);
                }
            }
        }
    }
}

