/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import java.util.List;
import jodd.asm.TraceSignatureVisitor;
import jodd.asm4.signature.SignatureVisitor;
import jodd.mutable.MutableInteger;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.util.collection.CharArrayList;
import jodd.util.collection.IntArrayList;

public class MethodSignatureVisitor
extends TraceSignatureVisitor
implements MethodInfo {
    protected int access;
    protected String methodName;
    protected String signature;
    protected int argumentsCount;
    protected int argumentsWords;
    protected MutableInteger returnOpcodeType;
    protected StringBuilder returnTypeName;
    protected String classname;
    protected String description;
    protected String rawSignature;
    protected AnnotationInfo[] annotations;
    protected boolean visitingArgument;
    protected CharArrayList argumentsOpcodeType;
    protected IntArrayList argumentsOffset;
    protected List<String> argumentsTypeNames;
    protected String declaredClassName;
    protected ClassInfo targetClassInfo;
    protected int hierarchyLevel;
    protected boolean isStatic;

    public MethodSignatureVisitor(String methodName, int access, String classname, String description, String signature, ClassInfo targetClassInfo) {
        this();
        this.isInterface = (access & 0x200) != 0;
        this.isStatic = (access & 8) != 0;
        this.methodName = methodName;
        this.access = access;
        this.classname = classname;
        this.description = description;
        this.targetClassInfo = targetClassInfo;
        this.rawSignature = signature;
    }

    private MethodSignatureVisitor() {
        super(new StringBuffer());
    }

    private MethodSignatureVisitor(StringBuffer declaration) {
        super(declaration);
    }

    private MethodSignatureVisitor(StringBuffer buf, MutableInteger returnOpcodeType, StringBuilder returnTypeName) {
        this(buf);
        this.returnOpcodeType = returnOpcodeType;
        this.returnTypeName = returnTypeName;
    }

    public SignatureVisitor visitParameterType() {
        super.visitParameterType();
        this.visitingArgument = true;
        if (this.argumentsOpcodeType == null) {
            this.argumentsOpcodeType = new CharArrayList();
            this.argumentsOffset = new IntArrayList();
            this.argumentsTypeNames = new ArrayList<String>();
            this.argumentsOpcodeType.add('L');
            this.argumentsOffset.add(0);
            this.argumentsTypeNames.add(null);
        }
        return this;
    }

    public SignatureVisitor visitReturnType() {
        super.visitReturnType();
        this.returnOpcodeType = new MutableInteger();
        this.returnTypeName = new StringBuilder();
        return new MethodSignatureVisitor(this.returnType, this.returnOpcodeType, this.returnTypeName);
    }

    public SignatureVisitor visitExceptionType() {
        super.visitExceptionType();
        return new MethodSignatureVisitor(this.exceptions);
    }

    public void visitBaseType(char descriptor) {
        String name = null;
        char type = descriptor;
        if (this.isArray()) {
            type = '[';
            name = this.getArrayDepthString() + descriptor;
        }
        super.visitBaseType(descriptor);
        this.maybeUseType(type, name);
    }

    public void visitTypeVariable(String name) {
        super.visitTypeVariable(name);
        this.maybeUseType('L', name);
    }

    public SignatureVisitor visitArrayType() {
        super.visitArrayType();
        return this;
    }

    public void visitClassType(String name) {
        super.visitClassType(name);
        this.maybeUseType('L', 'L' + name + ';');
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.createSignature();
        }
        return this.signature;
    }

    private String createSignature() {
        StringBuilder methodDeclaration = new StringBuilder(30);
        methodDeclaration.append(this.getReturnType()).append(' ').append(this.methodName).append(this.getDeclaration());
        String genericExceptions = this.getExceptions();
        if (genericExceptions != null) {
            methodDeclaration.append(" throws ").append(genericExceptions);
        }
        return methodDeclaration.toString();
    }

    public String getRawSignature() {
        return this.rawSignature;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int getArgumentsCount() {
        return this.argumentsCount;
    }

    public char getArgumentOpcodeType(int index) {
        return this.argumentsOpcodeType.get(index);
    }

    protected String getArgumentTypeName(int i) {
        return this.argumentsTypeNames.get(i);
    }

    protected int getArgumentOffset(int i) {
        return this.argumentsOffset.get(i);
    }

    protected int getAllArgumentsSize() {
        return this.argumentsWords;
    }

    public char getReturnOpcodeType() {
        return (char)this.returnOpcodeType.value;
    }

    public String getReturnTypeName() {
        return this.returnTypeName.toString();
    }

    public int getAccessFlags() {
        return this.access;
    }

    public String getClassname() {
        return this.classname;
    }

    public String getDescription() {
        return this.description;
    }

    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    public String getDeclaredClassName() {
        if (this.declaredClassName == null) {
            return this.classname;
        }
        return this.declaredClassName;
    }

    public void setDeclaredClassName(String declaredClassName) {
        this.declaredClassName = declaredClassName;
    }

    public boolean isTopLevelMethod() {
        return this.declaredClassName == null;
    }

    public ClassInfo getClassInfo() {
        return this.targetClassInfo;
    }

    public int getHierarchyLevel() {
        return this.hierarchyLevel;
    }

    private boolean isArray() {
        return this.arrayStack != 0;
    }

    private String getArrayDepthString() {
        int aStack = this.arrayStack;
        StringBuilder ads = new StringBuilder();
        while (aStack % 2 != 0) {
            aStack /= 2;
            ads.append('[');
        }
        return ads.toString();
    }

    private void maybeUseType(char type, String typeName) {
        if (this.visitingArgument) {
            if (this.isArray()) {
                type = (char)91;
                typeName = this.getArrayDepthString() + typeName;
            }
            if (type == 'V') {
                throw new ProxettaException("Method argument can't be void.");
            }
            ++this.argumentsCount;
            this.argumentsOpcodeType.add(type);
            this.argumentsOffset.add(this.argumentsWords + 1);
            this.argumentsTypeNames.add(typeName);
            this.argumentsWords = type == 'D' || type == 'J' ? (this.argumentsWords += 2) : ++this.argumentsWords;
            this.visitingArgument = false;
        } else if (this.returnOpcodeType != null) {
            if (this.isArray()) {
                type = (char)91;
                typeName = this.getArrayDepthString() + typeName;
            }
            this.returnOpcodeType.value = type;
            this.returnTypeName.setLength(0);
            if (typeName != null) {
                this.returnTypeName.append(typeName);
            }
        }
    }

    public String toString() {
        return this.getDeclaredClassName() + '#' + this.getMethodName() + this.getDescription();
    }
}

