/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.im;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.PropsUtil;
import java.lang.reflect.Method;

public class YMConnector {
    private static final String _SESSION = "ymsg.network.Session";
    private static Log _log = LogFactoryUtil.getLog(YMConnector.class);
    private static YMConnector _instance = new YMConnector();
    private boolean _jYMSGLibraryFound = true;
    private Method _loginMethod;
    private Method _logoutMethod;
    private Method _sendMessageMethod;
    private Object _ym;

    public static void disconnect() {
        if (_instance != null) {
            _instance._disconnect();
        }
    }

    public static void send(String to, String msg) throws IllegalStateException {
        _instance._send(to, msg);
    }

    private YMConnector() {
    }

    private void _connect() {
        block5: {
            try {
                Class<?> clazz = Class.forName(_SESSION);
                this._ym = clazz.newInstance();
                this._loginMethod = clazz.getMethod("login", String.class, String.class);
                this._logoutMethod = clazz.getMethod("logout", new Class[0]);
                this._sendMessageMethod = clazz.getMethod("sendMessage", String.class, String.class);
            }
            catch (Exception e2) {
                this._jYMSGLibraryFound = false;
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("jYMSG library could not be loaded: " + e2.getMessage()));
            }
        }
        try {
            if (this._jYMSGLibraryFound) {
                String login = PropsUtil.get("ym.login");
                String password = PropsUtil.get("ym.password");
                this._loginMethod.invoke(this._ym, login, password);
            }
        }
        catch (Exception e3) {
            _log.error((Throwable)e3);
        }
    }

    private void _disconnect() {
        block3: {
            try {
                if (this._ym != null) {
                    this._logoutMethod.invoke(this._ym, new Object[0]);
                }
            }
            catch (Exception e2) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Throwable)e2);
            }
        }
    }

    private void _send(String to, String msg) throws IllegalStateException {
        try {
            if (this._ym == null) {
                this._connect();
            }
            if (this._jYMSGLibraryFound) {
                this._sendMessageMethod.invoke(this._ym, to, msg);
            }
        }
        catch (Exception e2) {
            _log.error((Throwable)e2);
        }
    }
}

