/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.cache.CacheListener;
import com.liferay.portal.kernel.cache.CacheListenerScope;
import com.liferay.portal.kernel.cache.MultiVMPoolUtil;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.cache.SingleVMPoolUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.template.TemplateException;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoader;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.util.InstanceFactory;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.template.CacheTemplateResource;
import com.liferay.portal.template.TemplateResourceCacheListener;
import com.liferay.portal.template.TemplateResourceParser;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

@DoPrivileged
public class DefaultTemplateResourceLoader
implements TemplateResourceLoader {
    private static Log _log = LogFactoryUtil.getLog(DefaultTemplateResourceLoader.class);
    private static NullHolderTemplateResource _nullHolderTemplateResource = new NullHolderTemplateResource();
    private long _modificationCheckInterval;
    private PortalCache<String, TemplateResource> _multiVMPortalCache;
    private String _name;
    private PortalCache<String, TemplateResource> _singleVMPortalCache;
    private Set<TemplateResourceParser> _templateResourceParsers = new HashSet<TemplateResourceParser>();

    public DefaultTemplateResourceLoader(String name, String[] templateResourceParserClassNames, long modificationCheckInterval) {
        if (Validator.isNull((String)name)) {
            throw new IllegalArgumentException("Template resource loader name is null");
        }
        if (templateResourceParserClassNames == null) {
            throw new IllegalArgumentException("Template resource parser class names is null");
        }
        this._name = name;
        String[] stringArray = templateResourceParserClassNames;
        int n = templateResourceParserClassNames.length;
        int n2 = 0;
        while (n2 < n) {
            String templateResourceParserClassName = stringArray[n2];
            try {
                TemplateResourceParser templateResourceParser = (TemplateResourceParser)InstanceFactory.newInstance((String)templateResourceParserClassName);
                this._templateResourceParsers.add(templateResourceParser);
            }
            catch (Exception e2) {
                _log.error((Object)e2, (Throwable)e2);
            }
            ++n2;
        }
        this._modificationCheckInterval = modificationCheckInterval;
        String cacheName = TemplateResourceLoader.class.getName();
        cacheName = cacheName.concat(".").concat(name);
        this._multiVMPortalCache = MultiVMPoolUtil.getCache((String)cacheName);
        TemplateResourceCacheListener cacheListener = new TemplateResourceCacheListener(name);
        this._multiVMPortalCache.registerCacheListener((CacheListener)cacheListener, CacheListenerScope.ALL);
        this._singleVMPortalCache = SingleVMPoolUtil.getCache((String)cacheName);
        this._singleVMPortalCache.registerCacheListener((CacheListener)cacheListener, CacheListenerScope.ALL);
    }

    public void clearCache() {
        this._multiVMPortalCache.removeAll();
        this._singleVMPortalCache.removeAll();
    }

    public void clearCache(String templateId) {
        this._multiVMPortalCache.remove((Serializable)((Object)templateId));
        this._singleVMPortalCache.remove((Serializable)((Object)templateId));
    }

    public void destroy() {
        this._multiVMPortalCache.destroy();
        this._singleVMPortalCache.destroy();
        this._templateResourceParsers.clear();
    }

    public String getName() {
        return this._name;
    }

    public TemplateResource getTemplateResource(String templateId) {
        if (this._modificationCheckInterval == 0L) {
            return this._loadFromParser(templateId);
        }
        TemplateResource templateResource = this._loadFromCache(templateId);
        if (templateResource != null) {
            if (templateResource instanceof NullHolderTemplateResource) {
                return null;
            }
            return templateResource;
        }
        templateResource = this._loadFromParser(templateId);
        this._updateCache(templateId, templateResource);
        return templateResource;
    }

    public boolean hasTemplateResource(String templateId) {
        TemplateResource templateResource = this.getTemplateResource(templateId);
        return templateResource != null;
    }

    private TemplateResource _loadFromCache(PortalCache<String, TemplateResource> portalCache, String templateId) {
        Object object = portalCache.get((Serializable)((Object)templateId));
        if (object == null) {
            return null;
        }
        if (!(object instanceof TemplateResource)) {
            portalCache.remove((Serializable)((Object)templateId));
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Remove template " + templateId + " because it is not a template resource"));
            }
            return null;
        }
        TemplateResource templateResource = (TemplateResource)object;
        if (this._modificationCheckInterval > 0L) {
            long expireTime = templateResource.getLastModified() + this._modificationCheckInterval;
            if (System.currentTimeMillis() > expireTime) {
                portalCache.remove((Serializable)((Object)templateId));
                templateResource = _nullHolderTemplateResource;
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Remove expired template resource " + templateId));
                }
            }
        }
        return templateResource;
    }

    private TemplateResource _loadFromCache(String templateId) {
        TemplateResource templateResource = this._loadFromCache(this._singleVMPortalCache, templateId);
        if (templateResource != null) {
            if (templateResource == _nullHolderTemplateResource) {
                return null;
            }
            return templateResource;
        }
        templateResource = this._loadFromCache(this._multiVMPortalCache, templateId);
        if (templateResource == null || templateResource == _nullHolderTemplateResource) {
            return null;
        }
        return templateResource;
    }

    private TemplateResource _loadFromParser(String templateId) {
        for (TemplateResourceParser templateResourceParser : this._templateResourceParsers) {
            try {
                TemplateResource templateResource = templateResourceParser.getTemplateResource(templateId);
                if (templateResource == null) continue;
                if (!(this._modificationCheckInterval == 0L || this._name.equals("vm") && templateId.contains("-SANDBOX-"))) {
                    templateResource = new CacheTemplateResource(templateResource);
                }
                return templateResource;
            }
            catch (TemplateException te) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("Unable to parse template " + templateId + " with parser " + templateResourceParser), (Throwable)te);
            }
        }
        return null;
    }

    private void _updateCache(String templateId, TemplateResource templateResource) {
        if (templateResource == null) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)new NullHolderTemplateResource());
            return;
        }
        CacheTemplateResource cacheTemplateResource = (CacheTemplateResource)templateResource;
        TemplateResource innerTemplateResource = cacheTemplateResource.getInnerTemplateResource();
        if (innerTemplateResource instanceof URLTemplateResource) {
            this._singleVMPortalCache.put((Serializable)((Object)templateId), (Object)templateResource);
            return;
        }
        this._multiVMPortalCache.put((Serializable)((Object)templateId), (Object)templateResource);
    }

    private static class NullHolderTemplateResource
    implements TemplateResource {
        private long _lastModified = System.currentTimeMillis();

        public long getLastModified() {
            return this._lastModified;
        }

        public Reader getReader() {
            return null;
        }

        public String getTemplateId() {
            return null;
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this._lastModified = objectInput.readLong();
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeLong(this._lastModified);
        }
    }
}

