/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.service.impl;

import com.liferay.portal.kernel.dao.jdbc.OutputBlob;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.StreamUtil;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.documentlibrary.NoSuchContentException;
import com.liferay.portlet.documentlibrary.model.DLContent;
import com.liferay.portlet.documentlibrary.service.base.DLContentLocalServiceBaseImpl;
import com.liferay.portlet.documentlibrary.util.comparator.DLContentVersionComparator;
import java.io.InputStream;
import java.sql.Blob;
import java.util.List;

public class DLContentLocalServiceImpl
extends DLContentLocalServiceBaseImpl {
    public DLContent addContent(long companyId, long repositoryId, String path, String version, byte[] bytes) throws SystemException {
        long contentId = this.counterLocalService.increment();
        DLContent dlContent = this.dlContentPersistence.create(contentId);
        dlContent.setCompanyId(companyId);
        dlContent.setRepositoryId(repositoryId);
        dlContent.setPath(path);
        dlContent.setVersion(version);
        UnsyncByteArrayInputStream unsyncByteArrayInputStream = new UnsyncByteArrayInputStream(bytes);
        OutputBlob dataOutputBlob = new OutputBlob((InputStream)unsyncByteArrayInputStream, (long)bytes.length);
        dlContent.setData((Blob)dataOutputBlob);
        dlContent.setSize((long)bytes.length);
        this.dlContentPersistence.update((BaseModel)dlContent);
        return dlContent;
    }

    public DLContent addContent(long companyId, long repositoryId, String path, String version, InputStream inputStream, long size) throws SystemException {
        try {
            long contentId = this.counterLocalService.increment();
            DLContent dlContent = this.dlContentPersistence.create(contentId);
            dlContent.setCompanyId(companyId);
            dlContent.setRepositoryId(repositoryId);
            dlContent.setPath(path);
            dlContent.setVersion(version);
            OutputBlob dataOutputBlob = new OutputBlob(inputStream, size);
            dlContent.setData((Blob)dataOutputBlob);
            dlContent.setSize(size);
            this.dlContentPersistence.update((BaseModel)dlContent);
            DLContent dLContent = dlContent;
            return dLContent;
        }
        finally {
            StreamUtil.cleanUp((InputStream)inputStream);
        }
    }

    public void deleteContent(long companyId, long repositoryId, String path, String version) throws PortalException, SystemException {
        this.dlContentPersistence.removeByC_R_P_V(companyId, repositoryId, path, version);
    }

    public void deleteContents(long companyId, long repositoryId, String path) throws SystemException {
        this.dlContentPersistence.removeByC_R_P(companyId, repositoryId, path);
    }

    public void deleteContentsByDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        this.dlContentPersistence.removeByC_R_LikeP(companyId, repositoryId, dirName);
    }

    public DLContent getContent(long companyId, long repositoryId, String path) throws NoSuchContentException, SystemException {
        DLContentVersionComparator orderByComparator = new DLContentVersionComparator();
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path, 0, 1, (OrderByComparator)orderByComparator);
        if (dlContents == null || dlContents.isEmpty()) {
            throw new NoSuchContentException(path);
        }
        return (DLContent)dlContents.get(0);
    }

    public DLContent getContent(long companyId, long repositoryId, String path, String version) throws NoSuchContentException, SystemException {
        return this.dlContentPersistence.findByC_R_P_V(companyId, repositoryId, path, version);
    }

    public List<DLContent> getContents(long companyId, long repositoryId) throws SystemException {
        return this.dlContentPersistence.findByC_R(companyId, repositoryId);
    }

    public List<DLContent> getContents(long companyId, long repositoryId, String path) throws SystemException {
        return this.dlContentPersistence.findByC_R_P(companyId, repositoryId, path);
    }

    public List<DLContent> getContentsByDirectory(long companyId, long repositoryId, String dirName) throws SystemException {
        if (!dirName.endsWith("/")) {
            dirName = dirName.concat("/");
        }
        dirName = dirName.concat("%");
        return this.dlContentPersistence.findByC_R_LikeP(companyId, repositoryId, dirName);
    }

    public boolean hasContent(long companyId, long repositoryId, String path, String version) throws SystemException {
        int count = this.dlContentPersistence.countByC_R_P_V(companyId, repositoryId, path, version);
        return count > 0;
    }

    public void updateDLContent(long companyId, long oldRepositoryId, long newRepositoryId, String oldPath, String newPath) throws SystemException {
        List dlContents = this.dlContentPersistence.findByC_R_P(companyId, oldRepositoryId, oldPath);
        for (DLContent dLContent : dlContents) {
            dLContent.setRepositoryId(newRepositoryId);
            dLContent.setPath(newPath);
            this.dlContentPersistence.update((BaseModel)dLContent);
        }
    }
}

