/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.service.impl;

import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.model.BaseModel;
import com.liferay.portlet.journal.model.JournalArticleResource;
import com.liferay.portlet.journal.service.base.JournalArticleResourceLocalServiceBaseImpl;
import java.util.List;

public class JournalArticleResourceLocalServiceImpl
extends JournalArticleResourceLocalServiceBaseImpl {
    public void deleteArticleResource(long groupId, String articleId) throws PortalException, SystemException {
        this.journalArticleResourcePersistence.removeByG_A(groupId, articleId);
    }

    public JournalArticleResource fetchArticleResource(long groupId, String articleId) throws SystemException {
        return this.journalArticleResourcePersistence.fetchByG_A(groupId, articleId);
    }

    public JournalArticleResource fetchArticleResource(String uuid, long groupId) throws SystemException {
        return this.journalArticleResourcePersistence.fetchByUUID_G(uuid, groupId);
    }

    public JournalArticleResource getArticleResource(long articleResourcePrimKey) throws PortalException, SystemException {
        return this.journalArticleResourcePersistence.findByPrimaryKey(articleResourcePrimKey);
    }

    public long getArticleResourcePrimKey(long groupId, String articleId) throws SystemException {
        return this.getArticleResourcePrimKey(null, groupId, articleId);
    }

    public long getArticleResourcePrimKey(String uuid, long groupId, String articleId) throws SystemException {
        JournalArticleResource articleResource = null;
        if (Validator.isNotNull((String)uuid)) {
            articleResource = this.journalArticleResourcePersistence.fetchByUUID_G(uuid, groupId);
        }
        if (articleResource == null) {
            articleResource = this.journalArticleResourcePersistence.fetchByG_A(groupId, articleId);
        }
        if (articleResource == null) {
            long articleResourcePrimKey = this.counterLocalService.increment();
            articleResource = this.journalArticleResourcePersistence.create(articleResourcePrimKey);
            if (Validator.isNotNull((String)uuid)) {
                articleResource.setUuid(uuid);
            }
            articleResource.setGroupId(groupId);
            articleResource.setArticleId(articleId);
            this.journalArticleResourcePersistence.update((BaseModel)articleResource);
        }
        return articleResource.getResourcePrimKey();
    }

    public List<JournalArticleResource> getArticleResources(long groupId) throws SystemException {
        return this.journalArticleResourcePersistence.findByGroupId(groupId);
    }
}

