/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.io;

import com.liferay.portal.kernel.nio.charset.CharsetDecoderUtil;
import com.liferay.portal.kernel.util.StringPool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

public class WriterOutputStream
extends OutputStream {
    private static final int _DEFAULT_INTPUT_BUFFER_SIZE = 128;
    private static final int _DEFAULT_OUTPUT_BUFFER_SIZE = 1024;
    private boolean _autoFlush;
    private CharsetDecoder _charsetDecoder;
    private String _charsetName;
    private ByteBuffer _inputBuffer;
    private CharBuffer _outputBuffer;
    private Writer _writer;

    public WriterOutputStream(Writer writer) {
        this(writer, "UTF-8", 128, 1024, false);
    }

    public WriterOutputStream(Writer writer, String charsetName) {
        this(writer, charsetName, 128, 1024, false);
    }

    public WriterOutputStream(Writer writer, String charsetName, boolean autoFlush) {
        this(writer, charsetName, 128, 1024, autoFlush);
    }

    public WriterOutputStream(Writer writer, String charsetName, int inputBufferSize, int outputBufferSize) {
        this(writer, charsetName, inputBufferSize, outputBufferSize, false);
    }

    public WriterOutputStream(Writer writer, String charsetName, int inputBufferSize, int outputBufferSize, boolean autoFlush) {
        if (inputBufferSize < 4) {
            throw new IllegalArgumentException("Input buffer size " + inputBufferSize + " is less than 4");
        }
        if (outputBufferSize <= 0) {
            throw new IllegalArgumentException("Output buffer size " + outputBufferSize + " must be a positive number");
        }
        if (charsetName == null) {
            charsetName = StringPool.DEFAULT_CHARSET_NAME;
        }
        this._writer = writer;
        this._charsetName = charsetName;
        this._charsetDecoder = CharsetDecoderUtil.getCharsetDecoder(charsetName);
        this._inputBuffer = ByteBuffer.allocate(inputBufferSize);
        this._outputBuffer = CharBuffer.allocate(outputBufferSize);
        this._autoFlush = autoFlush;
    }

    @Override
    public void close() throws IOException {
        this._doDecode(true);
        this._doFlush();
        this._writer.close();
    }

    @Override
    public void flush() throws IOException {
        this._doFlush();
        this._writer.flush();
    }

    public String getEncoding() {
        return this._charsetName;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        while (length > 0) {
            int blockSize = Math.min(length, this._inputBuffer.remaining());
            this._inputBuffer.put(bytes, offset, blockSize);
            this._doDecode(false);
            length -= blockSize;
            offset += blockSize;
        }
        if (this._autoFlush) {
            this._doFlush();
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
    }

    private void _doDecode(boolean endOfInput) throws IOException {
        CoderResult coderResult;
        this._inputBuffer.flip();
        while ((coderResult = this._charsetDecoder.decode(this._inputBuffer, this._outputBuffer, endOfInput)).isOverflow()) {
            this._doFlush();
        }
        if (!coderResult.isUnderflow()) {
            throw new IOException("Unexcepted coder result " + coderResult);
        }
        this._inputBuffer.compact();
    }

    private void _doFlush() throws IOException {
        if (this._outputBuffer.position() > 0) {
            this._writer.write(this._outputBuffer.array(), 0, this._outputBuffer.position());
            this._outputBuffer.rewind();
        }
    }
}

