/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.journal.model;

import com.liferay.portal.LocaleException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.xml.Document;
import com.liferay.portal.kernel.xml.Element;
import com.liferay.portal.kernel.xml.Node;
import com.liferay.portal.kernel.xml.SAXReaderUtil;
import com.liferay.portal.service.ServiceContext;
import com.liferay.portal.util.PortalUtil;
import com.liferay.portlet.dynamicdatamapping.model.DDMStructure;
import com.liferay.portlet.dynamicdatamapping.service.DDMStructureLocalServiceUtil;
import com.liferay.portlet.expando.model.ExpandoBridge;
import com.liferay.portlet.journal.model.JournalArticle;
import com.liferay.portlet.journal.model.JournalStructure;
import com.liferay.portlet.journal.service.JournalStructureLocalServiceUtil;
import com.liferay.portlet.journal.util.JournalConverterUtil;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JournalStructureAdapter
implements JournalStructure {
    private static Log _log = LogFactoryUtil.getLog(JournalStructureAdapter.class);
    private DDMStructure _ddmStructure;
    private String _xsd;

    public JournalStructureAdapter(DDMStructure ddmStructure) throws SystemException {
        this._ddmStructure = ddmStructure;
        this._setXsd(ddmStructure.getXsd());
    }

    @Override
    public Object clone() {
        JournalStructureAdapter journalStructureAdapter = new JournalStructureAdapter();
        journalStructureAdapter.setUuid(this.getUuid());
        journalStructureAdapter.setId(this.getId());
        journalStructureAdapter.setGroupId(this.getGroupId());
        journalStructureAdapter.setCompanyId(this.getCompanyId());
        journalStructureAdapter.setUserId(this.getUserId());
        journalStructureAdapter.setUserName(this.getUserName());
        journalStructureAdapter.setCreateDate(this.getCreateDate());
        journalStructureAdapter.setModifiedDate(this.getModifiedDate());
        journalStructureAdapter.setStructureId(this.getStructureId());
        journalStructureAdapter.setParentStructureId(this.getParentStructureId());
        journalStructureAdapter.setName(this.getName());
        journalStructureAdapter.setDescription(this.getDescription());
        journalStructureAdapter.setXsd(this.getXsd());
        return journalStructureAdapter;
    }

    @Override
    public int compareTo(JournalStructure journalStructure) {
        String structureId = this.getStructureId();
        int value = structureId.compareTo(journalStructure.getStructureId());
        if (value != 0) {
            return value;
        }
        return 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof JournalStructure)) {
            return false;
        }
        JournalStructure journalStructure = (JournalStructure)obj;
        return Validator.equals(this.getId(), journalStructure.getId());
    }

    @Override
    public long getCompanyId() {
        return this._ddmStructure.getCompanyId();
    }

    @Override
    public Date getCreateDate() {
        return this._ddmStructure.getCreateDate();
    }

    @Override
    public String getDescription() {
        return this._ddmStructure.getDescription();
    }

    @Override
    public String getDescription(Locale locale) {
        return this._ddmStructure.getDescription(locale);
    }

    @Override
    public String getDescription(Locale locale, boolean useDefault) {
        return this._ddmStructure.getDescription(locale, useDefault);
    }

    @Override
    public String getDescription(String languageId) {
        return this._ddmStructure.getDescription(languageId);
    }

    @Override
    public String getDescription(String languageId, boolean useDefault) {
        return this._ddmStructure.getDescription(languageId, useDefault);
    }

    @Override
    public String getDescriptionCurrentLanguageId() {
        return this._ddmStructure.getDescriptionCurrentLanguageId();
    }

    @Override
    public String getDescriptionCurrentValue() {
        return this._ddmStructure.getDescriptionCurrentValue();
    }

    @Override
    public Map<Locale, String> getDescriptionMap() {
        return this._ddmStructure.getDescriptionMap();
    }

    @Override
    public ExpandoBridge getExpandoBridge() {
        return this._ddmStructure.getExpandoBridge();
    }

    @Override
    public long getGroupId() {
        return this._ddmStructure.getGroupId();
    }

    @Override
    public long getId() {
        return this._ddmStructure.getStructureId();
    }

    @Override
    public String getMergedXsd() {
        String parentStructureId = this.getParentStructureId();
        String xsd = this.getXsd();
        if (Validator.isNull(parentStructureId)) {
            return xsd;
        }
        try {
            JournalStructure parentStructure = JournalStructureLocalServiceUtil.getStructure(this.getGroupId(), parentStructureId, true);
            Document document = SAXReaderUtil.read(this.getXsd());
            Element rootElement = document.getRootElement();
            Document parentDocument = SAXReaderUtil.read(parentStructure.getMergedXsd());
            Element parentRootElement = parentDocument.getRootElement();
            this.addParentStructureId(parentRootElement, parentStructureId);
            List<Node> nodes = rootElement.content();
            nodes.addAll(0, parentRootElement.content());
            xsd = rootElement.asXML();
        }
        catch (Exception exception) {}
        return xsd;
    }

    @Override
    public Map<String, Object> getModelAttributes() {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("uuid", this.getUuid());
        attributes.put("id", this.getId());
        attributes.put("groupId", this.getGroupId());
        attributes.put("companyId", this.getCompanyId());
        attributes.put("userId", this.getUserId());
        attributes.put("userName", this.getUserName());
        attributes.put("createDate", this.getCreateDate());
        attributes.put("modifiedDate", this.getModifiedDate());
        attributes.put("structureId", this.getStructureId());
        attributes.put("parentStructureId", this.getParentStructureId());
        attributes.put("name", this.getName());
        attributes.put("description", this.getDescription());
        attributes.put("xsd", this.getXsd());
        return attributes;
    }

    @Override
    public Class<?> getModelClass() {
        return JournalStructure.class;
    }

    @Override
    public String getModelClassName() {
        return JournalStructure.class.getName();
    }

    @Override
    public Date getModifiedDate() {
        return this._ddmStructure.getModifiedDate();
    }

    @Override
    public String getName() {
        return this._ddmStructure.getName();
    }

    @Override
    public String getName(Locale locale) {
        return this._ddmStructure.getName(locale);
    }

    @Override
    public String getName(Locale locale, boolean useDefault) {
        return this._ddmStructure.getName(locale, useDefault);
    }

    @Override
    public String getName(String languageId) {
        return this._ddmStructure.getName(languageId);
    }

    @Override
    public String getName(String languageId, boolean useDefault) {
        return this._ddmStructure.getName(languageId, useDefault);
    }

    @Override
    public String getNameCurrentLanguageId() {
        return this._ddmStructure.getNameCurrentLanguageId();
    }

    @Override
    public String getNameCurrentValue() {
        return this._ddmStructure.getNameCurrentValue();
    }

    @Override
    public Map<Locale, String> getNameMap() {
        return this._ddmStructure.getNameMap();
    }

    @Override
    public String getParentStructureId() {
        if (this._ddmStructure.getParentStructureId() == 0L) {
            return null;
        }
        try {
            DDMStructure parentDDMStructure = DDMStructureLocalServiceUtil.getStructure(this._ddmStructure.getParentStructureId());
            return parentDDMStructure.getStructureKey();
        }
        catch (Exception e) {
            _log.error(e, e);
            return null;
        }
    }

    @Override
    public long getPrimaryKey() {
        return this._ddmStructure.getPrimaryKey();
    }

    @Override
    public Serializable getPrimaryKeyObj() {
        return this._ddmStructure.getPrimaryKeyObj();
    }

    @Override
    public String getStructureId() {
        return this._ddmStructure.getStructureKey();
    }

    @Override
    public long getUserId() {
        return this._ddmStructure.getUserId();
    }

    @Override
    public String getUserName() {
        return this._ddmStructure.getUserName();
    }

    @Override
    public String getUserUuid() throws SystemException {
        return this._ddmStructure.getUserUuid();
    }

    @Override
    public String getUuid() {
        return this._ddmStructure.getUuid();
    }

    @Override
    public String getXsd() {
        return this._xsd;
    }

    @Override
    public int hashCode() {
        return (int)this.getPrimaryKey();
    }

    @Override
    public boolean isNew() {
        return this._ddmStructure.isNew();
    }

    @Override
    public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
        this._ddmStructure.prepareLocalizedFieldsForImport(defaultImportLocale);
    }

    @Override
    public void setCompanyId(long companyId) {
        this._ddmStructure.setCompanyId(companyId);
    }

    @Override
    public void setCreateDate(Date createDate) {
        this._ddmStructure.setCreateDate(createDate);
    }

    @Override
    public void setDescription(String description) {
        this._ddmStructure.setDescription(description);
    }

    @Override
    public void setDescription(String description, Locale locale) {
        this._ddmStructure.setDescription(description, locale);
    }

    @Override
    public void setDescription(String description, Locale locale, Locale defaultLocale) {
        this._ddmStructure.setDescription(description, locale, defaultLocale);
    }

    @Override
    public void setDescriptionCurrentLanguageId(String languageId) {
        this._ddmStructure.setDescriptionCurrentLanguageId(languageId);
    }

    @Override
    public void setDescriptionMap(Map<Locale, String> descriptionMap) {
        this._ddmStructure.setDescriptionMap(descriptionMap);
    }

    @Override
    public void setDescriptionMap(Map<Locale, String> descriptionMap, Locale defaultLocale) {
        this._ddmStructure.setDescriptionMap(descriptionMap, defaultLocale);
    }

    @Override
    public void setExpandoBridgeAttributes(ExpandoBridge expandoBridge) {
        this._ddmStructure.setExpandoBridgeAttributes(expandoBridge);
    }

    @Override
    public void setExpandoBridgeAttributes(JournalStructure journalStructure) {
        ExpandoBridge expandoBridge = this.getExpandoBridge();
        ExpandoBridge journalStructureExpandoBridge = journalStructure.getExpandoBridge();
        expandoBridge.setAttributes(journalStructureExpandoBridge.getAttributes());
    }

    @Override
    public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
        this._ddmStructure.setExpandoBridgeAttributes(serviceContext);
    }

    @Override
    public void setGroupId(long groupId) {
        this._ddmStructure.setGroupId(groupId);
    }

    @Override
    public void setId(long id) {
        this._ddmStructure.setStructureId(id);
    }

    @Override
    public void setModelAttributes(Map<String, Object> attributes) {
        String xsd;
        String description;
        String name;
        String parentStructureId;
        String structureId;
        Date modifiedDate;
        Date createDate;
        String userName;
        Long userId;
        Long companyId;
        Long groupId;
        Long id;
        String uuid = (String)attributes.get("uuid");
        if (uuid != null) {
            this.setUuid(uuid);
        }
        if ((id = (Long)attributes.get("id")) != null) {
            this.setId(id);
        }
        if ((groupId = (Long)attributes.get("groupId")) != null) {
            this.setGroupId(groupId);
        }
        if ((companyId = (Long)attributes.get("companyId")) != null) {
            this.setCompanyId(companyId);
        }
        if ((userId = (Long)attributes.get("userId")) != null) {
            this.setUserId(userId);
        }
        if ((userName = (String)attributes.get("userName")) != null) {
            this.setUserName(userName);
        }
        if ((createDate = (Date)attributes.get("createDate")) != null) {
            this.setCreateDate(createDate);
        }
        if ((modifiedDate = (Date)attributes.get("modifiedDate")) != null) {
            this.setModifiedDate(modifiedDate);
        }
        if ((structureId = (String)attributes.get("structureId")) != null) {
            this.setStructureId(structureId);
        }
        if ((parentStructureId = (String)attributes.get("parentStructureId")) != null) {
            this.setParentStructureId(parentStructureId);
        }
        if ((name = (String)attributes.get("name")) != null) {
            this.setName(name);
        }
        if ((description = (String)attributes.get("description")) != null) {
            this.setDescription(description);
        }
        if ((xsd = (String)attributes.get("xsd")) != null) {
            this.setXsd(xsd);
        }
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this._ddmStructure.setModifiedDate(modifiedDate);
    }

    @Override
    public void setName(String name) {
        this._ddmStructure.setName(name);
    }

    @Override
    public void setName(String name, Locale locale) {
        this._ddmStructure.setName(name, locale);
    }

    @Override
    public void setName(String name, Locale locale, Locale defaultLocale) {
        this._ddmStructure.setName(name, locale, defaultLocale);
    }

    @Override
    public void setNameCurrentLanguageId(String languageId) {
        this._ddmStructure.setNameCurrentLanguageId(languageId);
    }

    @Override
    public void setNameMap(Map<Locale, String> nameMap) {
        this._ddmStructure.setNameMap(nameMap);
    }

    @Override
    public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
        this._ddmStructure.setNameMap(nameMap, defaultLocale);
    }

    @Override
    public void setNew(boolean n) {
        this._ddmStructure.setNew(n);
    }

    @Override
    public void setParentStructureId(String parentStructureId) {
        if (parentStructureId == null) {
            this._ddmStructure.setParentStructureId(0L);
        }
        try {
            DDMStructure parentDDMStructure = DDMStructureLocalServiceUtil.getStructure(this.getGroupId(), PortalUtil.getClassNameId(JournalArticle.class.getName()), parentStructureId);
            this._ddmStructure.setParentStructureId(parentDDMStructure.getStructureId());
        }
        catch (Exception e) {
            _log.error(e, e);
        }
    }

    @Override
    public void setPrimaryKey(long primaryKey) {
        this._ddmStructure.setPrimaryKey(primaryKey);
    }

    @Override
    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        this._ddmStructure.setPrimaryKeyObj(primaryKeyObj);
    }

    @Override
    public void setStructureId(String structureId) {
        this._ddmStructure.setStructureKey(structureId);
    }

    @Override
    public void setUserId(long userId) {
        this._ddmStructure.setUserId(userId);
    }

    @Override
    public void setUserName(String userName) {
        this._ddmStructure.setUserName(userName);
    }

    @Override
    public void setUserUuid(String userUuid) {
        this._ddmStructure.setUserUuid(userUuid);
    }

    @Override
    public void setUuid(String uuid) {
        this._ddmStructure.setUuid(uuid);
    }

    @Override
    public void setXsd(String xsd) {
        this._xsd = xsd;
    }

    public String toString() {
        StringBundler sb = new StringBundler(27);
        sb.append("{uuid=");
        sb.append(this.getUuid());
        sb.append(", id=");
        sb.append(this.getId());
        sb.append(", groupId=");
        sb.append(this.getGroupId());
        sb.append(", companyId=");
        sb.append(this.getCompanyId());
        sb.append(", userId=");
        sb.append(this.getUserId());
        sb.append(", userName=");
        sb.append(this.getUserName());
        sb.append(", createDate=");
        sb.append(this.getCreateDate());
        sb.append(", modifiedDate=");
        sb.append(this.getModifiedDate());
        sb.append(", structureId=");
        sb.append(this.getStructureId());
        sb.append(", parentStructureId=");
        sb.append(this.getParentStructureId());
        sb.append(", name=");
        sb.append(this.getName());
        sb.append(", description=");
        sb.append(this.getDescription());
        sb.append(", xsd=");
        sb.append(this.getXsd());
        sb.append("}");
        return sb.toString();
    }

    protected void addParentStructureId(Element parentElement, String parentStructureId) {
        List<Element> dynamicElementElements = parentElement.elements("dynamic-element");
        for (Element dynamicElementElement : dynamicElementElements) {
            dynamicElementElement.addAttribute("parent-structure-id", parentStructureId);
            this.addParentStructureId(dynamicElementElement, parentStructureId);
        }
    }

    private JournalStructureAdapter() {
    }

    private void _setXsd(String ddmXsd) throws SystemException {
        if (Validator.isNull(ddmXsd)) {
            return;
        }
        try {
            this._xsd = JournalConverterUtil.getJournalXSD(ddmXsd);
        }
        catch (Exception e) {
            throw new SystemException(e);
        }
    }
}

