/*
 * Decompiled with CFR 0.152.
 */
package org.apache.abdera.protocol.server.filters;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.abdera.protocol.server.Filter;
import org.apache.abdera.protocol.server.FilterChain;
import org.apache.abdera.protocol.server.RequestContext;
import org.apache.abdera.protocol.server.ResponseContext;
import org.apache.abdera.protocol.server.Target;
import org.apache.abdera.protocol.server.TargetType;
import org.apache.abdera.protocol.server.context.StreamWriterResponseContext;
import org.apache.abdera.writer.StreamWriter;

public class OpenSearchFilter
implements Filter {
    public static final String OSDNS = "http://a9.com/-/spec/opensearch/1.1/";
    public static final String OS_PREFIX = "OpenSearch_";
    public static final TargetType TYPE_OPENSEARCH_DESCRIPTION = TargetType.get("OPENSEARCH_DESCRIPTION", true);
    private String shortName;
    private String description;
    private String[] tags;
    private String contact;
    private String template;
    private Map<String, String> map = new HashMap<String, String>();

    public String getShortName() {
        return this.shortName;
    }

    public OpenSearchFilter setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public OpenSearchFilter setDescription(String description) {
        this.description = description;
        return this;
    }

    public String[] getTags() {
        return this.tags;
    }

    public OpenSearchFilter setTags(String ... tags) {
        this.tags = tags;
        return this;
    }

    public String getContact() {
        return this.contact;
    }

    public OpenSearchFilter setContact(String contact) {
        this.contact = contact;
        return this;
    }

    public String getTemplate() {
        return this.template;
    }

    public OpenSearchFilter setTemplate(String template) {
        this.template = template;
        return this;
    }

    public OpenSearchFilter mapTargetParameter(String targetParam, String openSearchParam) {
        this.map.put(targetParam, openSearchParam);
        return this;
    }

    public ResponseContext filter(RequestContext request, FilterChain chain) {
        Target target = request.getTarget();
        TargetType type = target.getType();
        if (type == TYPE_OPENSEARCH_DESCRIPTION) {
            return this.getOpenSearchDescription(request);
        }
        for (Map.Entry<String, String> entry : this.map.entrySet()) {
            String value = target.getParameter(entry.getKey());
            if (value == null) continue;
            request.setAttribute("OpenSearch__" + entry.getValue(), value);
        }
        return chain.next(request);
    }

    private String combineTags() {
        if (this.tags == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        for (String tag : this.tags) {
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(tag);
        }
        return buf.toString();
    }

    private ResponseContext getOpenSearchDescription(RequestContext request) {
        return new StreamWriterResponseContext(request.getAbdera()){

            protected void writeTo(StreamWriter sw) throws IOException {
                sw.startDocument().startElement("OpenSearchDescription", OpenSearchFilter.OSDNS, "").startElement("ShortName", OpenSearchFilter.OSDNS, "").writeElementText(OpenSearchFilter.this.getShortName()).endElement().startElement("Description", OpenSearchFilter.OSDNS, "").writeElementText(OpenSearchFilter.this.getDescription()).endElement().startElement("Tags", OpenSearchFilter.OSDNS, "").writeElementText(OpenSearchFilter.this.combineTags()).endElement().startElement("Contact", OpenSearchFilter.OSDNS, "").writeElementText(OpenSearchFilter.this.getContact()).endElement().startElement("Url", OpenSearchFilter.OSDNS, "").writeAttribute("type", "application/atom+xml").writeAttribute("template", OpenSearchFilter.this.getTemplate()).endElement().endElement().endDocument();
            }
        }.setStatus(200).setContentType("application/opensearchdescription+xml");
    }
}

